/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.resolver;

import io.fabric8.agent.resolver.CandidateComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wiring;
import org.osgi.service.repository.Repository;
import org.osgi.service.resolver.HostedCapability;
import org.osgi.service.resolver.ResolveContext;

public class ResolveContextImpl
extends ResolveContext {
    private final Set<Resource> mandatory;
    private final Set<Resource> optional;
    private final Repository repository;
    private final Map<Resource, Wiring> wirings;
    private final boolean resolveOptional;
    private final CandidateComparator candidateComparator = new CandidateComparator();

    public ResolveContextImpl(Set<Resource> mandatory, Set<Resource> optional, Repository repository, boolean resolveOptional) {
        this.mandatory = mandatory;
        this.optional = optional;
        this.repository = repository;
        this.wirings = new HashMap<Resource, Wiring>();
        this.resolveOptional = resolveOptional;
    }

    @Override
    public Collection<Resource> getMandatoryResources() {
        return this.mandatory;
    }

    @Override
    public Collection<Resource> getOptionalResources() {
        return this.optional;
    }

    @Override
    public List<Capability> findProviders(Requirement requirement) {
        Collection<Capability> res;
        ArrayList<Capability> caps = new ArrayList<Capability>();
        Map<Requirement, Collection<Capability>> resMap = this.repository.findProviders(Collections.singleton(requirement));
        Collection<Capability> collection = res = resMap != null ? resMap.get(requirement) : null;
        if (res != null) {
            caps.addAll(res);
        }
        Collections.sort(caps, this.candidateComparator);
        return caps;
    }

    public int insertHostedCapability(List capabilities, HostedCapability hostedCapability) {
        for (int i = 0; i < capabilities.size(); ++i) {
            Capability cap = (Capability)capabilities.get(i);
            if (this.candidateComparator.compare(hostedCapability, cap) > 0) continue;
            capabilities.add(i, hostedCapability);
            return i;
        }
        capabilities.add(hostedCapability);
        return capabilities.size() - 1;
    }

    @Override
    public boolean isEffective(Requirement requirement) {
        return this.resolveOptional || !"optional".equals(requirement.getDirectives().get("resolution"));
    }

    @Override
    public Map<Resource, Wiring> getWirings() {
        return this.wirings;
    }
}

