/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.service.repository.Repository;

public class CacheRepository
implements Repository {
    private final Repository repository;
    private final Map<Requirement, Collection<Capability>> cache = new ConcurrentHashMap<Requirement, Collection<Capability>>();

    public CacheRepository(Repository repository) {
        this.repository = repository;
    }

    @Override
    public Map<Requirement, Collection<Capability>> findProviders(Collection<? extends Requirement> requirements) {
        ArrayList<Requirement> missing = new ArrayList<Requirement>();
        HashMap<Requirement, Collection<Capability>> result = new HashMap<Requirement, Collection<Capability>>();
        for (Requirement requirement : requirements) {
            Collection<Capability> caps = this.cache.get(requirement);
            if (caps == null) {
                missing.add(requirement);
                continue;
            }
            result.put(requirement, caps);
        }
        Map<Requirement, Collection<Capability>> newCache = this.repository.findProviders(missing);
        for (Requirement requirement : newCache.keySet()) {
            this.cache.put(requirement, newCache.get(requirement));
            result.put(requirement, newCache.get(requirement));
        }
        return result;
    }
}

