/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent;

import aQute.lib.osgi.Macro;
import aQute.lib.osgi.Processor;
import io.fabric8.agent.DeploymentBuilder;
import io.fabric8.agent.StreamProvider;
import io.fabric8.agent.download.DownloadFuture;
import io.fabric8.agent.download.DownloadManager;
import io.fabric8.agent.mvn.DictionaryPropertyResolver;
import io.fabric8.agent.mvn.MavenConfigurationImpl;
import io.fabric8.agent.mvn.MavenRepositoryURL;
import io.fabric8.agent.mvn.MavenSettingsImpl;
import io.fabric8.agent.mvn.Parser;
import io.fabric8.agent.mvn.PropertiesPropertyResolver;
import io.fabric8.agent.mvn.PropertyStore;
import io.fabric8.agent.repository.HttpMetadataProvider;
import io.fabric8.agent.repository.MetadataRepository;
import io.fabric8.agent.resolver.FeatureResource;
import io.fabric8.agent.resolver.UriNamespace;
import io.fabric8.agent.sort.RequirementSort;
import io.fabric8.agent.utils.AgentUtils;
import io.fabric8.agent.utils.MultiException;
import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.fab.MavenResolver;
import io.fabric8.fab.MavenResolverImpl;
import io.fabric8.fab.osgi.ServiceConstants;
import io.fabric8.fab.osgi.internal.Configuration;
import io.fabric8.fab.osgi.internal.FabResolverFactoryImpl;
import io.fabric8.fab.osgi.internal.OsgiModuleRegistry;
import io.fabric8.utils.ChecksumUtils;
import io.fabric8.utils.Files;
import io.fabric8.utils.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.apache.felix.framework.monitor.MonitoringService;
import org.apache.felix.resolver.Util;
import org.apache.felix.utils.version.VersionRange;
import org.apache.felix.utils.version.VersionTable;
import org.apache.karaf.features.Repository;
import org.apache.karaf.features.internal.FeaturesServiceImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.resource.Capability;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.url.URLStreamHandlerService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentAgent
implements ManagedService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeploymentAgent.class);
    public static final String OBR_RESOLVE_OPTIONAL_IMPORTS = "obr.resolve.optional.imports";
    public static final String RESOLVE_OPTIONAL_IMPORTS = "resolve.optional.imports";
    public static final String URL_HANDLERS_TIMEOUT = "url.handlers.timeout";
    public static final String FABRIC_ZOOKEEPER_PID = "fabric.zookeeper.pid";
    private static final String SNAPSHOT = "SNAPSHOT";
    private static final String BLUEPRINT_PREFIX = "blueprint:";
    private static final String SPRING_PREFIX = "spring:";
    private static final String KARAF_HOME = System.getProperty("karaf.home");
    private static final String KARAF_BASE = System.getProperty("karaf.base");
    private static final String KARAF_DATA = System.getProperty("karaf.data");
    private static final String SYSTEM_PATH = KARAF_HOME + File.separator + "system";
    private static final String LIB_PATH = KARAF_BASE + File.separator + "lib";
    private static final String LIB_EXT_PATH = LIB_PATH + File.separator + "ext";
    private static final String LIB_ENDORSED_PATH = LIB_PATH + File.separator + "endorsed";
    private static final String AGENT_DOWNLOAD_PATH = KARAF_DATA + File.separator + "maven" + File.separator + "agent";
    private static final Pattern SNAPSHOT_PATTERN = Pattern.compile(".*-SNAPSHOT((\\.\\w{3})?|\\$.*|\\?.*|\\#.*|\\&.*)");
    private ServiceTracker<FabricService, FabricService> fabricService;
    private final ExecutorService executor = Executors.newSingleThreadExecutor(new NamedThreadFactory("fabric-agent"));
    private ExecutorService downloadExecutor;
    private volatile boolean shutdownDownloadExecutor;
    private DownloadManager manager;
    private boolean resolveOptionalImports = true;
    private long urlHandlersTimeout;
    private final RequirementSort requirementSort = new RequirementSort();
    private final BundleContext bundleContext;
    private final BundleContext systemBundleContext;
    private final org.apache.felix.utils.properties.Properties bundleChecksums;
    private final org.apache.felix.utils.properties.Properties libChecksums;
    private final org.apache.felix.utils.properties.Properties endorsedChecksums;
    private final org.apache.felix.utils.properties.Properties extensionChecksums;
    private Set<String> bundlesNotToStart;
    private final org.apache.felix.utils.properties.Properties managedLibs;
    private final org.apache.felix.utils.properties.Properties managedEndorsedLibs;
    private final org.apache.felix.utils.properties.Properties managedExtensionLibs;
    private final org.apache.felix.utils.properties.Properties managedSysProps;
    private final org.apache.felix.utils.properties.Properties managedConfigProps;
    private volatile String provisioningStatus;
    private volatile Throwable provisioningError;
    private volatile Collection<Resource> provisionList;

    public DeploymentAgent(BundleContext bundleContext) throws IOException {
        this.bundleContext = bundleContext;
        this.systemBundleContext = bundleContext.getBundle(0L).getBundleContext();
        this.bundleChecksums = new org.apache.felix.utils.properties.Properties(bundleContext.getDataFile("bundle-checksums.properties"));
        this.libChecksums = new org.apache.felix.utils.properties.Properties(bundleContext.getDataFile("lib-checksums.properties"));
        this.endorsedChecksums = new org.apache.felix.utils.properties.Properties(bundleContext.getDataFile("endorsed-checksums.properties"));
        this.extensionChecksums = new org.apache.felix.utils.properties.Properties(bundleContext.getDataFile("extension-checksums.properties"));
        this.managedSysProps = new org.apache.felix.utils.properties.Properties(bundleContext.getDataFile("system.properties"));
        this.managedConfigProps = new org.apache.felix.utils.properties.Properties(bundleContext.getDataFile("config.properties"));
        this.managedLibs = new org.apache.felix.utils.properties.Properties(bundleContext.getDataFile("libs.properties"));
        this.managedEndorsedLibs = new org.apache.felix.utils.properties.Properties(bundleContext.getDataFile("endorsed.properties"));
        this.managedExtensionLibs = new org.apache.felix.utils.properties.Properties(bundleContext.getDataFile("extension.properties"));
        MavenConfigurationImpl config = new MavenConfigurationImpl(new PropertiesPropertyResolver(System.getProperties()), "org.ops4j.pax.url.mvn");
        config.setSettings(new MavenSettingsImpl(config.getSettingsFileUrl(), config.useFallbackRepositories()));
        this.manager = new DownloadManager(config);
        this.fabricService = new ServiceTracker(this.systemBundleContext, FabricService.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<FabricService, FabricService>(){

            public FabricService addingService(ServiceReference<FabricService> reference) {
                FabricService service = (FabricService)DeploymentAgent.this.systemBundleContext.getService(reference);
                if (DeploymentAgent.this.provisioningStatus != null) {
                    DeploymentAgent.this.updateStatus(service, DeploymentAgent.this.provisioningStatus, DeploymentAgent.this.provisioningError, DeploymentAgent.this.provisionList, false);
                }
                return service;
            }

            public void modifiedService(ServiceReference<FabricService> reference, FabricService service) {
                if (DeploymentAgent.this.provisioningStatus != null) {
                    DeploymentAgent.this.updateStatus(service, DeploymentAgent.this.provisioningStatus, DeploymentAgent.this.provisioningError, DeploymentAgent.this.provisionList, false);
                }
            }

            public void removedService(ServiceReference<FabricService> reference, FabricService service) {
            }
        });
        this.fabricService.open();
    }

    static boolean getResolveOptionalImports(Dictionary<String, ?> config) {
        if (config != null) {
            String str = (String)config.get(OBR_RESOLVE_OPTIONAL_IMPORTS);
            if (str == null) {
                str = (String)config.get(RESOLVE_OPTIONAL_IMPORTS);
            }
            if (str != null) {
                return Boolean.parseBoolean(str);
            }
        }
        return false;
    }

    static long getUrlHandlersTimeout(Dictionary<String, ?> config) {
        if (config != null) {
            Object timeout = config.get(URL_HANDLERS_TIMEOUT);
            if (timeout instanceof Number) {
                return ((Number)timeout).longValue();
            }
            if (timeout instanceof String) {
                return Long.parseLong((String)timeout);
            }
        }
        return TimeUnit.MILLISECONDS.convert(5L, TimeUnit.MINUTES);
    }

    public boolean isResolveOptionalImports() {
        return this.resolveOptionalImports;
    }

    public void setResolveOptionalImports(boolean resolveOptionalImports) {
        this.resolveOptionalImports = resolveOptionalImports;
    }

    public long getUrlHandlersTimeout() {
        return this.urlHandlersTimeout;
    }

    public void setUrlHandlersTimeout(long urlHandlersTimeout) {
        this.urlHandlersTimeout = urlHandlersTimeout;
    }

    public void start() throws IOException {
        LOGGER.info("Starting DeploymentAgent");
        this.loadBundleChecksums();
        this.loadLibChecksums(LIB_PATH, this.libChecksums);
        this.loadLibChecksums(LIB_ENDORSED_PATH, this.endorsedChecksums);
        this.loadLibChecksums(LIB_EXT_PATH, this.extensionChecksums);
    }

    public void stop() throws InterruptedException {
        LOGGER.info("Stopping DeploymentAgent");
        this.executor.shutdown();
        if (this.shutdownDownloadExecutor && this.downloadExecutor != null) {
            this.downloadExecutor.shutdown();
            this.downloadExecutor = null;
        }
        this.manager.shutdown();
        this.fabricService.close();
    }

    private void loadBundleChecksums() throws IOException {
        for (Bundle bundle : this.systemBundleContext.getBundles()) {
            try {
                if (!DeploymentAgent.isUpdateable(bundle)) continue;
                Parser parser = new Parser(bundle.getLocation());
                String systemPath = SYSTEM_PATH + File.separator + parser.getArtifactPath().substring(4);
                String agentDownloadsPath = AGENT_DOWNLOAD_PATH + File.separator + parser.getArtifactPath().substring(4);
                long systemChecksum = 0L;
                long agentChecksum = 0L;
                try {
                    systemChecksum = ChecksumUtils.checksum(new FileInputStream(systemPath));
                }
                catch (Exception e) {
                    LOGGER.debug("Error calculating checksum for file: %s", (Object)systemPath, (Object)e);
                }
                try {
                    agentChecksum = ChecksumUtils.checksum(new FileInputStream(agentDownloadsPath));
                }
                catch (Exception e) {
                    LOGGER.debug("Error calculating checksum for file: %s", (Object)agentDownloadsPath, (Object)e);
                }
                long checksum = agentChecksum > 0L ? agentChecksum : systemChecksum;
                this.bundleChecksums.put(bundle.getLocation(), Long.toString(checksum));
            }
            catch (Exception e) {
                LOGGER.debug("Error creating checksum map.", (Throwable)e);
            }
        }
        this.bundleChecksums.save();
    }

    private void loadLibChecksums(String path, org.apache.felix.utils.properties.Properties props) throws IOException {
        File dir = new File(path);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Failed to create fabric lib directory at:" + dir.getAbsolutePath());
        }
        for (String lib : dir.list()) {
            File f = new File(path, lib);
            if (!f.exists() || !f.isFile()) continue;
            props.put(lib, Long.toString(ChecksumUtils.checksum(new FileInputStream(f))));
        }
        props.save();
    }

    public void updated(final Dictionary<String, ?> props) throws ConfigurationException {
        LOGGER.info("DeploymentAgent updated with {}", props);
        if (this.executor.isShutdown() || props == null) {
            return;
        }
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                Throwable result = null;
                boolean success = false;
                try {
                    success = DeploymentAgent.this.doUpdate(props);
                }
                catch (Throwable e) {
                    result = e;
                    LOGGER.error("Unable to update agent", e);
                }
                if (success || result != null) {
                    DeploymentAgent.this.updateStatus(success ? "success" : "error", result, null, true);
                }
            }
        });
    }

    private void updateStatus(String status, Throwable result) {
        this.updateStatus(status, result, null, false);
    }

    private void updateStatus(String status, Throwable result, Collection<Resource> resources, boolean force) {
        try {
            FabricService fs = force ? (FabricService)this.fabricService.waitForService(0L) : (FabricService)this.fabricService.getService();
            this.updateStatus(fs, status, result, resources, force);
        }
        catch (Throwable e) {
            LOGGER.warn("Unable to set provisioning result");
        }
    }

    private void updateStatus(FabricService fs, String status, Throwable result, Collection<Resource> resources, boolean force) {
        try {
            this.provisioningStatus = status;
            this.provisioningError = result;
            this.provisionList = resources;
            if (fs != null) {
                String e;
                Container container = fs.getCurrentContainer();
                if (result == null) {
                    e = null;
                } else {
                    StringWriter sw = new StringWriter();
                    result.printStackTrace(new PrintWriter(sw));
                    e = sw.toString();
                }
                if (resources != null) {
                    ArrayList<String> uris = new ArrayList<String>();
                    for (Resource res : resources) {
                        uris.add(UriNamespace.getUri(res));
                    }
                    container.setProvisionList(uris);
                }
                container.setProvisionResult(status);
                container.setProvisionException(e);
                Properties provisionChecksums = new Properties();
                DeploymentAgent.putAllProperties(provisionChecksums, this.bundleChecksums);
                container.setProvisionChecksums(provisionChecksums);
            } else {
                LOGGER.info("FabricService not available");
            }
        }
        catch (Throwable e) {
            LOGGER.warn("Unable to set provisioning result");
        }
    }

    protected static void putAllProperties(Properties answer, org.apache.felix.utils.properties.Properties properties) {
        Set<Map.Entry<String, String>> entries = properties.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            answer.put(entry.getKey(), entry.getValue());
        }
    }

    public boolean doUpdate(Dictionary<String, ?> props) throws Exception {
        File libFile;
        if (props == null || Boolean.parseBoolean((String)props.get("disabled"))) {
            return false;
        }
        if (props.get("disabled") != null && "true".equalsIgnoreCase(props.get("disabled").toString())) {
            return false;
        }
        this.resolveOptionalImports = DeploymentAgent.getResolveOptionalImports(props);
        this.urlHandlersTimeout = DeploymentAgent.getUrlHandlersTimeout(props);
        AgentUtils.addMavenProxies(props, (FabricService)this.fabricService.getService());
        this.updateStatus("analyzing", null);
        PropertiesPropertyResolver syspropsResolver = new PropertiesPropertyResolver(System.getProperties());
        DictionaryPropertyResolver propertyResolver = new DictionaryPropertyResolver(props, syspropsResolver);
        MavenConfigurationImpl config = new MavenConfigurationImpl(new DictionaryPropertyResolver(props, syspropsResolver), "org.ops4j.pax.url.mvn");
        config.setSettings(new MavenSettingsImpl(config.getSettingsFileUrl(), config.useFallbackRepositories()));
        this.manager = new DownloadManager(config, this.getDownloadExecutor());
        HashMap<String, String> properties = new HashMap<String, String>();
        Enumeration<String> e = props.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            Object val = props.get(key);
            if ("service.pid".equals(key) || FABRIC_ZOOKEEPER_PID.equals(key)) continue;
            properties.put(key.toString(), val.toString());
        }
        boolean restart = false;
        HashSet libsToRemove = new HashSet(this.managedLibs.keySet());
        HashSet endorsedLibsToRemove = new HashSet(this.managedEndorsedLibs.keySet());
        HashSet extensionLibsToRemove = new HashSet(this.managedExtensionLibs.keySet());
        HashSet sysPropsToRemove = new HashSet(this.managedSysProps.keySet());
        HashSet configPropsToRemove = new HashSet(this.managedConfigProps.keySet());
        org.apache.felix.utils.properties.Properties configProps = new org.apache.felix.utils.properties.Properties(new File(KARAF_BASE + File.separator + "etc" + File.separator + "config.properties"));
        org.apache.felix.utils.properties.Properties systemProps = new org.apache.felix.utils.properties.Properties(new File(KARAF_BASE + File.separator + "etc" + File.separator + "system.properties"));
        for (String key : properties.keySet()) {
            Long checksum;
            String libName;
            File libFile2;
            String value;
            String v;
            String k;
            if (key.equals("framework")) {
                String url = (String)properties.get(key);
                restart |= this.updateFramework(configProps, url);
                continue;
            }
            if (key.startsWith("config.")) {
                k = key.substring("config.".length());
                v = (String)properties.get(key);
                this.managedConfigProps.put(k, v);
                configPropsToRemove.remove(k);
                if (v.equals(configProps.get(k))) continue;
                configProps.put(k, v);
                restart = true;
                continue;
            }
            if (key.startsWith("system.")) {
                k = key.substring("system.".length());
                v = (String)properties.get(key);
                this.managedSysProps.put(k, v);
                sysPropsToRemove.remove(k);
                if (v.equals(systemProps.get(k))) continue;
                systemProps.put(k, v);
                restart = true;
                continue;
            }
            if (key.startsWith("lib.")) {
                value = (String)properties.get(key);
                libFile2 = ((DownloadFuture)this.manager.download(value).await()).getFile();
                libName = libFile2.getName();
                checksum = ChecksumUtils.checksum(new FileInputStream(libFile2));
                this.managedLibs.put(libName, "true");
                libsToRemove.remove(libName);
                if (Long.toString(checksum).equals(this.libChecksums.getProperty(libName))) continue;
                Files.copy(libFile2, new File(LIB_PATH, libName));
                restart = true;
                continue;
            }
            if (key.startsWith("endorsed.")) {
                value = (String)properties.get(key);
                libFile2 = ((DownloadFuture)this.manager.download(value).await()).getFile();
                libName = libFile2.getName();
                checksum = ChecksumUtils.checksum(new FileInputStream(libFile2));
                this.managedEndorsedLibs.put(libName, "true");
                endorsedLibsToRemove.remove(libName);
                if (Long.toString(checksum).equals(this.endorsedChecksums.getProperty(libName))) continue;
                Files.copy(libFile2, new File(LIB_ENDORSED_PATH, libName));
                restart = true;
                continue;
            }
            if (!key.startsWith("extension.")) continue;
            value = (String)properties.get(key);
            libFile2 = ((DownloadFuture)this.manager.download(value).await()).getFile();
            libName = libFile2.getName();
            checksum = ChecksumUtils.checksum(new FileInputStream(libFile2));
            this.managedExtensionLibs.put(libName, "true");
            extensionLibsToRemove.remove(libName);
            if (Long.toString(checksum).equals(this.extensionChecksums.getProperty(libName))) continue;
            Files.copy(libFile2, new File(LIB_EXT_PATH, libName));
            restart = true;
        }
        for (String sysProp : sysPropsToRemove) {
            systemProps.remove(sysProp);
            this.managedSysProps.remove(sysProp);
            System.clearProperty(sysProp);
            restart = true;
        }
        for (String configProp : configPropsToRemove) {
            configProps.remove(configProp);
            this.managedConfigProps.remove(configProp);
            restart = true;
        }
        for (String lib : libsToRemove) {
            libFile = new File(LIB_PATH, lib);
            libFile.delete();
            this.libChecksums.remove(lib);
            this.managedLibs.remove(lib);
            restart = true;
        }
        for (String lib : endorsedLibsToRemove) {
            libFile = new File(LIB_ENDORSED_PATH, lib);
            libFile.delete();
            this.endorsedChecksums.remove(lib);
            this.managedEndorsedLibs.remove(lib);
            restart = true;
        }
        for (String lib : extensionLibsToRemove) {
            libFile = new File(LIB_EXT_PATH, lib);
            libFile.delete();
            this.extensionChecksums.remove(lib);
            this.managedExtensionLibs.remove(lib);
            restart = true;
        }
        this.libChecksums.save();
        this.endorsedChecksums.save();
        this.extensionChecksums.save();
        this.managedLibs.save();
        this.managedEndorsedLibs.save();
        this.managedExtensionLibs.save();
        this.managedConfigProps.save();
        this.managedSysProps.save();
        if (restart) {
            this.updateStatus("restarting", null);
            configProps.save();
            systemProps.save();
            System.setProperty("karaf.restart", "true");
            this.bundleContext.getBundle(0L).stop();
            return false;
        }
        final Map<String, Repository> repositories = AgentUtils.loadRepositories(this.manager, this.getPrefixedProperties(properties, "repository."));
        FabResolverFactoryImpl fabResolverFactory = new FabResolverFactoryImpl();
        fabResolverFactory.setConfiguration(new FabricFabConfiguration(config, propertyResolver));
        fabResolverFactory.setBundleContext(this.bundleContext);
        fabResolverFactory.setRegistry(new OsgiModuleRegistry());
        fabResolverFactory.setFeaturesService(new FeaturesServiceImpl(){

            @Override
            public Repository[] listRepositories() {
                return repositories.values().toArray(new Repository[repositories.size()]);
            }
        });
        DeploymentBuilder builder = new DeploymentBuilder(this.manager, fabResolverFactory, repositories.values(), this.urlHandlersTimeout);
        this.bundlesNotToStart = builder.bundlesNotToStart;
        this.updateStatus("downloading", null);
        Map<String, Resource> downloadedResources = builder.download(this.getPrefixedProperties(properties, "feature."), this.getPrefixedProperties(properties, "bundle."), this.getPrefixedProperties(properties, "fab."), this.getPrefixedProperties(properties, "req."), this.getPrefixedProperties(properties, "override."), this.getPrefixedProperties(properties, "optional."), this.getMetadata(properties, "metadata#"));
        for (String uri : this.getPrefixedProperties(properties, "resources.")) {
            builder.addResourceRepository(new MetadataRepository(new HttpMetadataProvider(uri)));
        }
        this.updateStatus("resolving", null);
        Resource systemBundle = (Resource)this.systemBundleContext.getBundle(0L).adapt(BundleRevision.class);
        Collection<Resource> allResources = builder.resolve(systemBundle, this.resolveOptionalImports);
        Set<String> ignoredBundles = this.getPrefixedProperties(properties, "ignore.");
        Map<String, StreamProvider> providers = builder.getProviders();
        Map<Resource, List<Wire>> wiring = builder.getWiring();
        this.install(allResources, ignoredBundles, providers, wiring);
        ServiceReference configAdminServiceReference = null;
        try {
            configAdminServiceReference = this.bundleContext.getServiceReference(ConfigurationAdmin.class.getName());
        }
        catch (Exception e2) {
            LOGGER.warn("Could not get reference to config admin service.", (Throwable)e2);
        }
        if (configAdminServiceReference != null) {
            ConfigurationAdmin configAdmin = (ConfigurationAdmin)this.bundleContext.getService(configAdminServiceReference);
            for (FeatureResource resource : DeploymentAgent.filterFeatureResources(downloadedResources)) {
                Map<String, Map<String, String>> configs = resource.getFeature().getConfigurations();
                for (Map.Entry<String, Map<String, String>> entry : configs.entrySet()) {
                    String pid = entry.getKey();
                    if (DeploymentAgent.isConfigurationManaged(configAdmin, pid)) continue;
                    DeploymentAgent.applyConfiguration(configAdmin, pid, entry.getValue());
                }
            }
        }
        return true;
    }

    private Set<String> getPrefixedProperties(Map<String, String> properties, String prefix) {
        HashSet<String> result = new HashSet<String>();
        for (String key : properties.keySet()) {
            if (!key.startsWith(prefix)) continue;
            String url = properties.get(key);
            if (url == null || url.length() == 0) {
                url = key.substring(prefix.length());
            }
            if (url == null || url.length() <= 0) continue;
            result.add(url);
        }
        return result;
    }

    private Map<String, Map<VersionRange, Map<String, String>>> getMetadata(Map<String, String> properties, String prefix) {
        HashMap<String, Map<VersionRange, Map<String, String>>> result = new HashMap<String, Map<VersionRange, Map<String, String>>>();
        for (String key : properties.keySet()) {
            VersionRange range;
            HashMap<String, String> hdrs;
            String version;
            if (!key.startsWith(prefix)) continue;
            String val = properties.get(key);
            String[] parts = (key = key.substring(prefix.length())).split("#");
            if (parts.length != 3) continue;
            HashMap<VersionRange, HashMap<String, String>> ranges = (HashMap<VersionRange, HashMap<String, String>>)result.get(parts[0]);
            if (ranges == null) {
                ranges = new HashMap<VersionRange, HashMap<String, String>>();
                result.put(parts[0], ranges);
            }
            if (!(version = parts[1]).startsWith("[") && !version.startsWith("(")) {
                Processor processor = new Processor();
                processor.setProperty("@", VersionTable.getVersion(version).toString());
                Macro macro = new Macro(processor, new Object[0]);
                version = macro.process("${range;[==,=+)}");
            }
            if ((hdrs = (HashMap<String, String>)ranges.get(range = new VersionRange(version))) == null) {
                hdrs = new HashMap<String, String>();
                ranges.put(range, hdrs);
            }
            hdrs.put(parts[2], val);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void install(Collection<Resource> allResources, Collection<String> ignoredBundles, Map<String, StreamProvider> providers, Map<Resource, List<Wire>> wiring) throws Exception {
        String hostHeader;
        List<Bundle> bs;
        void var15_19;
        this.updateStatus("installing", null, allResources, false);
        HashMap<Object, Bundle> resToBnd = new HashMap<Object, Bundle>();
        StringBuilder sb = new StringBuilder();
        sb.append("Configuration changed.  New bundles list:\n");
        for (Resource bundle2 : allResources) {
            sb.append("  ").append(UriNamespace.getUri(bundle2)).append("\n");
        }
        LOGGER.info(sb.toString());
        HashMap<String, String> newCheckums = new HashMap<String, String>();
        ArrayList<Resource> toDeploy = new ArrayList<Resource>(allResources);
        ArrayList<Resource> toInstall = new ArrayList<Resource>();
        ArrayList<Bundle> toDelete = new ArrayList<Bundle>();
        HashMap<Bundle, Object> toUpdate = new HashMap<Bundle, Object>();
        File file = this.bundleContext.getDataFile("bundle-checksums.properties");
        this.bundleChecksums.load(file);
        Bundle[] arr$ = this.systemBundleContext.getBundles();
        int len$ = arr$.length;
        boolean bl = false;
        while (var15_19 < len$) {
            Bundle bundle3 = arr$[var15_19];
            if (bundle3.getSymbolicName() != null && bundle3.getBundleId() != 0L) {
                void var17_28;
                Object var17_29 = null;
                boolean update = false;
                for (Resource res : toDeploy) {
                    if (!bundle3.getSymbolicName().equals(Util.getSymbolicName(res)) || !bundle3.getVersion().equals((Object)Util.getVersion(res))) continue;
                    if (DeploymentAgent.isUpdateable(res)) {
                        InputStream is = null;
                        try {
                            long oldCrc;
                            is = this.getBundleInputStream(res, providers);
                            long newCrc = ChecksumUtils.checksum(is);
                            long l = oldCrc = this.bundleChecksums.containsKey(bundle3.getLocation()) ? Long.parseLong((String)this.bundleChecksums.get(bundle3.getLocation())) : 0L;
                            if (newCrc != oldCrc) {
                                LOGGER.debug("New snapshot available for " + bundle3.getLocation());
                                update = true;
                                newCheckums.put(bundle3.getLocation(), Long.toString(newCrc));
                            }
                        }
                        finally {
                            if (is != null) {
                                is.close();
                            }
                        }
                    }
                    Resource resource = res;
                    break;
                }
                if (var17_28 != null) {
                    toDeploy.remove(var17_28);
                    resToBnd.put(var17_28, bundle3);
                    if (update) {
                        toUpdate.put(bundle3, var17_28);
                    }
                } else if (!DeploymentAgent.bundleSymbolicNameMatches(bundle3, ignoredBundles)) {
                    toDelete.add(bundle3);
                }
            }
            ++var15_19;
        }
        for (Resource resource : toDeploy) {
            TreeMap<Version, Bundle> treeMap = new TreeMap<Version, Bundle>();
            VersionRange range = this.getMicroVersionRange(Util.getVersion(resource));
            for (Bundle bundle4 : toDelete) {
                if (!bundle4.getSymbolicName().equals(Util.getSymbolicName(resource)) || !range.contains(bundle4.getVersion())) continue;
                treeMap.put(bundle4.getVersion(), bundle4);
            }
            if (!treeMap.isEmpty()) {
                Bundle bundle = (Bundle)treeMap.lastEntry().getValue();
                toUpdate.put(bundle, resource);
                toDelete.remove(bundle);
                resToBnd.put(resource, bundle);
                continue;
            }
            toInstall.add(resource);
        }
        Resource agentResource = (Resource)toUpdate.get(this.bundleContext.getBundle());
        if (agentResource != null) {
            LOGGER.info("Updating agent");
            LOGGER.info("  " + UriNamespace.getUri(agentResource));
            InputStream is = this.getBundleInputStream(agentResource, providers);
            Bundle bundle = this.bundleContext.getBundle();
            if (newCheckums.containsKey(bundle.getLocation())) {
                this.bundleChecksums.put(bundle.getLocation(), (String)newCheckums.get(bundle.getLocation()));
            }
            this.bundleChecksums.save();
            bundle.update(is);
            return;
        }
        LOGGER.info("Changes to perform:");
        LOGGER.info("  Bundles to uninstall:");
        for (Bundle bundle : toDelete) {
            LOGGER.info("    " + bundle.getSymbolicName() + " / " + bundle.getVersion());
        }
        LOGGER.info("  Bundles to update:");
        for (Map.Entry entry : toUpdate.entrySet()) {
            LOGGER.info("    " + ((Bundle)entry.getKey()).getSymbolicName() + " / " + ((Bundle)entry.getKey()).getVersion() + " with " + UriNamespace.getUri((Resource)entry.getValue()));
        }
        LOGGER.info("  Bundles to install:");
        for (Resource resource : toInstall) {
            LOGGER.info("    " + UriNamespace.getUri(resource));
        }
        HashSet<Bundle> toRefresh = new HashSet<Bundle>();
        LOGGER.info("Stopping bundles:");
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
        arrayList.addAll(toUpdate.keySet());
        arrayList.addAll(toDelete);
        while (!arrayList.isEmpty()) {
            bs = this.getBundlesToDestroy(arrayList);
            for (Bundle bundle8 : bs) {
                hostHeader = (String)bundle8.getHeaders().get("Fragment-Host");
                if (hostHeader == null && (bundle8.getState() == 32 || bundle8.getState() == 8)) {
                    LOGGER.info("  " + bundle8.getSymbolicName() + " / " + bundle8.getVersion());
                    bundle8.stop(1);
                }
                arrayList.remove(bundle8);
            }
        }
        LOGGER.info("Uninstalling bundles:");
        for (Bundle bundle : toDelete) {
            LOGGER.info("  " + bundle.getSymbolicName() + " / " + bundle.getVersion());
            bundle.uninstall();
            toRefresh.add(bundle);
        }
        LOGGER.info("Updating bundles:");
        for (Map.Entry entry : toUpdate.entrySet()) {
            Bundle bundle9 = (Bundle)entry.getKey();
            Resource resource = (Resource)entry.getValue();
            LOGGER.info("  " + UriNamespace.getUri(resource));
            InputStream is = this.getBundleInputStream(resource, providers);
            bundle9.update(is);
            toRefresh.add(bundle9);
        }
        LOGGER.info("Installing bundles:");
        for (Resource resource : toInstall) {
            LOGGER.info("  " + UriNamespace.getUri(resource));
            InputStream is = this.getBundleInputStream(resource, providers);
            Bundle bundle11 = this.systemBundleContext.installBundle(UriNamespace.getUri(resource), is);
            toRefresh.add(bundle11);
            resToBnd.put(resource, bundle11);
            if (!bundle11.getVersion().getQualifier().endsWith(SNAPSHOT) || newCheckums.containsKey(bundle11.getLocation())) continue;
            newCheckums.put(bundle11.getLocation(), Long.toString(ChecksumUtils.checksum(this.getBundleInputStream(resource, providers))));
        }
        if (!newCheckums.isEmpty()) {
            for (String string : newCheckums.keySet()) {
                this.bundleChecksums.put(string, (String)newCheckums.get(string));
            }
            this.bundleChecksums.save();
        }
        this.findBundlesWithOptionalPackagesToRefresh(toRefresh);
        this.findBundlesWithFragmentsToRefresh(toRefresh);
        LOGGER.info("Stopping bundles:");
        ArrayList<Bundle> arrayList2 = new ArrayList<Bundle>();
        arrayList2.addAll(toRefresh);
        this.removeFragmentsAndBundlesInState(arrayList2, 21);
        while (!arrayList2.isEmpty()) {
            bs = this.getBundlesToDestroy(arrayList2);
            for (Bundle bundle10 : bs) {
                hostHeader = (String)bundle10.getHeaders().get("Fragment-Host");
                if (hostHeader == null && (bundle10.getState() == 32 || bundle10.getState() == 8)) {
                    LOGGER.info("  " + bundle10.getSymbolicName() + " / " + bundle10.getVersion());
                    bundle10.stop(1);
                }
                arrayList2.remove(bundle10);
            }
        }
        this.updateStatus("finalizing", null);
        LOGGER.info("Refreshing bundles:");
        for (Bundle bundle : toRefresh) {
            LOGGER.info("  " + bundle.getSymbolicName() + " / " + bundle.getVersion());
        }
        if (!toRefresh.isEmpty()) {
            this.refreshPackages(toRefresh);
        }
        LOGGER.info("Resolving bundles");
        ArrayList<Bundle> toResolve = new ArrayList<Bundle>();
        this.removeFragmentsAndBundlesInState(toResolve, 1);
        for (Resource resource : allResources) {
            String hostHeader2;
            Bundle bundle = (Bundle)resToBnd.get(resource);
            if (bundle == null || (hostHeader2 = (String)bundle.getHeaders().get("Fragment-Host")) != null || bundle.getState() == 1) continue;
            toResolve.add(bundle);
        }
        FrameworkWiring frameworkWiring = (FrameworkWiring)this.systemBundleContext.getBundle().adapt(FrameworkWiring.class);
        for (Bundle bundle : toResolve) {
            frameworkWiring.resolveBundles(Collections.singleton(bundle));
        }
        ArrayList<Resource> resourcesWithUrlHandlers = new ArrayList<Resource>();
        for (Resource resource : allResources) {
            block35: for (Capability cap : resource.getCapabilities(null)) {
                String[] itfs;
                if (!cap.getNamespace().equals("service-reference") || (itfs = this.getStrings(cap.getAttributes().get("objectClass"))) == null) continue;
                for (String itf : itfs) {
                    if (!itf.equals(URLStreamHandlerService.class.getName())) continue;
                    if (resourcesWithUrlHandlers.contains(resource)) continue block35;
                    resourcesWithUrlHandlers.add(resource);
                    continue block35;
                }
            }
        }
        LinkedHashSet<Resource> firstSetToStart = new LinkedHashSet<Resource>();
        LinkedHashSet<Resource> visited = new LinkedHashSet<Resource>();
        for (Resource resource : resourcesWithUrlHandlers) {
            DeploymentAgent.visit(resource, visited, firstSetToStart, wiring);
        }
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        LOGGER.info("Starting bundles:");
        for (Resource resource : firstSetToStart) {
            Bundle bundle12 = (Bundle)resToBnd.get(resource);
            if (bundle12 == null) continue;
            LOGGER.info("  " + bundle12.getSymbolicName() + " / " + bundle12.getVersion());
            String hostHeader3 = (String)bundle12.getHeaders().get("Fragment-Host");
            if (hostHeader3 != null || bundle12.getState() == 32) continue;
            ClassLoader oldTCCL = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(null);
                if (this.bundlesNotToStart.contains(UriNamespace.getUri(resource))) continue;
                bundle12.start();
            }
            catch (BundleException e) {
                resourcesWithUrlHandlers.remove(resource);
                exceptions.add(e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldTCCL);
            }
        }
        if (!resourcesWithUrlHandlers.isEmpty()) {
            LOGGER.info("Waiting for URL handlers...");
            long t0 = System.currentTimeMillis();
            while (!resourcesWithUrlHandlers.isEmpty() && System.currentTimeMillis() - t0 < 30000L) {
                Iterator it = resourcesWithUrlHandlers.iterator();
                while (it.hasNext()) {
                    Resource resource = (Resource)it.next();
                    Bundle bundle13 = (Bundle)resToBnd.get(resource);
                    boolean remove = false;
                    if (bundle13.getState() != 32) {
                        remove = true;
                    } else {
                        ServiceReference[] refs = bundle13.getRegisteredServices();
                        if (refs != null) {
                            for (ServiceReference ref : refs) {
                                Object val = ref.getProperty("objectClass");
                                String[] itfs = this.getStrings(val);
                                if (itfs != null) {
                                    for (String itf : itfs) {
                                        remove |= itf.equals(URLStreamHandlerService.class.getName());
                                    }
                                    continue;
                                }
                                remove = true;
                            }
                        }
                    }
                    if (!remove) continue;
                    it.remove();
                }
                if (resourcesWithUrlHandlers.isEmpty()) continue;
                LOGGER.debug("Still waiting for URL handlers provided by {}", resourcesWithUrlHandlers);
                Thread.sleep(100L);
            }
            if (!resourcesWithUrlHandlers.isEmpty()) {
                LOGGER.warn("Gave up waiting for URL handlers provided by {}", resourcesWithUrlHandlers);
            }
            LOGGER.info("Starting bundles:");
        }
        for (Resource resource : this.requirementSort.sort(allResources)) {
            Bundle bundle14 = (Bundle)resToBnd.get(resource);
            String hostHeader4 = (String)bundle14.getHeaders().get("Fragment-Host");
            if (hostHeader4 != null || bundle14.getState() == 32) continue;
            LOGGER.info("  " + bundle14.getSymbolicName() + " / " + bundle14.getVersion());
            ClassLoader oldTCCL = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(null);
                if (this.bundlesNotToStart.contains(UriNamespace.getUri(resource))) continue;
                bundle14.start();
            }
            catch (BundleException e) {
                exceptions.add(e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldTCCL);
            }
        }
        if (!exceptions.isEmpty()) {
            throw new MultiException("Error updating agent", exceptions);
        }
        LOGGER.info("Done.");
    }

    private String[] getStrings(Object val) {
        Object itfs = val instanceof String ? new String[]{(String)val} : (val instanceof Collection ? ((Collection)val).toArray(new String[0]) : (val instanceof String[] ? (String[])val : null));
        return itfs;
    }

    private static void visit(Resource resource, Set<Resource> visited, Set<Resource> sorted, Map<Resource, List<Wire>> wiring) {
        if (!visited.add(resource)) {
            return;
        }
        for (Wire w : wiring.get(resource)) {
            if (!w.getCapability().getNamespace().equals("service-reference") && !w.getCapability().getNamespace().equals("osgi.extender")) continue;
            DeploymentAgent.visit(w.getProvider(), visited, sorted, wiring);
        }
        sorted.add(resource);
    }

    protected InputStream getBundleInputStream(Resource resource, Map<String, StreamProvider> providers) throws IOException {
        String uri = UriNamespace.getUri(resource);
        if (uri == null) {
            throw new IllegalStateException("Resource has no uri");
        }
        StreamProvider provider = providers.get(uri);
        if (provider == null) {
            try {
                return new FileInputStream(((DownloadFuture)this.manager.download(uri).await()).getFile());
            }
            catch (InterruptedException e) {
                throw (IOException)new InterruptedIOException().initCause(e);
            }
        }
        return provider.open();
    }

    private void removeFragmentsAndBundlesInState(Collection<Bundle> bundles, int state) {
        Iterator<Bundle> iterator = bundles.iterator();
        while (iterator.hasNext()) {
            Bundle bundle = iterator.next();
            if ((bundle.getState() & state) == 0 && bundle.getHeaders().get("Fragment-Host") == null) continue;
            iterator.remove();
        }
    }

    private List<Bundle> getBundlesToDestroy(List<Bundle> bundles) {
        ArrayList<Bundle> bundlesToDestroy = new ArrayList<Bundle>();
        for (Bundle bundle : bundles) {
            ServiceReference[] references = bundle.getRegisteredServices();
            int usage = 0;
            if (references != null) {
                for (ServiceReference reference : references) {
                    usage += DeploymentAgent.getServiceUsage(reference, bundles);
                }
            }
            LOGGER.debug("Usage for bundle {} is {}", (Object)bundle, (Object)usage);
            if (usage != 0) continue;
            bundlesToDestroy.add(bundle);
        }
        if (!bundlesToDestroy.isEmpty()) {
            Collections.sort(bundlesToDestroy, new Comparator<Bundle>(){

                @Override
                public int compare(Bundle b1, Bundle b2) {
                    return (int)(b2.getLastModified() - b1.getLastModified());
                }
            });
            LOGGER.debug("Selected bundles {} for destroy (no services in use)", bundlesToDestroy);
        } else {
            ServiceReference ref = null;
            for (Bundle bundle : bundles) {
                ServiceReference[] references;
                for (ServiceReference reference : references = bundle.getRegisteredServices()) {
                    if (DeploymentAgent.getServiceUsage(reference, bundles) == 0 || ref != null && reference.compareTo(ref) >= 0) continue;
                    LOGGER.debug("Currently selecting bundle {} for destroy (with reference {})", (Object)bundle, (Object)reference);
                    ref = reference;
                }
            }
            if (ref != null) {
                bundlesToDestroy.add(ref.getBundle());
            }
            LOGGER.debug("Selected bundle {} for destroy (lowest ranking service)", bundlesToDestroy);
        }
        return bundlesToDestroy;
    }

    private static int getServiceUsage(ServiceReference ref, List<Bundle> bundles) {
        Bundle[] usingBundles = ref.getUsingBundles();
        int nb = 0;
        if (usingBundles != null) {
            for (Bundle bundle : usingBundles) {
                if (!bundles.contains(bundle)) continue;
                ++nb;
            }
        }
        return nb;
    }

    private VersionRange getMicroVersionRange(Version version) {
        Version floor = new Version(version.getMajor(), version.getMinor(), 0);
        Version ceil = new Version(version.getMajor(), version.getMinor() + 1, 0);
        return new VersionRange(false, floor, ceil, true);
    }

    protected void findBundlesWithFragmentsToRefresh(Set<Bundle> toRefresh) {
        if (toRefresh.isEmpty()) {
            return;
        }
        HashSet<Bundle> bundles = new HashSet<Bundle>(Arrays.asList(this.systemBundleContext.getBundles()));
        bundles.removeAll(toRefresh);
        if (bundles.isEmpty()) {
            return;
        }
        for (Bundle bundle : new ArrayList<Bundle>(toRefresh)) {
            BundleRevision rev = (BundleRevision)bundle.adapt(BundleRevision.class);
            if (rev == null) continue;
            for (BundleRequirement req : rev.getDeclaredRequirements(null)) {
                if (!"osgi.wiring.host".equals(req.getNamespace())) continue;
                for (Bundle hostBundle : bundles) {
                    BundleRevision hostRev;
                    if (toRefresh.contains(hostBundle) || (hostRev = (BundleRevision)hostBundle.adapt(BundleRevision.class)) == null) continue;
                    for (BundleCapability cap : hostRev.getDeclaredCapabilities(null)) {
                        if (!req.matches(cap)) continue;
                        toRefresh.add(hostBundle);
                    }
                }
            }
        }
    }

    protected void findBundlesWithOptionalPackagesToRefresh(Set<Bundle> toRefresh) {
        if (toRefresh.isEmpty()) {
            return;
        }
        HashSet<Bundle> bundles = new HashSet<Bundle>(Arrays.asList(this.systemBundleContext.getBundles()));
        bundles.removeAll(toRefresh);
        if (bundles.isEmpty()) {
            return;
        }
        for (Bundle bundle : bundles) {
            BundleRevision rev = (BundleRevision)bundle.adapt(BundleRevision.class);
            boolean matches = false;
            if (rev != null) {
                for (BundleRequirement req : rev.getDeclaredRequirements(null)) {
                    if ("osgi.wiring.package".equals(req.getNamespace()) && "optional".equals(req.getDirectives().get("resolution"))) {
                        for (Bundle provider : toRefresh) {
                            BundleRevision providerRev = (BundleRevision)provider.adapt(BundleRevision.class);
                            if (providerRev != null) {
                                for (BundleCapability cap : providerRev.getDeclaredCapabilities(null)) {
                                    if (!req.matches(cap)) continue;
                                    matches = true;
                                    break;
                                }
                            }
                            if (!matches) continue;
                            break;
                        }
                    }
                    if (!matches) continue;
                    break;
                }
            }
            if (!matches) continue;
            toRefresh.add(bundle);
        }
    }

    protected boolean updateFramework(org.apache.felix.utils.properties.Properties properties, String url) throws Exception {
        if (!url.startsWith("mvn:")) {
            throw new IllegalArgumentException("Framework url must use the mvn: protocol");
        }
        File file = ((DownloadFuture)this.manager.download(url).await()).getFile();
        String path = file.getPath();
        if (path.startsWith(KARAF_HOME)) {
            path = path.substring(KARAF_HOME.length() + 1);
        }
        if (!path.equals(properties.get("karaf.framework.felix"))) {
            properties.put("karaf.framework", "felix");
            properties.put("karaf.framework.felix", path);
            return true;
        }
        return false;
    }

    protected void refreshPackages(Collection<Bundle> bundles) throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        FrameworkWiring fw = (FrameworkWiring)this.systemBundleContext.getBundle().adapt(FrameworkWiring.class);
        fw.refreshBundles(bundles, new FrameworkListener[]{new FrameworkListener(){

            public void frameworkEvent(FrameworkEvent event) {
                if (event.getType() == 2) {
                    LOGGER.error("Framework error", event.getThrowable());
                }
                latch.countDown();
            }
        }});
        latch.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ExecutorService getDownloadExecutor() {
        boolean shutdownDownloadExecutor;
        DeploymentAgent deploymentAgent = this;
        synchronized (deploymentAgent) {
            if (this.downloadExecutor != null) {
                return this.downloadExecutor;
            }
        }
        ExecutorService downloadExecutor = null;
        try {
            downloadExecutor = new FelixExecutorServiceFinder().find(this.bundleContext.getBundle());
        }
        catch (Throwable t) {
            LOGGER.warn("Cannot find reference to MonitoringService. This exception will be ignored.", t);
        }
        if (downloadExecutor == null) {
            LOGGER.info("Creating a new fixed thread pool for download manager.");
            downloadExecutor = Executors.newFixedThreadPool(5);
            shutdownDownloadExecutor = true;
        } else {
            LOGGER.info("Using Felix thread pool for download manager.");
            shutdownDownloadExecutor = false;
        }
        DeploymentAgent deploymentAgent2 = this;
        synchronized (deploymentAgent2) {
            if (this.downloadExecutor == null) {
                this.downloadExecutor = downloadExecutor;
                this.shutdownDownloadExecutor = shutdownDownloadExecutor;
            } else if (shutdownDownloadExecutor) {
                downloadExecutor.shutdown();
            }
            return this.downloadExecutor;
        }
    }

    private static boolean bundleSymbolicNameMatches(Bundle bundle, Collection<String> expressions) {
        for (String regex : expressions) {
            Pattern p = Pattern.compile(regex);
            if (!p.matcher(bundle.getSymbolicName()).matches()) continue;
            return true;
        }
        return false;
    }

    private static boolean isUpdateable(Bundle bundle) {
        return SNAPSHOT_PATTERN.matcher(bundle.getLocation()).matches() || bundle.getLocation().startsWith(BLUEPRINT_PREFIX) || bundle.getLocation().startsWith(SPRING_PREFIX);
    }

    private static boolean isUpdateable(Resource resource) {
        return Util.getVersion(resource).getQualifier().endsWith(SNAPSHOT) || SNAPSHOT_PATTERN.matcher(UriNamespace.getUri(resource)).matches() || UriNamespace.getUri(resource).startsWith(BLUEPRINT_PREFIX) || UriNamespace.getUri(resource).startsWith(SPRING_PREFIX);
    }

    static void installFeatureConfigs(BundleContext bundleContext, Map<String, Resource> resources) throws IOException {
        ServiceReference configAdminServiceReference = bundleContext.getServiceReference(ConfigurationAdmin.class.getName());
        if (configAdminServiceReference != null) {
            ConfigurationAdmin configAdmin = (ConfigurationAdmin)bundleContext.getService(configAdminServiceReference);
            for (FeatureResource resource : DeploymentAgent.filterFeatureResources(resources)) {
                Map<String, Map<String, String>> configs = resource.getFeature().getConfigurations();
                for (Map.Entry<String, Map<String, String>> entry : configs.entrySet()) {
                    String pid = entry.getKey();
                    if (DeploymentAgent.isConfigurationManaged(configAdmin, pid)) continue;
                    DeploymentAgent.applyConfiguration(configAdmin, pid, entry.getValue());
                }
            }
        }
    }

    static boolean isConfigurationManaged(ConfigurationAdmin configurationAdmin, String pid) throws IOException {
        org.osgi.service.cm.Configuration configuration = configurationAdmin.getConfiguration(pid);
        Dictionary properties = configuration.getProperties();
        if (properties == null) {
            return false;
        }
        String fabricManagedPid = (String)properties.get(FABRIC_ZOOKEEPER_PID);
        return Strings.isNotBlank(fabricManagedPid);
    }

    static void applyConfiguration(ConfigurationAdmin configurationAdmin, String pid, Map<String, String> config) throws IOException {
        org.osgi.service.cm.Configuration configuration = configurationAdmin.getConfiguration(pid);
        Properties properties = new Properties();
        ((Hashtable)properties).putAll(config);
        configuration.setBundleLocation(null);
        configuration.update((Dictionary)properties);
    }

    static Collection<FeatureResource> filterFeatureResources(Map<String, Resource> resources) {
        HashSet<FeatureResource> featureResources = new HashSet<FeatureResource>();
        for (Resource resource : resources.values()) {
            if (!(resource instanceof FeatureResource)) continue;
            featureResources.add((FeatureResource)resource);
        }
        return featureResources;
    }

    class FabricFabConfiguration
    extends PropertyStore
    implements Configuration {
        final DictionaryPropertyResolver propertyResolver;
        final MavenConfigurationImpl config;

        FabricFabConfiguration(MavenConfigurationImpl config, DictionaryPropertyResolver propertyResolver) {
            this.propertyResolver = propertyResolver;
            this.config = config;
        }

        @Override
        public String[] getSharedResourcePaths() {
            if (!this.contains("io.fabric8.fab.osgi.url.sharedResourcePaths")) {
                String text = this.propertyResolver.get("io.fabric8.fab.osgi.url.sharedResourcePaths");
                String[] repositories = text == null || text.length() == 0 ? ServiceConstants.DEFAULT_PROPERTY_SHARED_RESOURCE_PATHS : this.toArray(text);
                return this.set("io.fabric8.fab.osgi.url.sharedResourcePaths", repositories);
            }
            return (String[])this.get("io.fabric8.fab.osgi.url.sharedResourcePaths");
        }

        @Override
        public boolean getCertificateCheck() {
            return this.config.getCertificateCheck();
        }

        @Override
        public boolean isInstallMissingDependencies() {
            return false;
        }

        @Override
        public MavenResolver getResolver() {
            try {
                MavenResolverImpl resolver = new MavenResolverImpl();
                ArrayList<String> repos = new ArrayList<String>();
                for (MavenRepositoryURL url : this.config.getRepositories()) {
                    repos.add(url.getURL().toURI().toString());
                }
                resolver.setRepositories(repos.toArray(new String[repos.size()]));
                resolver.setLocalRepo(new File(this.config.getLocalRepository().getURL().toURI()).getAbsolutePath());
                return resolver;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }

        protected String[] toArray(String text) {
            String[] answer = null;
            if (text != null) {
                answer = text.split(",");
            }
            return answer;
        }
    }

    static class NamedThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        NamedThreadFactory(String prefix) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = prefix + "-" + poolNumber.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }

    class FelixExecutorServiceFinder
    implements ExecutorServiceFinder {
        final ServiceReference<MonitoringService> sr;

        FelixExecutorServiceFinder() {
            this.sr = DeploymentAgent.this.bundleContext.getServiceReference(MonitoringService.class);
            if (this.sr == null) {
                throw new UnsupportedOperationException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ExecutorService find(Bundle bundle) {
            MonitoringService ms = (MonitoringService)DeploymentAgent.this.bundleContext.getService(this.sr);
            try {
                ExecutorService executorService = ms.getExecutor(bundle);
                return executorService;
            }
            finally {
                DeploymentAgent.this.bundleContext.ungetService(this.sr);
            }
        }
    }

    static interface ExecutorServiceFinder {
        public ExecutorService find(Bundle var1);
    }
}

