/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.resolver;

import aQute.lib.osgi.Macro;
import aQute.lib.osgi.Processor;
import io.fabric8.agent.resolver.CapabilityImpl;
import io.fabric8.agent.resolver.RequirementImpl;
import io.fabric8.agent.resolver.ResourceImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.utils.version.VersionRange;
import org.apache.felix.utils.version.VersionTable;
import org.apache.karaf.features.BundleInfo;
import org.apache.karaf.features.Feature;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;
import org.osgi.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureResource
extends ResourceImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureResource.class);
    private final Feature feature;

    public static Resource build(Feature feature, String featureRange, Map<String, Resource> locToRes, Set<String> overrides) {
        FeatureResource resource = new FeatureResource(feature);
        HashMap<String, String> dirs = new HashMap<String, String>();
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("karaf.feature", feature.getName());
        attrs.put("version", VersionTable.getVersion(feature.getVersion()));
        resource.addCapability(new CapabilityImpl(resource, "karaf.feature", dirs, attrs));
        for (BundleInfo info : feature.getBundles()) {
            if (info.isDependency()) continue;
            Resource res = locToRes.get(info.getLocation());
            if (res == null) {
                if (overrides.contains(info.getLocation())) {
                    LOGGER.trace("Overriden resource not found for url " + info.getLocation());
                    continue;
                }
                throw new IllegalStateException("Resource not found for url " + info.getLocation());
            }
            List caps = res.getCapabilities("osgi.identity");
            if (caps.size() != 1) {
                throw new IllegalStateException("Resource does not have a single osgi.identity capability");
            }
            dirs = new HashMap();
            attrs = new HashMap();
            attrs.put("osgi.identity", ((Capability)caps.get(0)).getAttributes().get("osgi.identity"));
            attrs.put("type", ((Capability)caps.get(0)).getAttributes().get("type"));
            attrs.put("version", new VersionRange((Version)((Capability)caps.get(0)).getAttributes().get("version"), true));
            resource.addRequirement(new RequirementImpl(resource, "osgi.identity", dirs, attrs));
        }
        for (Feature dep : feature.getDependencies()) {
            String name = dep.getName();
            String version = dep.getVersion();
            if (!version.startsWith("[") && !version.startsWith("(")) {
                Processor processor = new Processor();
                processor.setProperty("@", VersionTable.getVersion(version).toString());
                Macro macro = new Macro(processor, new Object[0]);
                version = macro.process(featureRange);
            }
            dirs = new HashMap();
            attrs = new HashMap();
            attrs.put("karaf.feature", name);
            attrs.put("version", new VersionRange(version));
            resource.addRequirement(new RequirementImpl(resource, "karaf.feature", dirs, attrs));
        }
        return resource;
    }

    public FeatureResource(Feature feature) {
        super(feature.getName(), "karaf.feature", VersionTable.getVersion(feature.getVersion()));
        this.feature = feature;
    }

    public Feature getFeature() {
        return this.feature;
    }
}

