/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.fab;

import io.fabric8.fab.DependencyTree;
import io.fabric8.fab.DependencyTreeFilter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.fusesource.common.util.Filter;
import org.fusesource.common.util.Filters;

public class DependencyTreeFilters {
    protected static final Filter<DependencyTree> providedScopeFilter = DependencyTreeFilters.createScopeFilter("provided");
    protected static final Filter<DependencyTree> testScopeFilter = DependencyTreeFilters.createScopeFilter("test");
    public static final Filter<DependencyTree> optionalFilter = new Filter<DependencyTree>(){

        @Override
        public boolean matches(DependencyTree tree) {
            return tree.isThisOrDescendantOptional();
        }

        public String toString() {
            return "OptionalFilter";
        }
    };

    protected static final Filter<DependencyTree> createScopeFilter(final String scopeFilter) {
        return new Filter<DependencyTree>(){

            @Override
            public boolean matches(DependencyTree dependencyTree) {
                String scope = dependencyTree.getScope();
                return scope != null && scopeFilter.equals(scope);
            }
        };
    }

    public static Filter<DependencyTree> parseShareFilter(String dependencyFilterText) {
        Filter<DependencyTree> filter = DependencyTreeFilters.parse(dependencyFilterText);
        return Filters.or(providedScopeFilter, filter);
    }

    public static Filter<DependencyTree> parseExcludeFilter(String dependencyFilterText, Filter excludeOptionalDependenciesFilter) {
        Filter<DependencyTree> filter = DependencyTreeFilters.parse(dependencyFilterText);
        if (Filters.isEmpty(filter)) {
            return Filters.or(testScopeFilter, excludeOptionalDependenciesFilter);
        }
        return Filters.or(testScopeFilter, excludeOptionalDependenciesFilter, filter);
    }

    public static Filter<DependencyTree> parseExcludeOptionalFilter(String includeOptionalDependencyFilterText) {
        final Filter<DependencyTree> filter = DependencyTreeFilters.parse(includeOptionalDependencyFilterText);
        final boolean excludeAll = Filters.isEmpty(filter);
        return new Filter<DependencyTree>(){

            @Override
            public boolean matches(DependencyTree tree) {
                if (tree.isThisOrDescendantOptional()) {
                    if (excludeAll) {
                        return true;
                    }
                    return !filter.matches(tree);
                }
                return false;
            }
        };
    }

    public static Filter<DependencyTree> parseRequireBundleFilter(String filterText) {
        return DependencyTreeFilters.parse(filterText);
    }

    public static Filter<DependencyTree> parse(String dependencyFilterText) {
        ArrayList filters = new ArrayList();
        if (dependencyFilterText != null) {
            StringTokenizer iter = new StringTokenizer(dependencyFilterText);
            while (iter.hasMoreElements()) {
                String text = iter.nextToken();
                Filter<DependencyTree> filter = DependencyTreeFilters.parseSingleFilter(text);
                if (filter == null) continue;
                filters.add(filter);
            }
        }
        return Filters.compositeFilter(filters);
    }

    protected static Filter<DependencyTree> parseSingleFilter(String text) {
        String[] split = text.split(":");
        if (split == null || split.length == 0) {
            return null;
        }
        Filter<String> groupFilter = Filters.createStringFilter(split[0]);
        Filter<Object> artifactFilter = split.length == 1 ? Filters.trueFilter() : Filters.createStringFilter(split[1]);
        return new DependencyTreeFilter(groupFilter, artifactFilter);
    }

    public static void prune(DependencyTree root, Filter<DependencyTree> filter) {
        LinkedList<DependencyTree> children = new LinkedList<DependencyTree>();
        children.addAll(root.getChildren());
        for (DependencyTree child : children) {
            if (filter.matches(child)) {
                root.getChildren().remove(child);
                continue;
            }
            DependencyTreeFilters.prune(child, filter);
        }
    }
}

