/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.boot.commands;

import io.fabric8.api.ContainerOptions;
import io.fabric8.api.FabricConstants;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.utils.BundleUtils;
import io.fabric8.utils.FabricValidations;
import io.fabric8.utils.PasswordEncoder;
import io.fabric8.utils.shell.ShellUtils;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryOneTime;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.utils.properties.Properties;
import org.apache.karaf.shell.console.AbstractAction;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

@Command(name="join", scope="fabric", description="Join a container to an existing fabric", detailedDescription="classpath:join.txt")
final class JoinAction
extends AbstractAction {
    @Option(name="-n", aliases={"--non-managed"}, multiValued=false, description="Flag to keep the container non managed")
    private boolean nonManaged;
    @Option(name="-f", aliases={"--force"}, multiValued=false, description="Forces the use of container name")
    private boolean force;
    @Option(name="-p", aliases={"--profile"}, multiValued=false, description="Chooses the profile of the container")
    private String profile = "fabric";
    @Option(name="-v", aliases={"--version"}, multiValued=false, description="Chooses the version of the container.")
    private String version = ContainerOptions.DEFAULT_VERSION;
    @Option(name="--min-port", multiValued=false, description="The minimum port of the allowed port range")
    private int minimumPort = 0;
    @Option(name="--max-port", multiValued=false, description="The maximum port of the allowed port range")
    private int maximumPort = 65535;
    @Argument(required=true, index=0, multiValued=false, description="Zookeeper URL")
    private String zookeeperUrl;
    @Option(name="-r", aliases={"--resolver"}, description="The resolver policy. Possible values are: localip, localhostname, publicip, publichostname, manualip. Default is localhostname.")
    String resolver;
    @Option(name="-b", aliases={"--bind-address"}, description="The default bind address.")
    String bindAddress;
    @Option(name="-m", aliases={"--manual-ip"}, description="An address to use, when using the manualip resolver.")
    String manualIp;
    @Option(name="--zookeeper-password", multiValued=false, description="The ensemble password to use.")
    private String zookeeperPassword;
    @Argument(required=false, index=1, multiValued=false, description="Container name to use in fabric. By default a karaf name will be used")
    private String containerName;
    private final ConfigurationAdmin configAdmin;
    private final BundleContext bundleContext;
    private final RuntimeProperties runtimeProperties;

    JoinAction(BundleContext bundleContext, ConfigurationAdmin configAdmin, RuntimeProperties runtimeProperties) {
        this.configAdmin = configAdmin;
        this.bundleContext = bundleContext;
        this.runtimeProperties = runtimeProperties;
    }

    protected Object doExecute() throws Exception {
        if (this.nonManaged) {
            this.profile = "unmanaged";
        }
        String oldName = this.runtimeProperties.getRuntimeIdentity();
        if (System.getenv("OPENSHIFT_BROKER_HOST") != null && this.containerName != null) {
            System.err.println("Containers in OpenShift cannot be renamed");
            return null;
        }
        if (this.containerName == null) {
            this.containerName = oldName;
        }
        FabricValidations.validateContainerName(this.containerName);
        Configuration bootConfiguration = this.configAdmin.getConfiguration("io.fabric8.bootstrap.configuration", null);
        Hashtable<String, String> bootProperties = bootConfiguration.getProperties();
        if (bootProperties == null) {
            bootProperties = new Hashtable<String, String>();
        }
        if (this.resolver != null) {
            ((Dictionary)bootProperties).put("local.resolver", this.resolver);
        }
        if (this.manualIp != null) {
            ((Dictionary)bootProperties).put("manualip", this.manualIp);
        }
        if (this.bindAddress != null) {
            ((Dictionary)bootProperties).put("bind.address", this.bindAddress);
        }
        String string = this.zookeeperPassword = this.zookeeperPassword != null ? this.zookeeperPassword : ShellUtils.retrieveFabricZookeeperPassword(this.session);
        if (this.zookeeperPassword == null) {
            this.zookeeperPassword = this.promptForZookeeperPassword();
        }
        if (this.zookeeperPassword == null || this.zookeeperPassword.isEmpty()) {
            System.out.println("No password specified. Cannot join fabric ensemble.");
            return null;
        }
        ShellUtils.storeZookeeperPassword(this.session, this.zookeeperPassword);
        this.log.debug("Encoding ZooKeeper password.");
        String encodedPassword = PasswordEncoder.encode(this.zookeeperPassword);
        ((Dictionary)bootProperties).put("minimum.port", String.valueOf(this.minimumPort));
        ((Dictionary)bootProperties).put("maximum.port", String.valueOf(this.maximumPort));
        if (!this.containerName.equals(oldName)) {
            if (this.force || this.permissionToRenameContainer()) {
                if (!this.registerContainer(this.containerName, this.zookeeperPassword, this.profile, this.force)) {
                    System.err.println("A container with the name: " + this.containerName + " is already member of the cluster. You can specify a different name as an argument.");
                    return null;
                }
                ((Dictionary)bootProperties).put("karaf.name", this.containerName);
                ((Dictionary)bootProperties).put("zookeeper.password", encodedPassword);
                ((Dictionary)bootProperties).put("zookeeper.url", this.zookeeperUrl);
                Path propsPath = this.runtimeProperties.getConfPath().resolve("system.properties");
                Properties systemProps = new Properties(propsPath.toFile());
                systemProps.put("karaf.name", this.containerName);
                systemProps.put("zookeeper.url", this.zookeeperUrl);
                systemProps.put("zookeeper.password", encodedPassword);
                systemProps.save();
                System.setProperty("runtime.id", this.containerName);
                System.setProperty("karaf.name", this.containerName);
                System.setProperty("karaf.restart", "true");
                System.setProperty("karaf.restart.clean", "false");
                if (!this.nonManaged) {
                    this.installBundles();
                }
                bootConfiguration.update(bootProperties);
                this.bundleContext.getBundle(0L).stop();
                return null;
            }
            return null;
        }
        bootConfiguration.update(bootProperties);
        if (!this.registerContainer(this.containerName, this.zookeeperPassword, this.profile, this.force)) {
            System.err.println("A container with the name: " + this.containerName + " is already member of the cluster. You can specify a different name as an argument.");
            return null;
        }
        Configuration config = this.configAdmin.getConfiguration("io.fabric8.zookeeper");
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("zookeeper.url", this.zookeeperUrl);
        properties.put("zookeeper.password", PasswordEncoder.encode(encodedPassword));
        config.setBundleLocation(null);
        config.update(properties);
        if (!this.nonManaged) {
            this.installBundles();
        }
        return null;
    }

    private String promptForZookeeperPassword() throws IOException {
        String password = ShellUtils.readLine(this.session, "Ensemble password: ", true);
        return password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean registerContainer(String name, String registryPassword, String profile, boolean force) throws Exception {
        boolean exists = false;
        try (CuratorFramework curator = null;){
            CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().connectString(this.zookeeperUrl).retryPolicy((RetryPolicy)new RetryOneTime(1000)).connectionTimeoutMs(60000);
            if (registryPassword != null && !registryPassword.isEmpty()) {
                builder.authorization("digest", ("fabric:" + registryPassword).getBytes());
            }
            curator = builder.build();
            curator.start();
            curator.getZookeeperClient().blockUntilConnectedOrTimedOut();
            boolean bl = exists = ZooKeeperUtils.exists((CuratorFramework)curator, (String)ZkPath.CONTAINER.getPath(new String[]{name})) != null;
            if (!exists || force) {
                ZkPath.createContainerPaths((CuratorFramework)curator, (String)this.containerName, (String)this.version, (String)profile);
            }
        }
        return !exists || force;
    }

    private boolean permissionToRenameContainer() throws IOException {
        System.err.println("You are about to change the container name. This action will restart the container.");
        System.err.println("The local shell will automatically restart, but ssh connections will be terminated.");
        System.err.println("The container will automatically join: " + this.zookeeperUrl + " the cluster after it restarts.");
        System.err.flush();
        String response = ShellUtils.readLine(this.session, "Do you wish to proceed (yes/no): ", false);
        return response != null && (response.toLowerCase().equals("yes") || response.toLowerCase().equals("y"));
    }

    public void installBundles() throws BundleException {
        BundleUtils bundleUtils = new BundleUtils(this.bundleContext);
        Bundle bundleFabricCommands = bundleUtils.findBundle("io.fabric8.fabric-commands");
        if (bundleFabricCommands == null) {
            bundleFabricCommands = bundleUtils.installBundle("mvn:io.fabric8/fabric-commands/" + FabricConstants.FABRIC_VERSION);
        }
        bundleFabricCommands.start();
        Bundle bundleFabricAgent = bundleUtils.findBundle("io.fabric8.fabric-agent");
        if (!this.nonManaged || bundleFabricAgent != null) {
            if (this.nonManaged && bundleFabricAgent != null) {
                bundleFabricAgent.stop();
            } else if (bundleFabricAgent == null) {
                bundleFabricAgent = bundleUtils.installBundle("mvn:io.fabric8/fabric-agent/" + FabricConstants.FABRIC_VERSION);
                bundleFabricAgent.start();
            } else {
                bundleFabricAgent.start();
            }
        }
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getZookeeperUrl() {
        return this.zookeeperUrl;
    }

    public void setZookeeperUrl(String zookeeperUrl) {
        this.zookeeperUrl = zookeeperUrl;
    }

    public boolean isNonManaged() {
        return this.nonManaged;
    }

    public void setNonManaged(boolean nonManaged) {
        this.nonManaged = nonManaged;
    }

    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public String getResolver() {
        return this.resolver;
    }

    public void setResolver(String resolver) {
        this.resolver = resolver;
    }

    public String getManualIp() {
        return this.manualIp;
    }

    public void setManualIp(String manualIp) {
        this.manualIp = manualIp;
    }

    public String getZookeeperPassword() {
        return this.zookeeperPassword;
    }

    public void setZookeeperPassword(String zookeeperPassword) {
        this.zookeeperPassword = zookeeperPassword;
    }
}

