/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.camel;

import io.fabric8.camel.CamelNodeState;
import io.fabric8.camel.FabricComponent;
import io.fabric8.camel.LoadBalancerFactory;
import io.fabric8.groups.Group;
import io.fabric8.groups.GroupListener;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.impl.ProducerCache;
import org.apache.camel.processor.loadbalancer.LoadBalancer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.curator.framework.CuratorFramework;

public class FabricLocatorEndpoint
extends DefaultEndpoint
implements GroupListener<CamelNodeState> {
    private static final transient Log LOG = LogFactory.getLog(FabricLocatorEndpoint.class);
    private final FabricComponent component;
    private final Group<CamelNodeState> group;
    private LoadBalancerFactory loadBalancerFactory;
    private LoadBalancer loadBalancer;
    private final Map<String, Processor> processors = new HashMap<String, Processor>();

    public FabricLocatorEndpoint(String uri, FabricComponent component, String singletonId) {
        super(uri, (Component)component);
        this.component = component;
        String path = this.getComponent().getFabricPath(singletonId);
        this.group = this.getComponent().createGroup(path);
        this.group.add((GroupListener)this);
    }

    public synchronized void groupEvent(Group<CamelNodeState> group, GroupListener.GroupEvent event) {
        String key;
        Map members = event == GroupListener.GroupEvent.DISCONNECTED || !this.isStarted() ? Collections.emptyMap() : group.members();
        LinkedHashSet<String> removed = new LinkedHashSet<String>();
        for (Map.Entry<String, Processor> entry : this.processors.entrySet()) {
            key = entry.getKey();
            if (members.containsKey(key)) continue;
            removed.add(key);
        }
        for (Map.Entry<String, Object> entry : members.entrySet()) {
            try {
                key = entry.getKey();
                if (this.processors.containsKey(key)) continue;
                Processor p = this.getProcessor(((CamelNodeState)((Object)entry.getValue())).consumer);
                this.processors.put(key, p);
                this.loadBalancer.addProcessor(p);
            }
            catch (URISyntaxException e) {
                LOG.warn((Object)("Unable to add endpoint " + ((CamelNodeState)((Object)entry.getValue())).consumer), (Throwable)e);
            }
        }
        for (String string : removed) {
            Processor p = this.processors.remove(string);
            this.loadBalancer.removeProcessor(p);
        }
    }

    public Producer createProducer() throws Exception {
        FabricLocatorEndpoint endpoint = this;
        return new DefaultProducer((Endpoint)endpoint){

            public void process(Exchange exchange) throws Exception {
                FabricLocatorEndpoint.this.loadBalancer.process(exchange);
            }
        };
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot consume from a FABRIC endpoint using just its fabric name directly, you must use fabric:name:someActualUri instead");
    }

    public boolean isSingleton() {
        return true;
    }

    public void start() throws Exception {
        super.start();
        if (this.loadBalancer == null) {
            this.loadBalancer = this.createLoadBalancer();
        }
        this.group.start();
    }

    public void stop() throws Exception {
        super.stop();
        this.group.close();
    }

    public Processor getProcessor(String uri) throws URISyntaxException {
        uri = ZooKeeperUtils.getSubstitutedData((CuratorFramework)this.component.getCurator(), (String)uri);
        LOG.info((Object)("Creating endpoint for " + uri));
        final Endpoint endpoint = this.getCamelContext().getEndpoint(uri);
        return new Processor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void process(Exchange exchange) throws Exception {
                ProducerCache producerCache = FabricLocatorEndpoint.this.component.getProducerCache();
                Producer producer = producerCache.acquireProducer(endpoint);
                try {
                    producer.process(exchange);
                }
                finally {
                    producerCache.releaseProducer(endpoint, producer);
                }
            }

            public String toString() {
                return "Producer for " + endpoint;
            }
        };
    }

    public FabricComponent getComponent() {
        return this.component;
    }

    public LoadBalancerFactory getLoadBalancerFactory() {
        if (this.loadBalancerFactory == null) {
            this.loadBalancerFactory = this.component.getLoadBalancerFactory();
        }
        return this.loadBalancerFactory;
    }

    public void setLoadBalancerFactory(LoadBalancerFactory loadBalancerFactory) {
        this.loadBalancerFactory = loadBalancerFactory;
    }

    public LoadBalancer createLoadBalancer() {
        return this.getLoadBalancerFactory().createLoadBalancer();
    }
}

