/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.camel;

import io.fabric8.camel.CamelNodeState;
import io.fabric8.camel.FabricComponent;
import io.fabric8.groups.Group;
import io.fabric8.groups.NodeState;
import java.net.URI;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.URISupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FabricPublisherEndpoint
extends DefaultEndpoint {
    private static final transient Log LOG = LogFactory.getLog(FabricPublisherEndpoint.class);
    private final FabricComponent component;
    private final String singletonId;
    private final String child;
    private final String consumer;
    private final Group<CamelNodeState> group;
    private String joined;

    public FabricPublisherEndpoint(String uri, FabricComponent component, String singletonId, String child) throws Exception {
        super(uri, (Component)component);
        Map params;
        String consumer;
        this.component = component;
        this.singletonId = singletonId;
        String path = child;
        int idx = path.indexOf(63);
        if (idx > -1) {
            path = path.substring(0, idx);
        }
        String string = consumer = (params = URISupport.parseParameters((URI)new URI(child))) != null ? (String)params.remove("consumer") : null;
        if (consumer != null) {
            Map properties = IntrospectionSupport.extractProperties((Map)params, (String)"consumer.");
            if (properties != null && properties.size() > 0) {
                consumer = consumer + "?" + URISupport.createQueryString((Map)properties);
                for (String k : properties.keySet()) {
                    params.remove(k);
                }
            }
            child = path;
            if (params.size() > 0) {
                child = child + "?" + URISupport.createQueryString((Map)params);
            }
        } else {
            consumer = child;
        }
        LOG.info((Object)("Child: " + child));
        LOG.info((Object)("Consumer: " + consumer));
        this.child = child;
        this.consumer = consumer;
        path = this.getComponent().getFabricPath(singletonId);
        this.group = this.getComponent().createGroup(path);
        CamelNodeState state = new CamelNodeState(singletonId);
        state.consumer = consumer;
        this.group.update((NodeState)state);
    }

    public Producer createProducer() throws Exception {
        return this.getCamelContext().getEndpoint(this.child).createProducer();
    }

    public boolean isLenientProperties() {
        return true;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return this.getCamelContext().getEndpoint(this.child).createConsumer(processor);
    }

    public boolean isSingleton() {
        return true;
    }

    public void doStart() throws Exception {
        super.doStart();
        this.group.start();
    }

    public void doStop() throws Exception {
        this.group.close();
        super.doStop();
    }

    public FabricComponent getComponent() {
        return this.component;
    }

    public String getChild() {
        return this.child;
    }
}

