/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.api;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.ProfileBuilder;
import io.fabric8.api.ProfileService;
import io.fabric8.api.Version;
import io.fabric8.api.gravia.IllegalArgumentAssertion;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Profiles {
    private static final Logger LOGGER = LoggerFactory.getLogger(Profiles.class);
    public static final boolean useDirectoriesForProfiles = true;
    public static final String PROFILE_FOLDER_SUFFIX = ".profile";

    private Profiles() {
    }

    public static List<String> profileIds(Iterable<Profile> profiles) {
        ArrayList<String> answer = new ArrayList<String>();
        if (profiles != null) {
            for (Profile profile : profiles) {
                answer.add(profile.getId());
            }
        }
        return answer;
    }

    public static List<String> profileIds(Profile ... profiles) {
        ArrayList<String> answer = new ArrayList<String>();
        if (profiles != null) {
            for (Profile profile : profiles) {
                answer.add(profile.getId());
            }
        }
        return answer;
    }

    public static String versionId(Version version) {
        return version != null ? version.getId() : null;
    }

    public static List<String> versionIds(Version ... versions) {
        ArrayList<String> answer = new ArrayList<String>();
        if (versions != null) {
            for (Version version : versions) {
                answer.add(version.getId());
            }
        }
        return answer;
    }

    public static List<String> versionIds(Iterable<Version> versions) {
        ArrayList<String> answer = new ArrayList<String>();
        if (versions != null) {
            for (Version version : versions) {
                answer.add(version.getId());
            }
        }
        return answer;
    }

    public static Profile profile(Profile[] profiles, String profileId) {
        if (profiles != null) {
            for (Profile profile : profiles) {
                if (!profileId.equals(profile.getId())) continue;
                return profile;
            }
        }
        return null;
    }

    public static Set<String> getConfigurationFileNames(Collection<Profile> profiles) {
        HashSet<String> set = new HashSet<String>();
        for (Profile profile : profiles) {
            set.addAll(profile.getConfigurationFileNames());
        }
        return set;
    }

    public static byte[] getFileConfiguration(Collection<Profile> profiles, String fileName) {
        Profile profile;
        byte[] answer = null;
        Iterator<Profile> i$ = profiles.iterator();
        while (i$.hasNext() && (answer = (profile = i$.next()).getFileConfiguration(fileName)) == null) {
        }
        return answer;
    }

    public static Map<String, String> getConfigurationFileNameMap(Profile[] profiles) {
        TreeMap<String, String> answer = new TreeMap<String, String>();
        for (Profile profile : profiles) {
            String id = profile.getId();
            Set<String> files = profile.getConfigurationFileNames();
            for (String file : files) {
                if (answer.containsKey(file)) continue;
                answer.put(file, id);
            }
        }
        return answer;
    }

    public static Profile getEffectiveProfile(FabricService fabricService, Profile profile) {
        ProfileService profileService = fabricService.adapt(ProfileService.class);
        Profile overlayProfile = profileService.getOverlayProfile(profile);
        Map<String, Map<String, String>> configurations = overlayProfile.getConfigurations();
        ProfileBuilder builder = ProfileBuilder.Factory.createFrom(overlayProfile);
        builder.setConfigurations(fabricService.substituteConfigurations(configurations));
        return builder.getProfile();
    }

    public static Map<String, String> getOverlayConfiguration(FabricService fabricService, Iterable<String> profileIds, String versionId, String pid) {
        String environment = fabricService.getEnvironment();
        return Profiles.getOverlayConfiguration(fabricService, profileIds, versionId, pid, environment);
    }

    public static Map<String, String> getOverlayConfiguration(FabricService fabricService, Iterable<String> profileIds, String versionId, String pid, String environment) {
        HashMap<String, String> overlayConfig = new HashMap<String, String>();
        ProfileService profileService = fabricService.adapt(ProfileService.class);
        if (profileService != null) {
            Version version = null;
            version = versionId == null ? fabricService.getRequiredDefaultVersion() : profileService.getRequiredVersion(versionId);
            if (profileIds != null) {
                for (String profileId : profileIds) {
                    Profile profile = version.getRequiredProfile(profileId);
                    Profile overlay = profileService.getOverlayProfile(profile);
                    Map<String, String> profileConfig = overlay.getConfiguration(pid);
                    if (profileConfig == null) continue;
                    overlayConfig.putAll(profileConfig);
                }
            }
        }
        return overlayConfig;
    }

    public static Map<String, Map<String, String>> getOverlayFactoryConfigurations(FabricService fabricService, Iterable<String> profileIds, String versionId, String pid) {
        ProfileService profileService = fabricService.adapt(ProfileService.class);
        HashMap<String, Map<String, String>> answer = new HashMap<String, Map<String, String>>();
        Version version = null;
        version = versionId == null ? fabricService.getRequiredDefaultVersion() : profileService.getRequiredVersion(versionId);
        String prefix = pid + "-";
        String postfix = ".properties";
        if (profileIds != null) {
            for (String profileId : profileIds) {
                Profile profile = version.getRequiredProfile(profileId);
                Profile overlay = profileService.getOverlayProfile(profile);
                Set<String> configurationFileNames = overlay.getConfigurationFileNames();
                for (String fileName : configurationFileNames) {
                    String filePid;
                    Map<String, String> profileConfig;
                    if (!fileName.startsWith(prefix) || !fileName.endsWith(postfix)) continue;
                    String name = fileName.substring(prefix.length(), fileName.length() - postfix.length());
                    HashMap<String, String> overlayConfig = (HashMap<String, String>)answer.get(name);
                    if (overlayConfig == null) {
                        overlayConfig = new HashMap<String, String>();
                        answer.put(name, overlayConfig);
                    }
                    if ((profileConfig = overlay.getConfiguration(filePid = fileName.substring(0, fileName.length() - postfix.length()))) == null) continue;
                    overlayConfig.putAll(profileConfig);
                }
            }
        }
        return answer;
    }

    public static Map<String, Map<String, String>> getOverlayConfigurations(FabricService fabricService, Iterable<String> profileIds, String versionId) {
        ProfileService profileService = fabricService.adapt(ProfileService.class);
        HashMap<String, Map<String, String>> answer = new HashMap<String, Map<String, String>>();
        Version version = null;
        version = versionId == null ? fabricService.getRequiredDefaultVersion() : profileService.getRequiredVersion(versionId);
        if (profileIds != null) {
            for (String profileId : profileIds) {
                Profile profile = version.getRequiredProfile(profileId);
                Profile overlay = profileService.getOverlayProfile(profile);
                Map<String, Map<String, String>> configurations = overlay.getConfigurations();
                Set<Map.Entry<String, Map<String, String>>> entries = configurations.entrySet();
                for (Map.Entry<String, Map<String, String>> entry : entries) {
                    String pid = entry.getKey();
                    Map<String, String> configuration = entry.getValue();
                    if (configuration == null) continue;
                    Map oldConfig = (Map)answer.get(pid);
                    if (oldConfig == null) {
                        answer.put(pid, configuration);
                        continue;
                    }
                    oldConfig.putAll(configuration);
                }
            }
        }
        return answer;
    }

    public static Map<String, Map<String, String>> getOverlayConfigurations(FabricService fabricService, Iterable<Profile> profiles) {
        ProfileService profileService = fabricService.adapt(ProfileService.class);
        HashMap<String, Map<String, String>> answer = new HashMap<String, Map<String, String>>();
        if (profiles != null) {
            for (Profile profile : profiles) {
                Profile overlay = profileService.getOverlayProfile(profile);
                Map<String, Map<String, String>> configurations = overlay.getConfigurations();
                Set<Map.Entry<String, Map<String, String>>> entries = configurations.entrySet();
                for (Map.Entry<String, Map<String, String>> entry : entries) {
                    String pid = entry.getKey();
                    Map<String, String> configuration = entry.getValue();
                    if (configuration == null) continue;
                    HashMap<String, String> oldConfig = (HashMap<String, String>)answer.get(pid);
                    if (oldConfig == null) {
                        oldConfig = new HashMap<String, String>();
                        answer.put(pid, oldConfig);
                    }
                    oldConfig.putAll(configuration);
                }
            }
        }
        return answer;
    }

    public static List<Profile> getProfiles(FabricService fabricService, Iterable<String> profileIds, String versionId) {
        ProfileService profileService = fabricService.adapt(ProfileService.class);
        Version version = versionId == null ? fabricService.getRequiredDefaultVersion() : profileService.getRequiredVersion(versionId);
        ArrayList<Profile> answer = new ArrayList<Profile>();
        if (profileIds != null && version != null) {
            for (String profileId : profileIds) {
                Profile profile = version.getRequiredProfile(profileId);
                if (profile == null) continue;
                answer.add(profile);
            }
        }
        return answer;
    }

    public static String convertProfileIdToPath(String profileId) {
        return profileId.replace('-', File.separatorChar) + PROFILE_FOLDER_SUFFIX;
    }

    public static String getSummaryMarkdown(Profile[] profiles) {
        String answer = null;
        if (profiles != null) {
            Profile parent;
            Profile[] arr$ = profiles;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (answer = (parent = arr$[i$]).getSummaryMarkdown()) == null; ++i$) {
            }
        }
        return answer;
    }

    public static boolean agentConfigurationEquals(FabricService fabricService, Profile thisProfile, Profile otherProfile) {
        ProfileService profileService = fabricService.adapt(ProfileService.class);
        Profile thisOverlay = profileService.getOverlayProfile(thisProfile);
        Profile otherOverlay = profileService.getOverlayProfile(otherProfile);
        return thisOverlay.getConfiguration("io.fabric8.agent").equals(otherOverlay.getConfiguration("io.fabric8.agent"));
    }

    public static void copyProfile(FabricService fabricService, String versionId, String sourceId, String targetId, boolean force) {
        ProfileService profileService = fabricService.adapt(ProfileService.class);
        Profile sourceProfile = profileService.getRequiredProfile(versionId, sourceId);
        LOGGER.info("copyProfile: {} => {}", (Object)sourceProfile, (Object)targetId);
        Profiles.maybeDeleteProfile(fabricService, versionId, targetId, force);
        ProfileBuilder builder = ProfileBuilder.Factory.createFrom(sourceProfile);
        profileService.createProfile(builder.identity(targetId).getProfile());
    }

    public static void renameProfile(FabricService fabricService, String versionId, String sourceId, String targetId, boolean force) {
        ProfileService profileService = fabricService.adapt(ProfileService.class);
        Profile sourceProfile = profileService.getRequiredProfile(versionId, sourceId);
        LOGGER.info("renameProfile: {} => {}", (Object)sourceProfile, (Object)targetId);
        Profiles.maybeDeleteProfile(fabricService, versionId, targetId, force);
        ProfileBuilder builder = ProfileBuilder.Factory.createFrom(sourceProfile);
        Profile targetProfile = profileService.createProfile(builder.identity(targetId).getProfile());
        for (Container container : fabricService.getAssociatedContainers(versionId, sourceId)) {
            Profile[] containerProfiles = container.getProfiles();
            HashSet<Profile> profileSet = new HashSet<Profile>(Arrays.asList(containerProfiles));
            profileSet.remove(sourceProfile);
            profileSet.add(targetProfile);
            container.setProfiles(profileSet.toArray(new Profile[profileSet.size()]));
        }
        Profiles.maybeDeleteProfile(fabricService, versionId, sourceId, true);
    }

    private static void maybeDeleteProfile(FabricService fabricService, String versionId, String targetId, boolean force) {
        ProfileService profileService = fabricService.adapt(ProfileService.class);
        if (force && profileService.hasProfile(versionId, targetId)) {
            profileService.deleteProfile(fabricService, versionId, targetId, force);
        }
    }

    public static void refreshProfile(FabricService fabricService, Profile profile) {
        LOGGER.info("refreshProfile: {}", (Object)profile);
        ProfileService profileService = fabricService.adapt(ProfileService.class);
        ProfileBuilder builder = ProfileBuilder.Factory.createFrom(profile);
        Map<String, String> agentConfiguration = builder.getConfiguration("io.fabric8.agent");
        agentConfiguration.put("lastRefresh." + profile.getId(), String.valueOf(System.currentTimeMillis()));
        builder.addConfiguration("io.fabric8.agent", agentConfiguration);
        profileService.updateProfile(builder.getProfile());
    }

    public static void assertValidProfileId(Set<String> profileIds, String profileId) {
        if (!profileIds.contains(profileId)) {
            throw new IllegalArgumentException("Profile " + profileId + " is not valid");
        }
    }

    public static String getProfileInfo(Profile profile) {
        IllegalArgumentAssertion.assertNotNull(profile, "profile");
        StringBuilder builder = new StringBuilder("Profile[ver=" + profile.getVersion() + ",id=" + profile.getId() + "]");
        builder.append("\nAttributes");
        TreeMap<String, String> attributes = new TreeMap<String, String>(profile.getAttributes());
        for (Map.Entry entry : attributes.entrySet()) {
            builder.append("\n  " + (String)entry.getKey() + " = " + (String)entry.getValue());
        }
        builder.append("\nConfigurations");
        for (String pid : new TreeSet<String>(profile.getConfigurations().keySet())) {
            builder.append("\n  " + pid);
            TreeMap<String, String> config = new TreeMap<String, String>(profile.getConfiguration(pid));
            for (Map.Entry citem : config.entrySet()) {
                builder.append("\n    " + (String)citem.getKey() + " = " + (String)citem.getValue());
            }
        }
        builder.append("\nFiles");
        for (String fileKey : new TreeSet<String>(profile.getFileConfigurations().keySet())) {
            if (fileKey.endsWith(".properties")) continue;
            builder.append("\n  " + fileKey);
        }
        return builder.toString();
    }

    public static String getProfileDifference(Profile leftProfile, Profile rightProfile) {
        TreeMap<String, String> config;
        IllegalArgumentAssertion.assertNotNull(leftProfile, "leftProfile");
        IllegalArgumentAssertion.assertNotNull(rightProfile, "rightProfile");
        if (leftProfile.equals(rightProfile)) {
            return "ProfileDiff [ver=" + leftProfile.getVersion() + ",id=" + leftProfile.getId() + "] - equals";
        }
        StringBuilder builder = new StringBuilder("ProfileDiff [ver=" + leftProfile.getVersion() + ",id=" + leftProfile.getId() + "] vs. [ver=" + rightProfile.getVersion() + ",id=" + rightProfile.getId() + "]");
        MapDifference<String, String> attributeDiff = Maps.difference(leftProfile.getAttributes(), rightProfile.getAttributes());
        Sets.SetView<String> leftOnlyPids = Sets.difference(leftProfile.getConfigurations().keySet(), rightProfile.getConfigurations().keySet());
        Sets.SetView<String> rightOnlyPids = Sets.difference(rightProfile.getConfigurations().keySet(), leftProfile.getConfigurations().keySet());
        Sets.SetView<String> commonPids = Sets.union(leftProfile.getConfigurations().keySet(), rightProfile.getConfigurations().keySet());
        Sets.SetView<String> leftOnlyFiles = Sets.difference(leftProfile.getFileConfigurations().keySet(), rightProfile.getFileConfigurations().keySet());
        Sets.SetView<String> rightOnlyFiles = Sets.difference(rightProfile.getFileConfigurations().keySet(), leftProfile.getFileConfigurations().keySet());
        builder.append("\nAttributes");
        builder.append("\n  " + attributeDiff);
        builder.append("\nConfigurations");
        builder.append("\n  left only: " + leftOnlyPids);
        for (String pid : leftOnlyPids) {
            builder.append("\n  " + pid);
            config = new TreeMap<String, String>(leftProfile.getConfiguration(pid));
            for (Map.Entry citem : config.entrySet()) {
                builder.append("\n    " + (String)citem.getKey() + " = " + (String)citem.getValue());
            }
        }
        builder.append("\n  right only: " + rightOnlyPids);
        for (String pid : rightOnlyPids) {
            builder.append("\n  " + pid);
            config = new TreeMap<String, String>(rightProfile.getConfiguration(pid));
            for (Map.Entry citem : config.entrySet()) {
                builder.append("\n    " + (String)citem.getKey() + " = " + (String)citem.getValue());
            }
        }
        for (String pid : commonPids) {
            Map<String, String> rightConfig;
            Map<String, String> leftConfig = leftProfile.getConfiguration(pid);
            if (leftConfig.equals(rightConfig = rightProfile.getConfiguration(pid))) continue;
            builder.append("\n  " + pid + ": " + Maps.difference(leftConfig, rightConfig));
        }
        builder.append("\nFiles");
        builder.append("\n  left only: " + leftOnlyFiles);
        builder.append("\n  right only: " + rightOnlyFiles);
        return builder.toString();
    }
}

