/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.api.mxbean;

import io.fabric8.api.Profile;
import io.fabric8.api.ProfileBuilder;
import java.beans.ConstructorProperties;
import java.lang.reflect.Array;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ProfileState {
    private final Profile delegate;

    @ConstructorProperties(value={"version", "id", "fileConfigurations", "profileHash", "overlay"})
    public ProfileState(String versionId, String profileId, Map<String, Byte[]> fileConfigs, String lastModified, boolean isOverlay) {
        ProfileBuilder builder = ProfileBuilder.Factory.create(versionId, profileId);
        builder.setLastModified(lastModified).setOverlay(isOverlay);
        if (fileConfigs != null) {
            for (Map.Entry<String, Byte[]> entry : fileConfigs.entrySet()) {
                builder.addFileConfiguration(entry.getKey(), this.toPrimitiveArray(entry.getValue()));
            }
        }
        this.delegate = builder.getProfile();
    }

    public ProfileState(Profile profile) {
        this.delegate = profile;
    }

    public Profile toProfile() {
        return this.delegate;
    }

    public String getId() {
        return this.delegate.getId();
    }

    public String getVersion() {
        return this.delegate.getVersion();
    }

    public Map<String, String> getAttributes() {
        return this.delegate.getAttributes();
    }

    public List<String> getParentIds() {
        return this.delegate.getParentIds();
    }

    public List<String> getLibraries() {
        return this.delegate.getLibraries();
    }

    public List<String> getEndorsedLibraries() {
        return this.delegate.getEndorsedLibraries();
    }

    public List<String> getExtensionLibraries() {
        return this.delegate.getExtensionLibraries();
    }

    public List<String> getBundles() {
        return this.delegate.getBundles();
    }

    public List<String> getFabs() {
        return this.delegate.getFabs();
    }

    public List<String> getFeatures() {
        return this.delegate.getFeatures();
    }

    public List<String> getRepositories() {
        return this.delegate.getRepositories();
    }

    public List<String> getOverrides() {
        return this.delegate.getOverrides();
    }

    public List<String> getOptionals() {
        return this.delegate.getOptionals();
    }

    public String getIconURL() {
        return this.delegate.getIconURL();
    }

    public String getIconRelativePath() {
        return this.delegate.getIconRelativePath();
    }

    public String getSummaryMarkdown() {
        return this.delegate.getSummaryMarkdown();
    }

    public List<String> getTags() {
        return this.delegate.getTags();
    }

    public Set<String> getConfigurationFileNames() {
        return this.delegate.getConfigurationFileNames();
    }

    public Map<String, Byte[]> getFileConfigurations() {
        LinkedHashMap<String, Byte[]> result = new LinkedHashMap<String, Byte[]>();
        for (Map.Entry<String, byte[]> entry : this.delegate.getFileConfigurations().entrySet()) {
            result.put(entry.getKey(), this.fromPrimitiveArray(entry.getValue()));
        }
        return result;
    }

    public Byte[] getFileConfiguration(String fileName) {
        byte[] array = this.delegate.getFileConfiguration(fileName);
        return this.fromPrimitiveArray(array);
    }

    public Map<String, Map<String, String>> getConfigurations() {
        return this.delegate.getConfigurations();
    }

    public Map<String, String> getConfiguration(String pid) {
        return this.delegate.getConfiguration(pid);
    }

    public boolean isAbstract() {
        return this.delegate.isAbstract();
    }

    public boolean isLocked() {
        return this.delegate.isLocked();
    }

    public boolean isHidden() {
        return this.delegate.isHidden();
    }

    public boolean isOverlay() {
        return this.delegate.isOverlay();
    }

    public String getProfileHash() {
        return this.delegate.getProfileHash();
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProfileState)) {
            return false;
        }
        ProfileState other = (ProfileState)obj;
        return this.delegate.equals(other.delegate);
    }

    public String toString() {
        return this.delegate.toString();
    }

    private Byte[] fromPrimitiveArray(byte[] array) {
        if (array == null) {
            return null;
        }
        Byte[] result = new Byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            Array.set(result, i, array[i]);
        }
        return result;
    }

    private byte[] toPrimitiveArray(Byte[] array) {
        if (array == null) {
            return null;
        }
        byte[] result = new byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            Array.set(result, i, array[i]);
        }
        return result;
    }
}

