/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jolokia.facade.facades;

import io.fabric8.api.Container;
import io.fabric8.api.CreateContainerMetadata;
import io.fabric8.api.FabricService;
import io.fabric8.api.HasId;
import io.fabric8.api.Profile;
import io.fabric8.api.Version;
import io.fabric8.jolokia.facade.facades.ProfileFacade;
import io.fabric8.jolokia.facade.facades.VersionFacade;
import io.fabric8.jolokia.facade.utils.Helpers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jolokia.client.J4pClient;

public class ContainerFacade
implements Container,
HasId {
    private final FabricService fabricService;
    private J4pClient j4p;
    private String id;

    public ContainerFacade(FabricService fabricService, J4pClient j4p, String id) {
        this.fabricService = fabricService;
        this.j4p = j4p;
        this.id = id;
    }

    public J4pClient getJ4p() {
        return this.j4p;
    }

    public void setJ4p(J4pClient j4p) {
        this.j4p = j4p;
    }

    private <T> T getFieldValue(String field) {
        return Helpers.getFieldValue(this.j4p, "getContainer(java.lang.String, java.util.List)", this.id, field);
    }

    @Override
    public FabricService getFabricService() {
        return this.fabricService;
    }

    @Override
    public String getType() {
        return (String)this.getFieldValue("type");
    }

    @Override
    public void setType(String type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Container getParent() {
        String parentId = (String)this.getFieldValue("parentId");
        if (parentId == null) {
            return null;
        }
        return new ContainerFacade(this.fabricService, this.j4p, parentId);
    }

    @Override
    public boolean isAlive() {
        return (Boolean)this.getFieldValue("alive");
    }

    @Override
    public void setAlive(boolean flag) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEnsembleServer() {
        return (Boolean)this.getFieldValue("ensembleServer");
    }

    @Override
    public boolean isRoot() {
        return (Boolean)this.getFieldValue("root");
    }

    @Override
    public String getSshUrl() {
        return (String)this.getFieldValue("sshUrl");
    }

    @Override
    public String getJmxUrl() {
        return (String)this.getFieldValue("jmxUrl");
    }

    @Override
    public String getHttpUrl() {
        return (String)this.getFieldValue("httpUrl");
    }

    @Override
    public void setHttpUrl(String location) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getJolokiaUrl() {
        return (String)this.getFieldValue("jolokiaUrl");
    }

    @Override
    public void setJolokiaUrl(String s) {
        throw new UnsupportedOperationException("This cannot be set from a remote process");
    }

    @Override
    public boolean isManaged() {
        return (Boolean)this.getFieldValue("managed");
    }

    @Override
    public String getVersionId() {
        return (String)this.getFieldValue("versionId");
    }

    @Override
    public void setVersionId(String versionId) {
        Helpers.exec(this.j4p, "applyVersionToContainers(java.lang.String, java.util.List)", versionId, Helpers.toList(this.id));
    }

    @Override
    public Version getVersion() {
        String version = (String)this.getFieldValue("versionId");
        String revision = (String)this.getFieldValue("revision");
        return new VersionFacade(this.j4p, version, revision);
    }

    @Override
    public void setVersion(Version version) {
        Helpers.exec(this.j4p, "applyVersionToContainers(java.lang.String, java.util.List)", version.getId(), Helpers.toList(this.id));
    }

    @Override
    public List<String> getProfileIds() {
        return (List)this.getFieldValue("profileIds");
    }

    @Override
    public Profile[] getProfiles() {
        List profileIds = (List)this.getFieldValue("profileIds");
        if (profileIds == null || profileIds.size() == 0) {
            return new Profile[0];
        }
        String version = (String)this.getFieldValue("versionId");
        ArrayList<ProfileFacade> answer = new ArrayList<ProfileFacade>();
        for (String id : profileIds) {
            answer.add(new ProfileFacade(this.j4p, version, id));
        }
        return answer.toArray(new Profile[answer.size()]);
    }

    @Override
    public void setProfiles(Profile[] profiles) {
        List<String> ids = Helpers.extractIds(profiles);
        Helpers.exec(this.j4p, "applyProfilesToContainers(java.lang.String, java.util.List, java.util.List)", this.getVersion().getId(), ids, Helpers.toList(this.id));
    }

    @Override
    public void addProfiles(Profile ... profiles) {
        List<String> ids = Helpers.extractIds(profiles);
        Helpers.exec(this.j4p, "addProfilesToContainer(java.lang.String, java.util.List)", this.id, ids);
    }

    @Override
    public void removeProfiles(String ... profileIds) {
        List<String> ids = Arrays.asList(profileIds);
        Helpers.exec(this.j4p, "removeProfilesFromContainer(java.lang.String, java.util.List)", this.id, ids);
    }

    @Override
    public Profile getOverlayProfile() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getLocation() {
        return (String)this.getFieldValue("location");
    }

    @Override
    public void setLocation(String s) {
        Helpers.exec(this.j4p, "setContainerProperty(java.lang.String, java.lang.String, java.lang.Object)", this.id, "location", s);
    }

    @Override
    public String getGeoLocation() {
        return (String)this.getFieldValue("geoLocation");
    }

    @Override
    public void setGeoLocation(String s) {
        Helpers.exec(this.j4p, "setContainerProperty(java.lang.String, java.lang.String, java.lang.Object)", this.id, "geoLocation", s);
    }

    @Override
    public String getResolver() {
        return (String)this.getFieldValue("resolver");
    }

    @Override
    public void setResolver(String s) {
        Helpers.exec(this.j4p, "setContainerProperty(java.lang.String, java.lang.String, java.lang.Object)", this.id, "resolver", s);
    }

    @Override
    public String getIp() {
        return (String)this.getFieldValue("ip");
    }

    @Override
    public String getLocalIp() {
        return (String)this.getFieldValue("ip");
    }

    @Override
    public void setLocalIp(String s) {
        Helpers.exec(this.j4p, "setContainerProperty(java.lang.String, java.lang.String, java.lang.Object)", this.id, "localIp", s);
    }

    @Override
    public String getLocalHostname() {
        return (String)this.getFieldValue("localHostname");
    }

    @Override
    public void setLocalHostname(String s) {
        Helpers.exec(this.j4p, "setContainerProperty(java.lang.String, java.lang.String, java.lang.Object)", this.id, "localHostname", s);
    }

    @Override
    public Long getProcessId() {
        return (Long)this.getFieldValue("getProcessId");
    }

    @Override
    public String getPublicIp() {
        return (String)this.getFieldValue("publicIp");
    }

    @Override
    public void setPublicIp(String s) {
        Helpers.exec(this.j4p, "setContainerProperty(java.lang.String, java.lang.String, java.lang.Object)", this.id, "publicIp", s);
    }

    @Override
    public String getPublicHostname() {
        return (String)this.getFieldValue("publicHostname");
    }

    @Override
    public void setPublicHostname(String s) {
        Helpers.exec(this.j4p, "setContainerProperty(java.lang.String, java.lang.String, java.lang.Object)", this.id, "publicHostname", s);
    }

    @Override
    public String getManualIp() {
        return (String)this.getFieldValue("manualip");
    }

    @Override
    public void setManualIp(String s) {
        Helpers.exec(this.j4p, "setContainerProperty(java.lang.String, java.lang.String, java.lang.Object)", this.id, "manualIp", s);
    }

    @Override
    public int getMinimumPort() {
        return (Integer)this.getFieldValue("minimumPort");
    }

    @Override
    public void setMinimumPort(int i) {
        Helpers.exec(this.j4p, "setContainerProperty(java.lang.String, java.lang.String, java.lang.Object)", this.id, "minimumPort", i);
    }

    @Override
    public int getMaximumPort() {
        return (Integer)this.getFieldValue("maximumPort");
    }

    @Override
    public void setMaximumPort(int i) {
        Helpers.exec(this.j4p, "setContainerProperty(java.lang.String, java.lang.String, java.lang.Object)", this.id, "maximumPort", i);
    }

    @Override
    public void start() {
        Helpers.doContainerAction(this.j4p, "start", this.id);
    }

    @Override
    public void start(boolean force) {
        this.start();
    }

    @Override
    public void stop() {
        Helpers.doContainerAction(this.j4p, "stop", this.id);
    }

    @Override
    public void stop(boolean force) {
        this.stop();
    }

    @Override
    public void destroy() {
        Helpers.doContainerAction(this.j4p, "destroy", this.id);
    }

    @Override
    public void destroy(boolean force) {
        this.destroy();
    }

    @Override
    public Container[] getChildren() {
        List childIds = (List)this.getFieldValue("children");
        if (childIds == null || childIds.size() == 0) {
            return new Container[0];
        }
        ArrayList<ContainerFacade> answer = new ArrayList<ContainerFacade>();
        for (String childId : childIds) {
            answer.add(new ContainerFacade(this.fabricService, this.j4p, childId));
        }
        return answer.toArray(new Container[answer.size()]);
    }

    @Override
    public List<String> getJmxDomains() {
        return (List)this.getFieldValue("jmxDomains");
    }

    @Override
    public void setJmxDomains(List<String> jmxDomains) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isProvisioningComplete() {
        return (Boolean)this.getFieldValue("provisioningComplete");
    }

    @Override
    public boolean isProvisioningPending() {
        return (Boolean)this.getFieldValue("provisioningPending");
    }

    @Override
    public String getProvisionResult() {
        return (String)this.getFieldValue("provisionResult");
    }

    @Override
    public void setProvisionResult(String s) {
        throw new UnsupportedOperationException("This cannot be set from a remote process");
    }

    @Override
    public String getProvisionException() {
        return (String)this.getFieldValue("provisionException");
    }

    @Override
    public void setProvisionException(String s) {
        throw new UnsupportedOperationException("This cannot be set from a remote process");
    }

    @Override
    public List<String> getProvisionList() {
        return (List)this.getFieldValue("provisionList");
    }

    @Override
    public void setProvisionList(List<String> strings) {
        throw new UnsupportedOperationException("This cannot be set from a remote process");
    }

    @Override
    public Properties getProvisionChecksums() {
        throw new UnsupportedOperationException("This cannot be set from a remote process");
    }

    @Override
    public void setProvisionChecksums(Properties checksums) {
        throw new UnsupportedOperationException("This cannot be set from a remote process");
    }

    @Override
    public String getProvisionStatus() {
        return (String)this.getFieldValue("provisionStatus");
    }

    @Override
    public Map<String, String> getProvisionStatusMap() {
        return (Map)this.getFieldValue("provisionStatusMap");
    }

    @Override
    public CreateContainerMetadata<?> getMetadata() {
        throw new UnsupportedOperationException("This cannot be obtained from a remote process");
    }

    @Override
    public String getDebugPort() {
        return (String)this.getFieldValue("debugPort");
    }

    @Override
    public boolean isAliveAndOK() {
        return (Boolean)this.getFieldValue("aliveAndOK");
    }
}

