/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jolokia.facade.mbeans;

import com.fasterxml.jackson.databind.type.TypeFactory;
import io.fabric8.jolokia.facade.JolokiaFabricConnector;
import io.fabric8.jolokia.facade.dto.ContainerDTO;
import io.fabric8.jolokia.facade.dto.FabricDTO;
import io.fabric8.jolokia.facade.dto.FabricRequirementsDTO;
import io.fabric8.jolokia.facade.dto.FabricStatusDTO;
import io.fabric8.jolokia.facade.dto.ProfileDTO;
import io.fabric8.jolokia.facade.dto.VersionDTO;
import io.fabric8.jolokia.facade.mbeans.FabricMBean;
import io.fabric8.jolokia.facade.utils.Helpers;
import java.util.Collection;
import java.util.List;

public class FabricMBeanService {
    private JolokiaFabricConnector connector;
    private FabricMBean mbean;

    public FabricMBeanService(JolokiaFabricConnector connector, FabricMBean mbean) {
        this.connector = connector;
        this.mbean = mbean;
    }

    public FabricMBean getMbean() {
        return this.mbean;
    }

    public void dispose() {
        this.mbean = null;
    }

    public FabricDTO getFabricDetails() {
        try {
            return Helpers.getObjectMapper().readValue(this.mbean.getFabricFields(), FabricDTO.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public FabricRequirementsDTO getRequirements() {
        try {
            return Helpers.getObjectMapper().readValue(this.mbean.requirements(), FabricRequirementsDTO.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String setRequirements(FabricRequirementsDTO requirements) {
        try {
            return this.mbean.requirements(requirements);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Collection<VersionDTO> getVersions() {
        try {
            return (Collection)Helpers.getObjectMapper().readValue(this.mbean.versions(), TypeFactory.defaultInstance().constructParametricType(Collection.class, VersionDTO.class));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Collection<VersionDTO> getVersionsFields(List versionsFields) {
        if (versionsFields == null || versionsFields.size() < 1) {
            return this.getVersions();
        }
        try {
            return (Collection)Helpers.getObjectMapper().readValue(this.mbean.versions(versionsFields), TypeFactory.defaultInstance().constructParametricType(Collection.class, VersionDTO.class));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public FabricStatusDTO getFabricStatus() {
        try {
            return Helpers.getObjectMapper().readValue(this.mbean.fabricStatus(), FabricStatusDTO.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Collection<ContainerDTO> getContainers() {
        try {
            return (Collection)Helpers.getObjectMapper().readValue(this.mbean.containers(), TypeFactory.defaultInstance().constructParametricType(Collection.class, ContainerDTO.class));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Collection<ContainerDTO> getContainersFields(List containersFields) {
        if (containersFields == null || containersFields.size() < 1) {
            return this.getContainers();
        }
        try {
            return (Collection)Helpers.getObjectMapper().readValue(this.mbean.containers(containersFields), TypeFactory.defaultInstance().constructParametricType(Collection.class, ContainerDTO.class));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Collection<ProfileDTO> getProfiles(String version) {
        try {
            return (Collection)Helpers.getObjectMapper().readValue(this.mbean.getProfiles(version), TypeFactory.defaultInstance().constructParametricType(Collection.class, ProfileDTO.class));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Collection<ProfileDTO> getProfilesFields(String version, List profilesFields) {
        if (profilesFields == null || profilesFields.size() < 1) {
            return this.getProfiles(version);
        }
        try {
            return (Collection)Helpers.getObjectMapper().readValue(this.mbean.getProfiles(version, profilesFields), TypeFactory.defaultInstance().constructParametricType(Collection.class, ProfileDTO.class));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Collection<String> getProfileIds(String version) {
        try {
            return (Collection)Helpers.getObjectMapper().readValue(this.mbean.getProfileIds(version), TypeFactory.defaultInstance().constructParametricType(Collection.class, String.class));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

