/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.api.jmx;

import io.fabric8.api.jmx.BrokerKind;
import io.fabric8.api.scr.support.Strings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MQBrokerConfigDTO {
    private BrokerKind kind;
    private String brokerName;
    private String profile;
    private String parentProfile;
    private String clientProfile;
    private String clientParentProfile;
    private List<String> properties;
    private String configUrl;
    private String data;
    private Map<String, String> ports = new HashMap<String, String>();
    private String group;
    private String[] networks;
    private String networksUserName;
    private String networksPassword;
    private String version;
    private String jvmOpts;
    private Integer replicas;
    private Integer minimumInstances;
    private Boolean ssl;

    public String toString() {
        return "MQBrokerConfigDTO{group='" + this.group + '\'' + ", profile='" + this.profile() + '\'' + ", brokerName='" + this.brokerName + '\'' + ", kind='" + (Object)((Object)this.kind) + '\'' + '}';
    }

    public int requiredInstances() {
        if (this.replicas != null) {
            return this.replicas;
        }
        if (this.minimumInstances != null) {
            return this.minimumInstances;
        }
        if (this.kind != null) {
            switch (this.kind) {
                case StandAlone: {
                    return 1;
                }
                case Replicated: {
                    return 3;
                }
            }
        }
        return 2;
    }

    public String version() {
        String answer = this.getVersion();
        if (Strings.isNullOrBlank(answer)) {
            answer = "1.0";
        }
        return answer;
    }

    public String group() {
        String answer = this.getGroup();
        if (Strings.isNullOrBlank(answer)) {
            answer = "default";
        }
        return answer;
    }

    public BrokerKind kind() {
        BrokerKind answer = this.getKind();
        if (answer == null) {
            answer = BrokerKind.DEFAULT;
        }
        return answer;
    }

    public String profile() {
        if (Strings.isNullOrBlank(this.profile)) {
            this.profile = "mq-broker-" + this.group() + "." + this.getBrokerName();
        }
        return this.profile;
    }

    public String clientProfile() {
        if (Strings.isNullOrBlank(this.clientProfile)) {
            this.clientProfile = "mq-client-" + this.group();
        }
        return this.clientProfile;
    }

    public BrokerKind getKind() {
        return this.kind;
    }

    public void setKind(BrokerKind kind) {
        this.kind = kind;
    }

    public String getBrokerName() {
        return this.brokerName;
    }

    public void setBrokerName(String brokerName) {
        this.brokerName = brokerName;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public String getParentProfile() {
        return this.parentProfile;
    }

    public void setParentProfile(String parentProfile) {
        this.parentProfile = parentProfile;
    }

    public String getClientProfile() {
        return this.clientProfile;
    }

    public void setClientProfile(String clientProfile) {
        this.clientProfile = clientProfile;
    }

    public String getClientParentProfile() {
        return this.clientParentProfile;
    }

    public void setClientParentProfile(String clientParentProfile) {
        this.clientParentProfile = clientParentProfile;
    }

    public List<String> getProperties() {
        return this.properties;
    }

    public void setProperties(List<String> properties) {
        this.properties = properties;
    }

    public String getConfigUrl() {
        return this.configUrl;
    }

    public void setConfigUrl(String configUrl) {
        this.configUrl = configUrl;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String[] getNetworks() {
        return this.networks;
    }

    public void setNetworks(String[] networks) {
        this.networks = networks;
    }

    public String getNetworksUserName() {
        return this.networksUserName;
    }

    public void setNetworksUserName(String networksUserName) {
        this.networksUserName = networksUserName;
    }

    public String getNetworksPassword() {
        return this.networksPassword;
    }

    public void setNetworksPassword(String networksPassword) {
        this.networksPassword = networksPassword;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getJvmOpts() {
        return this.jvmOpts;
    }

    public void setJvmOpts(String jvmOpts) {
        this.jvmOpts = jvmOpts;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    public Integer getMinimumInstances() {
        return this.minimumInstances;
    }

    public void setMinimumInstances(Integer minimumInstances) {
        this.minimumInstances = minimumInstances;
    }

    public Map<String, String> getPorts() {
        return this.ports;
    }

    public void setPorts(Map<String, String> ports) {
        this.ports = ports;
    }

    public Boolean getSsl() {
        return this.ssl;
    }

    public void setSsl(Boolean ssl) {
        this.ssl = ssl;
    }
}

