/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jolokia.facade.facades;

import io.fabric8.api.AutoScaleStatus;
import io.fabric8.api.Container;
import io.fabric8.api.ContainerAutoScaler;
import io.fabric8.api.ContainerProvider;
import io.fabric8.api.CreateContainerBasicMetadata;
import io.fabric8.api.CreateContainerBasicOptions;
import io.fabric8.api.CreateContainerMetadata;
import io.fabric8.api.CreateContainerOptions;
import io.fabric8.api.CreationStateListener;
import io.fabric8.api.FabricRequirements;
import io.fabric8.api.FabricService;
import io.fabric8.api.FabricStatus;
import io.fabric8.api.PatchService;
import io.fabric8.api.PortService;
import io.fabric8.api.ProfileRequirements;
import io.fabric8.api.Version;
import io.fabric8.jolokia.facade.JolokiaFabricConnector;
import io.fabric8.jolokia.facade.facades.ContainerFacade;
import io.fabric8.jolokia.facade.facades.VersionFacade;
import io.fabric8.jolokia.facade.utils.Helpers;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jolokia.client.J4pClient;
import org.jolokia.client.request.J4pExecRequest;
import org.jolokia.client.request.J4pExecResponse;
import org.json.simple.JSONObject;

public class FabricServiceFacade
implements FabricService {
    private JolokiaFabricConnector connector;

    public FabricServiceFacade(JolokiaFabricConnector connector) {
        this.connector = connector;
    }

    @Override
    public <T> T adapt(Class<T> type) {
        return null;
    }

    @Override
    public void trackConfiguration(Runnable runnable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void untrackConfiguration(Runnable callback) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Container[] getContainers() {
        ArrayList<ContainerFacade> containers = new ArrayList<ContainerFacade>();
        try {
            J4pExecRequest request = Helpers.createExecRequest("containers(java.util.List)", Helpers.toList("id"));
            J4pExecResponse response = (J4pExecResponse)this.getJolokiaClient().execute(request);
            List values = (List)response.getValue();
            for (Map value : values) {
                containers.add(new ContainerFacade(this, this.getJolokiaClient(), (String)value.get("id")));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to fetch container list", e);
        }
        return containers.toArray(new Container[containers.size()]);
    }

    @Override
    public Container[] getAssociatedContainers(String versionId, String profileId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Container getContainer(String containerId) {
        return new ContainerFacade(this, this.getJolokiaClient(), containerId);
    }

    @Override
    public void startContainer(String containerId) {
        Helpers.doContainerAction(this.getJolokiaClient(), "start", containerId);
    }

    @Override
    public void startContainer(String containerId, boolean force) {
        this.startContainer(containerId);
    }

    @Override
    public void startContainer(Container container) {
        this.startContainer(container.getId());
    }

    @Override
    public void startContainer(Container container, boolean force) {
        this.startContainer(container.getId(), force);
    }

    @Override
    public void stopContainer(String containerId) {
        Helpers.doContainerAction(this.getJolokiaClient(), "stop", containerId);
    }

    @Override
    public void stopContainer(String containerId, boolean force) {
        this.stopContainer(containerId);
    }

    @Override
    public void stopContainer(Container container) {
        this.stopContainer(container.getId());
    }

    @Override
    public void stopContainer(Container container, boolean force) {
        this.stopContainer(container.getId());
    }

    @Override
    public void destroyContainer(String containerId) {
        Helpers.doContainerAction(this.getJolokiaClient(), "destroy", containerId);
    }

    @Override
    public void destroyContainer(String containerId, boolean force) {
        this.destroyContainer(containerId);
    }

    @Override
    public void destroyContainer(Container container) {
        this.destroyContainer(container.getId());
    }

    @Override
    public void destroyContainer(Container container, boolean force) {
        this.destroyContainer(container.getId());
    }

    @Override
    public CreateContainerMetadata[] createContainers(CreateContainerOptions createContainerOptions) {
        Map options = Helpers.getObjectMapper().convertValue((Object)createContainerOptions, Map.class);
        Helpers.exec(this.getJolokiaClient(), "createContainers(java.util.Map)", options);
        return new CreateContainerMetadata[0];
    }

    @Override
    public CreateContainerMetadata[] createContainers(CreateContainerOptions createContainerOptions, CreationStateListener listener) {
        return this.createContainers(createContainerOptions);
    }

    @Override
    public Set<Class<? extends CreateContainerBasicOptions>> getSupportedCreateContainerOptionTypes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Class<? extends CreateContainerBasicMetadata>> getSupportedCreateContainerMetadataTypes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDefaultVersionId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Version getRequiredDefaultVersion() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Version getDefaultVersion() {
        String id = (String)Helpers.read(this.getJolokiaClient(), "DefaultVersion");
        return new VersionFacade(this.getJolokiaClient(), id, "HEAD");
    }

    @Override
    public void setDefaultVersionId(String versionId) {
        Helpers.write(this.getJolokiaClient(), "DefaultVersion", versionId);
    }

    public Version getVersion(String versionKey) {
        return new VersionFacade(this.getJolokiaClient(), versionKey, "HEAD");
    }

    @Override
    public URI getMavenRepoURI() {
        String uri = (String)Helpers.read(this.getJolokiaClient(), "MavenRepoURI");
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<URI> getMavenRepoURIs() {
        throw new UnsupportedOperationException();
    }

    @Override
    public URI getMavenRepoUploadURI() {
        String uri = (String)Helpers.read(this.getJolokiaClient(), "MavenRepoUploadURI");
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getRestAPI() {
        return (String)Helpers.read(this.getJolokiaClient(), "RestAPI");
    }

    @Override
    public String getGitUrl() {
        return (String)Helpers.read(this.getJolokiaClient(), "GitUrl");
    }

    @Override
    public String getWebConsoleUrl() {
        return (String)Helpers.read(this.getJolokiaClient(), "WebConsoleUrl");
    }

    @Override
    public String getZookeeperUrl() {
        return (String)Helpers.read(this.getJolokiaClient(), "ZookeeperUrl");
    }

    @Override
    public String getZookeeperPassword() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Container getCurrentContainer() {
        JSONObject obj = (JSONObject)Helpers.exec(this.getJolokiaClient(), "currentContainer()", new Object[0]);
        return new ContainerFacade(this, this.getJolokiaClient(), (String)obj.get("id"));
    }

    @Override
    public String getCurrentContainerName() {
        return (String)Helpers.read(this.getJolokiaClient(), "CurrentContainerName");
    }

    @Override
    public String getEnvironment() {
        return (String)Helpers.read(this.getJolokiaClient(), "Environment");
    }

    @Override
    public FabricRequirements getRequirements() {
        JSONObject obj = (JSONObject)Helpers.exec(this.getJolokiaClient(), "requirements()", new Object[0]);
        FabricRequirements requirements = null;
        try {
            requirements = Helpers.getObjectMapper().readValue(obj.toJSONString(), FabricRequirements.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return requirements;
    }

    @Override
    public AutoScaleStatus getAutoScaleStatus() {
        JSONObject obj = (JSONObject)Helpers.exec(this.getJolokiaClient(), "autoScaleStatus()", new Object[0]);
        AutoScaleStatus answer = null;
        try {
            answer = Helpers.getObjectMapper().readValue(obj.toJSONString(), AutoScaleStatus.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return answer;
    }

    @Override
    public void setRequirements(FabricRequirements fabricRequirements) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public FabricStatus getFabricStatus() {
        JSONObject obj = (JSONObject)Helpers.exec(this.getJolokiaClient(), "fabricStatus()", new Object[0]);
        FabricStatus status = null;
        try {
            Map profStats = Helpers.getObjectMapper().readValue(obj.toJSONString(), Map.class);
            status = new FabricStatus();
            status.setProfileStatusMap(profStats);
            status.setService(this);
            status.init();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return status;
    }

    @Override
    public PatchService getPatchService() {
        throw new UnsupportedOperationException();
    }

    @Override
    public PortService getPortService() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDefaultJvmOptions() {
        return (String)Helpers.read(this.getJolokiaClient(), "DefaultJvmOptions");
    }

    @Override
    public void setDefaultJvmOptions(String s) {
        Helpers.write(this.getJolokiaClient(), "DefaultJvmOptions", s);
    }

    @Override
    public String containerWebAppURL(String s, String s2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String profileWebAppURL(String webAppId, String profileId, String versionId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getConfigurationValue(String versionId, String profileId, String pid, String key) {
        return (String)Helpers.exec(this.getJolokiaClient(), "getConfigurationValue(java.lang.String,java.lang.String,java.lang.String,java.lang.String)", versionId, profileId, pid, key);
    }

    @Override
    public void setConfigurationValue(String versionId, String profileId, String pid, String key, String value) {
        Helpers.exec(this.getJolokiaClient(), "setConfigurationValue(java.lang.String,java.lang.String,java.lang.String,java.lang.String,java.lang.String)", versionId, profileId, pid, key, value);
    }

    private J4pClient getJolokiaClient() {
        return this.connector.getJolokiaClient();
    }

    @Override
    public boolean scaleProfile(String profile, int numberOfInstances) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ContainerAutoScaler createContainerAutoScaler(FabricRequirements requirements, ProfileRequirements profileRequirements) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ContainerProvider getProvider(String scheme) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, ContainerProvider> getValidProviders() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, ContainerProvider> getProviders() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getZooKeeperUser() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, Map<String, String>> substituteConfigurations(Map<String, Map<String, String>> configurations) {
        throw new UnsupportedOperationException();
    }
}

