/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jolokia.facade.facades;

import io.fabric8.api.HasId;
import io.fabric8.api.Profile;
import io.fabric8.jolokia.facade.utils.Helpers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import org.jolokia.client.J4pClient;
import org.jolokia.client.exception.J4pException;
import org.jolokia.client.request.J4pExecRequest;
import org.jolokia.client.request.J4pExecResponse;

public class ProfileFacade
implements Profile,
HasId {
    J4pClient j4p;
    String id;
    String versionId;

    public ProfileFacade(J4pClient j4p, String versionId, String id) {
        this.j4p = j4p;
        this.versionId = versionId;
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getVersion() {
        return this.versionId;
    }

    public Profile createProfile(String versionId, String s) {
        Map profile = (Map)Helpers.exec(this.j4p, "createProfile(java.lang.String, java.lang.String)", this.id, s);
        if (profile == null) {
            return null;
        }
        return new ProfileFacade(this.j4p, this.id, s);
    }

    public void deleteVersion(String versionId) {
        Helpers.exec(this.j4p, "deleteVersion(java.lang.String)", versionId);
    }

    @Override
    public Map<String, String> getAttributes() {
        return (Map)this.getFieldValue("attributes");
    }

    @Override
    public List<String> getParentIds() {
        List<String> profiles = (List<String>)this.getFieldValue("parents");
        return profiles != null ? profiles : Collections.emptyList();
    }

    @Override
    public List<String> getLibraries() {
        return (List)this.getFieldValue("libraries");
    }

    @Override
    public List<String> getEndorsedLibraries() {
        return (List)this.getFieldValue("endorsedLibraries");
    }

    @Override
    public List<String> getExtensionLibraries() {
        return (List)this.getFieldValue("extensionLibraries");
    }

    @Override
    public List<String> getBundles() {
        return (List)this.getFieldValue("bundles");
    }

    @Override
    public List<String> getFabs() {
        return (List)this.getFieldValue("fabs");
    }

    @Override
    public List<String> getFeatures() {
        return (List)this.getFieldValue("features");
    }

    @Override
    public List<String> getRepositories() {
        return (List)this.getFieldValue("repositories");
    }

    @Override
    public List<String> getOverrides() {
        return (List)this.getFieldValue("overrides");
    }

    @Override
    public List<String> getOptionals() {
        return (List)this.getFieldValue("optionals");
    }

    @Override
    public List<String> getTags() {
        return (List)this.getFieldValue("tags");
    }

    @Override
    public Set<String> getConfigurationFileNames() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, byte[]> getFileConfigurations() {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getFileConfiguration(String fileName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, Map<String, String>> getConfigurations() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isOverlay() {
        return (Boolean)this.getFieldValue("overlay");
    }

    @Override
    public boolean isAbstract() {
        return (Boolean)this.getFieldValue("abstract");
    }

    @Override
    public boolean isLocked() {
        return (Boolean)this.getFieldValue("locked");
    }

    @Override
    public boolean isHidden() {
        return (Boolean)this.getFieldValue("hidden");
    }

    @Override
    public String getProfileHash() {
        return (String)this.getFieldValue("lastModified");
    }

    @Override
    public int compareTo(Profile profile) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, String> getConfiguration(String pid) {
        Map<String, Map<String, String>> configurations = this.getConfigurations();
        if (configurations != null) {
            return configurations.get(pid);
        }
        return null;
    }

    public Profile setOptionals(List<String> strings) {
        Helpers.exec(this.j4p, "setProfileOptionals(java.lang.String, java.lang.String, java.util.List)", this.versionId, this.id, strings);
        return null;
    }

    public Profile setParents(Profile[] profiles) {
        ArrayList<String> parentIds = new ArrayList<String>();
        for (Profile profile : profiles) {
            parentIds.add(profile.getId());
        }
        Helpers.exec(this.j4p, "changeProfileParents(java.lang.String, java.lang.String, java.util.List)", this.versionId, this.id, parentIds);
        return null;
    }

    public Profile setAttribute(String key, String value) {
        throw new UnsupportedOperationException();
    }

    public Profile setConfigurations(Map<String, Map<String, String>> stringMapMap) {
        throw new UnsupportedOperationException();
    }

    public Profile setFileConfigurations(Map<String, byte[]> stringMap) {
        throw new UnsupportedOperationException();
    }

    public void deleteProfile(String versionId, String profileId) {
        Helpers.exec(this.j4p, "deleteProfile(java.lang.String, java.lang.String)", versionId, profileId);
    }

    public Profile setBundles(List<String> strings) {
        Helpers.exec(this.j4p, "setProfileBundles(java.lang.String, java.lang.String, java.util.List)", this.versionId, this.id, strings);
        return null;
    }

    public Profile setFabs(List<String> strings) {
        Helpers.exec(this.j4p, "setProfileFabs(java.lang.String, java.lang.String, java.util.List)", this.versionId, this.id, strings);
        return null;
    }

    public Profile setFeatures(List<String> strings) {
        Helpers.exec(this.j4p, "setProfileFeatures(java.lang.String, java.lang.String, java.util.List)", this.versionId, this.id, strings);
        return null;
    }

    public Profile setRepositories(List<String> strings) {
        Helpers.exec(this.j4p, "setProfileRepositories(java.lang.String, java.lang.String, java.util.List)", this.versionId, this.id, strings);
        return null;
    }

    public Profile setOverrides(List<String> strings) {
        Helpers.exec(this.j4p, "setProfileOverrides(java.lang.String, java.lang.String, java.util.List)", this.versionId, this.id, strings);
        return null;
    }

    public Profile setConfiguration(String pid, Map<String, String> configuration) {
        Map<String, Map<String, String>> configurations = this.getConfigurations();
        if (configurations != null) {
            configurations.put(pid, configuration);
            this.setConfigurations(configurations);
        }
        return null;
    }

    public Profile setConfigurationFile(String fileName, byte[] data) {
        throw new UnsupportedOperationException();
    }

    private static <T> T getFieldValue(J4pClient j4p, String operation, String versionId, String id, String field) {
        T rc = null;
        try {
            J4pExecRequest request = Helpers.createExecRequest(operation, versionId, id, Helpers.toList(field));
            J4pExecResponse response = (J4pExecResponse)j4p.execute(request);
            Map value = (Map)response.getValue();
            rc = (T)value.get(field);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Failed to get container field", e);
        }
        catch (J4pException e) {
            throw new RuntimeException("Failed to get container field", e);
        }
        return rc;
    }

    private <T> T getFieldValue(String field) {
        return ProfileFacade.getFieldValue(this.j4p, "getProfile(java.lang.String, java.lang.String, java.util.List)", this.versionId, this.id, field);
    }

    @Override
    public String getIconURL() {
        return (String)this.getFieldValue("iconURL");
    }

    @Override
    public String getIconRelativePath() {
        return (String)this.getFieldValue("iconRelativePath");
    }

    @Override
    public String getSummaryMarkdown() {
        throw new UnsupportedOperationException();
    }
}

