/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.utils;

import io.fabric8.utils.Base64Encoder;

public class PasswordEncoder {
    public static final String PREFIX = "ZKENC=";

    private PasswordEncoder() {
    }

    public static String encode(String s) {
        return PasswordEncoder.shouldEncodePassword(s) ? PREFIX + Base64Encoder.encode(s) : s;
    }

    private static boolean shouldEncodePassword(String s) {
        if (Boolean.parseBoolean(System.getProperty("zookeeper.password.encode", "true"))) {
            return !s.startsWith(PREFIX);
        }
        return false;
    }

    public static String decode(String s) throws IllegalArgumentException {
        return PasswordEncoder.shouldDecodePassword(s) ? Base64Encoder.decode(s.substring(PREFIX.length())) : s;
    }

    private static boolean shouldDecodePassword(String s) {
        if (Boolean.parseBoolean(System.getProperty("zookeeper.password.encode", "true"))) {
            return s.startsWith(PREFIX);
        }
        return false;
    }
}

