/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.cxf.registry;

import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.api.Version;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.internal.JsonHelper;
import io.fabric8.utils.Strings;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.InvalidApplicationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.zookeeper.CreateMode;
import org.fusesource.common.util.PublicPortMapper;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(name="io.fabric8.cxf.registry", label="Fabric8 CXF Registration Handler", immediate=true, metatype=false)
public final class FabricCxfRegistrationHandler
extends AbstractComponent
implements ConnectionStateListener {
    public static final String CXF_API_ENDPOINT_MBEAN_NAME = "org.apache.cxf:*";
    private static final ObjectName CXF_OBJECT_NAME = FabricCxfRegistrationHandler.objectNameFor("org.apache.cxf:*");
    private static final Logger LOGGER = LoggerFactory.getLogger(FabricCxfRegistrationHandler.class);
    private static final Object[] EMPTY_PARAMS = new Object[0];
    private static final String[] EMPTY_SIGNATURE = new String[0];
    @Reference(referenceInterface=FabricService.class)
    private final ValidatingReference<FabricService> fabricService = new ValidatingReference();
    @Reference(referenceInterface=CuratorFramework.class)
    private final ValidatingReference<CuratorFramework> curator = new ValidatingReference();
    @Reference(referenceInterface=ConfigurationAdmin.class, cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    private ConfigurationAdmin configAdmin;
    private Set<String> registeredZkPaths = new ConcurrentSkipListSet<String>();
    private NotificationListener listener = new NotificationListener(){

        @Override
        public void handleNotification(Notification notification, Object handback) {
            if (notification instanceof MBeanServerNotification) {
                MBeanServerNotification mBeanServerNotification = (MBeanServerNotification)notification;
                ObjectName mBeanName = mBeanServerNotification.getMBeanName();
                String type = mBeanServerNotification.getType();
                FabricCxfRegistrationHandler.this.onMBeanEvent(FabricCxfRegistrationHandler.this.getCurrentContainer(), mBeanName, type);
            }
        }
    };
    private NotificationFilter filter = new NotificationFilter(){

        @Override
        public boolean isNotificationEnabled(Notification notification) {
            return notification instanceof MBeanServerNotification && CXF_OBJECT_NAME.apply(((MBeanServerNotification)notification).getMBeanName());
        }
    };
    private QueryExp isCxfServiceEndpointQuery = new QueryExp(){

        @Override
        public boolean apply(ObjectName name) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
            String type = name.getKeyProperty("type");
            return type != null && "Bus.Service.Endpoint".equals(type);
        }

        @Override
        public void setMBeanServer(MBeanServer s) {
        }
    };
    private MBeanServer mBeanServer;
    private boolean registeredListener;

    @Activate
    void activate() throws Exception {
        this.activateComponent();
        if (this.mBeanServer == null) {
            this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        if (this.mBeanServer != null) {
            Object handback = null;
            this.mBeanServer.addNotificationListener(MBeanServerDelegate.DELEGATE_NAME, this.listener, this.filter, handback);
            this.registeredListener = true;
        }
        this.replay();
    }

    @Deactivate
    void deactivate() throws Exception {
        if (this.registeredListener && this.mBeanServer != null) {
            this.mBeanServer.removeNotificationListener(MBeanServerDelegate.DELEGATE_NAME, this.listener);
        }
        ArrayList<String> paths = new ArrayList<String>(this.registeredZkPaths);
        for (String path : paths) {
            this.removeZkPath(path);
        }
        this.deactivateComponent();
    }

    public void stateChanged(CuratorFramework client, ConnectionState newState) {
        if (this.isValid()) {
            switch (newState) {
                case CONNECTED: 
                case RECONNECTED: {
                    this.replay();
                }
            }
        }
    }

    protected void replay() {
        if (this.mBeanServer != null) {
            Container container = this.getCurrentContainer();
            ObjectName objectName = FabricCxfRegistrationHandler.createObjectName(CXF_API_ENDPOINT_MBEAN_NAME);
            if (objectName != null && container != null) {
                Set<ObjectInstance> instances = this.mBeanServer.queryMBeans(objectName, this.isCxfServiceEndpointQuery);
                for (ObjectInstance instance : instances) {
                    ObjectName oName = instance.getObjectName();
                    String type = null;
                    this.onMBeanEvent(container, oName, type);
                }
            }
            if (container == null) {
                LOGGER.warn("No container available!");
            }
        }
    }

    protected Container getCurrentContainer() {
        return ((FabricService)this.fabricService.get()).getCurrentContainer();
    }

    protected void onMBeanEvent(Container container, ObjectName oName, String type) {
        block9: {
            try {
                boolean created;
                if (!this.isCxfServiceEndpointQuery.apply(oName)) break block9;
                Object state = this.mBeanServer.getAttribute(oName, "State");
                String address = null;
                try {
                    Object addressValue = this.mBeanServer.getAttribute(oName, "Address");
                    if (addressValue instanceof String) {
                        address = addressValue.toString();
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to get address for endpoint " + oName + " type " + type + " has status " + state + ". " + e, (Throwable)e);
                }
                boolean started = state instanceof String && state.toString().toUpperCase().startsWith("START");
                boolean bl = created = state instanceof String && state.toString().toUpperCase().startsWith("CREATE");
                if (address != null && (started || created)) {
                    LOGGER.info("Registering endpoint " + oName + " type " + type + " has status " + state + "at " + address);
                    this.registerApiEndpoint(container, oName, address, started);
                } else {
                    if (address == null) {
                        LOGGER.warn("Endpoint " + oName + " type " + type + " has status " + state + "but no address");
                    } else {
                        LOGGER.info("Unregistering endpoint " + oName + " type " + type + " has status " + state + "at " + address);
                    }
                    this.unregisterApiEndpoint(container, oName);
                }
            }
            catch (Exception e) {
                LOGGER.warn("Failed to process " + oName + ". " + e, (Throwable)e);
            }
        }
    }

    public static ObjectName createObjectName(String name) {
        ObjectName objectName = null;
        try {
            objectName = new ObjectName(name);
        }
        catch (MalformedObjectNameException e) {
            LOGGER.error("Failed to create ObjectName for " + name + ". " + e, (Throwable)e);
        }
        return objectName;
    }

    protected void registerApiEndpoint(Container container, ObjectName oName, String address, boolean started) {
        String actualEndpointUrl = null;
        try {
            String url;
            String id = container.getId();
            if (this.isFullAddress(address)) {
                url = this.toPublicAddress(id, address);
            } else {
                String cxfBus = this.getCxfServletPath(oName);
                url = "${zk:" + id + "/http}" + cxfBus + address;
            }
            actualEndpointUrl = ZooKeeperUtils.getSubstitutedData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)url);
            String apiDocPath = "/api-docs";
            String wsdlPath = "?wsdl";
            String wadlPath = "?_wadl";
            Version version = container.getVersion();
            String versionId = version != null ? version.getId() : null;
            String json = "{\"id\":" + JsonHelper.jsonEncodeString((String)id) + ", \"container\":" + JsonHelper.jsonEncodeString((String)id) + ", \"version\":" + JsonHelper.jsonEncodeString((String)versionId) + ", \"services\":[" + JsonHelper.jsonEncodeString((String)url) + "]" + ", \"objectName\":" + JsonHelper.jsonEncodeString((String)oName.toString()) + "";
            boolean rest = false;
            if (this.booleanAttribute(oName, "isWADL")) {
                rest = true;
                json = json + ", \"wadl\":" + JsonHelper.jsonEncodeString((String)wadlPath);
            }
            if (this.booleanAttribute(oName, "isSwagger")) {
                rest = true;
                json = json + ", \"apidocs\":" + JsonHelper.jsonEncodeString((String)apiDocPath);
            }
            if (this.booleanAttribute(oName, "isWSDL")) {
                json = json + ", \"wsdl\":" + JsonHelper.jsonEncodeString((String)wsdlPath);
            }
            json = json + "}";
            String path = this.getPath(container, oName, address, rest);
            LOGGER.info("Registered CXF API at " + path + " JSON: " + json);
            if (!started && !rest) {
                LOGGER.warn("Since the CXF service isn't started, this could really be a REST endpoint rather than WSDL at " + path);
            }
            this.registeredZkPaths.add(path);
            ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)path, (String)json, (CreateMode)CreateMode.EPHEMERAL);
        }
        catch (Exception e) {
            LOGGER.error("Failed to register API endpoint for {}.", actualEndpointUrl, (Object)e);
        }
    }

    private String toPublicAddress(String container, String address) {
        try {
            URI uri = new URI(address);
            int port = PublicPortMapper.getPublicPort((int)uri.getPort());
            String hostname = "${zk:" + container + "/ip}";
            String path = uri.getPath();
            while (path.startsWith("/")) {
                path = path.substring(1);
            }
            return uri.getScheme() + "://" + hostname + ":" + port + "/" + path;
        }
        catch (URISyntaxException e) {
            LOGGER.warn("Could not map URL to a public address: " + address);
            return address;
        }
    }

    protected boolean booleanAttribute(ObjectName oName, String name) {
        try {
            Object value = this.mBeanServer.invoke(oName, name, EMPTY_PARAMS, EMPTY_SIGNATURE);
            if (value != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Name " + oName + " has " + name + " value: " + value);
                }
                if (value instanceof Boolean) {
                    Boolean b = (Boolean)value;
                    return b;
                }
                LOGGER.warn("Got value " + value + " of type " + value.getClass() + " for " + name + " on " + oName);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Name " + oName + " could not find attribute " + name + ". " + e, (Throwable)e);
        }
        return false;
    }

    protected void unregisterApiEndpoint(Container container, ObjectName oName) {
        String address = "";
        String path = null;
        try {
            path = this.getPath(container, oName, address, true);
            this.removeZkPath(path);
            path = this.getPath(container, oName, address, false);
            this.removeZkPath(path);
        }
        catch (Exception e) {
            LOGGER.error("Failed to unregister API endpoint at {}.", (Object)path, (Object)e);
        }
    }

    protected void removeZkPath(String path) throws Exception {
        CuratorFramework curator = (CuratorFramework)this.curator.get();
        if (curator != null && ZooKeeperUtils.exists((CuratorFramework)curator, (String)path) != null) {
            LOGGER.info("Unregister API at " + path);
            ZooKeeperUtils.deleteSafe((CuratorFramework)curator, (String)path);
        }
        this.registeredZkPaths.remove(path);
    }

    protected String getCxfServletPath(ObjectName oName) throws IOException, URISyntaxException {
        String cxfBus = null;
        try {
            Object value = this.mBeanServer.getAttribute(oName, "ServletContext");
            if (value instanceof String) {
                cxfBus = (String)value;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to get CxfServlet attribute on " + oName + ". " + e, (Throwable)e);
        }
        if (Strings.isNullOrBlank(cxfBus)) {
            try {
                Object value;
                Dictionary properties;
                Configuration configuration;
                ConfigurationAdmin admin = this.getConfigAdmin();
                if (admin != null && (configuration = admin.getConfiguration("org.apache.cxf.osgi")) != null && (properties = configuration.getProperties()) != null && (value = properties.get("org.apache.cxf.servlet.context")) != null) {
                    cxfBus = value.toString();
                }
            }
            catch (Exception e) {
                LOGGER.warn("Failed to lookup the cxf servlet path. " + e, (Throwable)e);
            }
        }
        if (Strings.isNullOrBlank(cxfBus)) {
            cxfBus = "/cxf";
            LOGGER.warn("Could not find the CXF servlet path in config admin so using a default value: " + cxfBus);
        } else {
            LOGGER.info("Found CXF servlet path from config admin: " + cxfBus);
        }
        return cxfBus;
    }

    protected boolean isFullAddress(String address) {
        return address.startsWith("http:") || address.startsWith("https:") || address.contains("://");
    }

    protected String getPath(Container container, ObjectName oName, String address, boolean restApi) {
        int idx;
        String containerId = container.getId();
        String name = oName.getKeyProperty("port");
        if (Strings.isNullOrBlank(name)) {
            name = "Unknown";
        }
        if (name.startsWith("\"") && name.endsWith("\"")) {
            name = name.substring(1, name.length() - 1);
        }
        String version = container.getVersion().toString();
        String endpointPath = address;
        if (this.isFullAddress(address) && (idx = address.indexOf(":")) > 0) {
            int nextIdx;
            int length = address.length();
            while (++idx < length && address.charAt(idx) == '/') {
            }
            if ((idx = address.indexOf(47, idx)) > 0 && (nextIdx = address.indexOf(47, idx + 1)) > 0) {
                idx = nextIdx;
            }
            endpointPath = address.substring(idx);
        }
        String fullName = name;
        if (Strings.isNotBlank(endpointPath)) {
            String prefix = endpointPath.startsWith("/") ? "" : "/";
            fullName = fullName + prefix + endpointPath;
        }
        if (restApi) {
            return ZkPath.API_REST_ENDPOINTS.getPath(new String[]{fullName, version, containerId});
        }
        return ZkPath.API_WS_ENDPOINTS.getPath(new String[]{fullName, version, containerId});
    }

    private static ObjectName objectNameFor(String name) {
        try {
            return new ObjectName(name);
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
    }

    void bindFabricService(FabricService fabricService) {
        this.fabricService.bind((Object)fabricService);
    }

    void unbindFabricService(FabricService fabricService) {
        this.fabricService.unbind((Object)fabricService);
    }

    void bindCurator(CuratorFramework curator) {
        this.curator.bind((Object)curator);
    }

    void unbindCurator(CuratorFramework curator) {
        this.curator.unbind((Object)curator);
    }

    ConfigurationAdmin getConfigAdmin() {
        return this.configAdmin;
    }

    protected void bindConfigAdmin(ConfigurationAdmin configurationAdmin) {
        this.configAdmin = configurationAdmin;
    }

    protected void unbindConfigAdmin(ConfigurationAdmin configurationAdmin) {
        if (this.configAdmin == configurationAdmin) {
            this.configAdmin = null;
        }
    }
}

