/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.cxf.endpoint;

import io.fabric8.cxf.endpoint.ManagedApi;
import io.fabric8.cxf.endpoint.ManagedApiFeature;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMException;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointImpl;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerLifeCycleListener;
import org.apache.cxf.endpoint.ServerLifeCycleManager;
import org.apache.cxf.endpoint.ServerRegistry;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.management.InstrumentationManager;
import org.apache.cxf.management.ManagedComponent;
import org.apache.cxf.management.jmx.InstrumentationManagerImpl;

public class EnableJMXFeature
extends AbstractFeature {
    private static final Logger LOG = LogUtils.getL7dLogger(ManagedApiFeature.class);

    public void initialize(Server server, Bus bus) {
        ManagedApi mApi = new ManagedApi(bus, server.getEndpoint(), server);
        InstrumentationManager iMgr = (InstrumentationManager)bus.getExtension(InstrumentationManager.class);
        if (iMgr == null) {
            iMgr = new InstrumentationManagerImpl(bus);
        }
        ((InstrumentationManagerImpl)iMgr).setUsePlatformMBeanServer(Boolean.valueOf(true));
        ((InstrumentationManagerImpl)iMgr).setCreateMBServerConnectorFactory(false);
        ((InstrumentationManagerImpl)iMgr).setEnabled(true);
        ((InstrumentationManagerImpl)iMgr).init();
        if (iMgr != null) {
            try {
                iMgr.register((ManagedComponent)mApi);
                ServerLifeCycleManager slcMgr = (ServerLifeCycleManager)bus.getExtension(ServerLifeCycleManager.class);
                if (slcMgr != null) {
                    slcMgr.registerListener((ServerLifeCycleListener)mApi);
                    slcMgr.startServer(server);
                }
            }
            catch (JMException jmex) {
                jmex.printStackTrace();
                LOG.log(Level.WARNING, "Registering ManagedApi failed.", jmex);
            }
        }
    }

    public void initialize(Bus bus) {
        ArrayList servers = new ArrayList();
        ServerRegistry serverRegistry = (ServerRegistry)bus.getExtension(ServerRegistry.class);
        servers.addAll(serverRegistry.getServers());
        for (Server server : servers) {
            ManagedApi mApi = new ManagedApi(bus, server.getEndpoint(), server);
            InstrumentationManager iMgr = (InstrumentationManager)bus.getExtension(InstrumentationManager.class);
            if (iMgr == null) {
                iMgr = new InstrumentationManagerImpl(bus);
            }
            ((InstrumentationManagerImpl)iMgr).setUsePlatformMBeanServer(Boolean.valueOf(true));
            ((InstrumentationManagerImpl)iMgr).setCreateMBServerConnectorFactory(false);
            ((InstrumentationManagerImpl)iMgr).setEnabled(true);
            ((InstrumentationManagerImpl)iMgr).init();
            if (iMgr == null) continue;
            try {
                iMgr.register((ManagedComponent)mApi);
            }
            catch (JMException jmex) {
                jmex.printStackTrace();
                LOG.log(Level.WARNING, "Registering ManagedApi failed.", jmex);
            }
        }
    }

    protected void initializeProvider(InterceptorProvider provider, Bus bus) {
        if (provider instanceof Endpoint) {
            EndpointImpl endpointImpl = (EndpointImpl)provider;
            ArrayList<EnableJMXFeature> features = endpointImpl.getActiveFeatures();
            if (features == null) {
                features = new ArrayList<EnableJMXFeature>();
                features.add(this);
                endpointImpl.initializeActiveFeatures(features);
            } else {
                features.add(this);
            }
        } else {
            ArrayList<EnableJMXFeature> features = (ArrayList<EnableJMXFeature>)bus.getFeatures();
            if (features == null) {
                features = new ArrayList<EnableJMXFeature>();
                features.add(this);
            } else {
                features.add(this);
            }
        }
    }
}

