/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.cxf.endpoint;

import io.fabric8.cxf.endpoint.ManagedApi;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMException;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointImpl;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerLifeCycleListener;
import org.apache.cxf.endpoint.ServerLifeCycleManager;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.management.InstrumentationManager;
import org.apache.cxf.management.ManagedComponent;
import org.apache.cxf.service.factory.AbstractServiceFactoryBean;
import org.apache.cxf.service.factory.FactoryBeanListener;
import org.apache.cxf.service.factory.FactoryBeanListenerManager;

public class ManagedApiFeature
extends AbstractFeature {
    private static final Logger LOG = LogUtils.getL7dLogger(ManagedApiFeature.class);

    public void initialize(Server server, Bus bus) {
        ManagedApi mApi = new ManagedApi(bus, server.getEndpoint(), server);
        InstrumentationManager iMgr = (InstrumentationManager)bus.getExtension(InstrumentationManager.class);
        if (iMgr != null) {
            try {
                iMgr.register((ManagedComponent)mApi);
                ServerLifeCycleManager slcMgr = (ServerLifeCycleManager)bus.getExtension(ServerLifeCycleManager.class);
                if (slcMgr != null) {
                    slcMgr.registerListener((ServerLifeCycleListener)mApi);
                    slcMgr.startServer(server);
                }
            }
            catch (JMException jmex) {
                jmex.printStackTrace();
                LOG.log(Level.WARNING, "Registering ManagedApi failed.", jmex);
            }
        }
    }

    public void initialize(final Bus bus) {
        FactoryBeanListenerManager factoryBeanListenerManager = (FactoryBeanListenerManager)bus.getExtension(FactoryBeanListenerManager.class);
        if (factoryBeanListenerManager == null) {
            factoryBeanListenerManager = new FactoryBeanListenerManager(bus);
        }
        factoryBeanListenerManager.addListener(new FactoryBeanListener(){

            public void handleEvent(FactoryBeanListener.Event arg0, AbstractServiceFactoryBean arg1, Object ... arg2) {
                if (arg0.equals((Object)FactoryBeanListener.Event.SERVER_CREATED) && arg2[0] instanceof Server) {
                    Server server = (Server)arg2[0];
                    ManagedApiFeature.this.initialize(server, bus);
                }
            }
        });
    }

    protected void initializeProvider(InterceptorProvider provider, final Bus bus) {
        if (provider instanceof Endpoint) {
            EndpointImpl endpointImpl = (EndpointImpl)provider;
            ArrayList<ManagedApiFeature> features = endpointImpl.getActiveFeatures();
            if (features == null) {
                features = new ArrayList<ManagedApiFeature>();
                features.add(this);
                endpointImpl.initializeActiveFeatures(features);
            } else {
                features.add(this);
            }
        } else if (provider instanceof Bus) {
            FactoryBeanListenerManager factoryBeanListenerManager = (FactoryBeanListenerManager)bus.getExtension(FactoryBeanListenerManager.class);
            if (factoryBeanListenerManager == null) {
                factoryBeanListenerManager = new FactoryBeanListenerManager(bus);
            }
            factoryBeanListenerManager.addListener(new FactoryBeanListener(){

                public void handleEvent(FactoryBeanListener.Event arg0, AbstractServiceFactoryBean arg1, Object ... arg2) {
                    if (arg0.equals((Object)FactoryBeanListener.Event.SERVER_CREATED) && arg2[0] instanceof Server) {
                        Server server = (Server)arg2[0];
                        ManagedApiFeature.this.initialize(server, bus);
                    }
                }
            });
        } else {
            ArrayList<ManagedApiFeature> features = (ArrayList<ManagedApiFeature>)bus.getFeatures();
            if (features == null) {
                features = new ArrayList<ManagedApiFeature>();
                features.add(this);
            } else {
                features.add(this);
            }
        }
    }
}

