/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.cxf;

import io.fabric8.cxf.CxfNodeState;
import io.fabric8.cxf.LoadBalanceStrategy;
import io.fabric8.groups.Group;
import io.fabric8.groups.GroupListener;
import io.fabric8.groups.internal.ZooKeeperGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class FabricLoadBalanceStrategySupport
implements LoadBalanceStrategy {
    private static final transient Log LOG = LogFactory.getLog(FabricLoadBalanceStrategySupport.class);
    protected Group<CxfNodeState> group;
    protected List<String> alternateAddressList = new CopyOnWriteArrayList<String>();

    @Override
    public void setGroup(Group<CxfNodeState> group) throws Exception {
        this.group = group;
        group.add((GroupListener)new GroupListener<CxfNodeState>(){

            public void groupEvent(Group<CxfNodeState> group, GroupListener.GroupEvent event) {
                FabricLoadBalanceStrategySupport.this.onUpdate(group);
            }
        });
        if (group instanceof ZooKeeperGroup) {
            ((ZooKeeperGroup)group).clearAndRefresh(true, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onUpdate(Group<CxfNodeState> group) {
        List<String> list = this.alternateAddressList;
        synchronized (list) {
            this.alternateAddressList.clear();
            for (CxfNodeState node : group.members().values()) {
                if (node.services == null) continue;
                for (String url : node.services) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Added the CXF endpoint address " + url));
                    }
                    this.alternateAddressList.add(url);
                }
            }
        }
    }

    @Override
    public Group<CxfNodeState> getGroup() {
        return this.group;
    }

    @Override
    public List<String> getAlternateAddressList() {
        return new ArrayList<String>(this.alternateAddressList);
    }
}

