/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.cxf;

import io.fabric8.common.util.PublicPortMapper;
import io.fabric8.cxf.CxfNodeState;
import io.fabric8.cxf.ServerAddressResolver;
import io.fabric8.cxf.env.CxfContextResolver;
import io.fabric8.groups.Group;
import io.fabric8.groups.NodeState;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.curator.framework.CuratorFramework;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerLifeCycleListener;

public class FabricServerListener
implements ServerLifeCycleListener {
    private static final transient Log LOG = LogFactory.getLog(FabricServerListener.class);
    private final Group<CxfNodeState> group;
    private final CxfContextResolver cxfContextResolver;
    private ServerAddressResolver addressResolver;
    private final CuratorFramework curator;
    private final List<String> services = new ArrayList<String>();

    public FabricServerListener(Group<CxfNodeState> group, ServerAddressResolver addressResolver, CuratorFramework curator) {
        this.group = group;
        this.addressResolver = addressResolver;
        this.curator = curator;
        this.cxfContextResolver = new CxfContextResolver();
    }

    public FabricServerListener(Group<CxfNodeState> group) {
        this(group, null, null);
    }

    public void startServer(Server server) {
        String address = this.getFullAddress(server.getEndpoint().getEndpointInfo().getAddress());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("The CXF server is start with address " + address));
        }
        boolean exists = false;
        for (String uri : this.services) {
            if (uri.compareTo(address) != 0) continue;
            exists = true;
            break;
        }
        if (!exists) {
            this.services.add(address);
        }
        this.group.update((NodeState)this.createState());
    }

    public void stopServer(Server server) {
        String address = this.getFullAddress(server.getEndpoint().getEndpointInfo().getAddress());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("The CXF server is stopped with address " + address));
        }
        this.services.remove(address);
        this.group.update((NodeState)this.createState());
    }

    private CxfNodeState createState() {
        CxfNodeState state = new CxfNodeState("cxf");
        state.services = this.services.toArray(new String[this.services.size()]);
        return state;
    }

    public String getFullAddress(String address) {
        String answer = this.addressResolver != null ? this.addressResolver.getFullAddress(address) : address;
        if (!this.isFullAddress(answer)) {
            answer = this.getAddressPrefix() + answer;
        }
        if (this.isFullAddress(answer)) {
            answer = this.toPublicAddress(answer);
        }
        return answer;
    }

    private String getAddressPrefix() {
        String containerId = System.getProperty("karaf.name");
        if (containerId == null || containerId.trim().equals("")) {
            return "";
        }
        if (this.curator != null) {
            try {
                String httpUrl = "${zk:" + containerId + "/http}";
                String cxfPrefix = this.cxfContextResolver.getCxfServletContext();
                this.curator.getZookeeperClient().blockUntilConnectedOrTimedOut();
                httpUrl = ZooKeeperUtils.getSubstitutedData((CuratorFramework)this.curator, (String)httpUrl);
                return httpUrl + cxfPrefix;
            }
            catch (Exception e) {
                LOG.warn((Object)e.getMessage(), (Throwable)e);
                return "";
            }
        }
        return "";
    }

    protected boolean isFullAddress(String address) {
        return address.startsWith("http:") || address.startsWith("https:") || address.contains("://");
    }

    private String toPublicAddress(String address) {
        try {
            String containerId = System.getProperty("karaf.name");
            if (containerId == null || containerId.trim().equals("")) {
                return address;
            }
            URI uri = new URI(address);
            int port = PublicPortMapper.getPublicPort((int)uri.getPort());
            String path = uri.getPath();
            while (path.startsWith("/")) {
                path = path.substring(1);
            }
            String answer = uri.getScheme() + "://" + uri.getHost() + ":" + port + "/" + path;
            try {
                String openshiftFuseIpAddress = System.getenv("OPENSHIFT_FUSE_IP");
                if ((openshiftFuseIpAddress == null || openshiftFuseIpAddress.trim().equals("")) && InetAddress.getByName(uri.getHost()).isLoopbackAddress()) {
                    return answer;
                }
            }
            catch (UnknownHostException e) {
                LOG.warn((Object)e.getMessage());
            }
            if (this.curator != null) {
                String hostname = "${zk:" + containerId + "/ip}";
                answer = uri.getScheme() + "://" + hostname + ":" + port + "/" + path;
                this.curator.getZookeeperClient().blockUntilConnectedOrTimedOut();
                answer = ZooKeeperUtils.getSubstitutedData((CuratorFramework)this.curator, (String)answer);
            }
            return answer;
        }
        catch (InterruptedException e) {
            LOG.warn((Object)"Could not connect to Zookeeper to get public container address");
            return address;
        }
        catch (URISyntaxException e) {
            LOG.warn((Object)("Could not map URL to a public address: " + address));
            return address;
        }
    }
}

