/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import org.apache.felix.utils.version.VersionRange;
import org.apache.felix.utils.version.VersionTable;
import org.apache.karaf.features.BundleInfo;
import org.apache.karaf.features.Conditional;
import org.apache.karaf.features.ConfigFileInfo;
import org.apache.karaf.features.ConfigInfo;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeatureEvent;
import org.apache.karaf.features.FeaturesListener;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.Repository;
import org.apache.karaf.features.RepositoryEvent;
import org.apache.karaf.features.Resolver;
import org.apache.karaf.features.internal.EventAdminListener;
import org.apache.karaf.features.internal.FeatureImpl;
import org.apache.karaf.features.internal.FeatureValidationUtil;
import org.apache.karaf.features.internal.Overrides;
import org.apache.karaf.features.internal.RepositoryImpl;
import org.apache.karaf.util.collections.CopyOnWriteArrayIdentityList;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeaturesServiceImpl
implements FeaturesService {
    public static final String CONFIG_KEY = "org.apache.karaf.features.configKey";
    private static final Logger LOGGER = LoggerFactory.getLogger(FeaturesServiceImpl.class);
    private static final int KARAF_BUNDLE_START_LEVEL = Integer.parseInt(System.getProperty("karaf.startlevel.bundle", "80"));
    private BundleContext bundleContext;
    private ConfigurationAdmin configAdmin;
    private boolean respectStartLvlDuringFeatureStartup;
    private long resolverTimeout = 5000L;
    private Set<URI> uris = new HashSet<URI>();
    private Map<URI, Repository> repositories = new ConcurrentHashMap<URI, Repository>();
    private Map<String, Map<String, Feature>> features;
    private Map<Feature, Set<Long>> installed = new HashMap<Feature, Set<Long>>();
    private String boot;
    private boolean bootFeaturesAsynchronous;
    private boolean bootFeaturesInstalled;
    private List<FeaturesListener> listeners = new CopyOnWriteArrayIdentityList<FeaturesListener>();
    private ThreadLocal<Repository> repo = new ThreadLocal();
    private EventAdminListener eventAdminListener;
    private String blackList;
    private String overrides;
    static Pattern fuzzyVersion = Pattern.compile("(\\d+)(\\.(\\d+)(\\.(\\d+))?)?([^a-zA-Z0-9](.*))?", 32);
    static Pattern fuzzyModifier = Pattern.compile("(\\d+[.-])*(.*)", 32);

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        HashSet<Long> startupBundleSet = new HashSet<Long>();
        if (bundleContext != null && bundleContext.getBundles() != null && this.installed.size() == 0) {
            for (Bundle startupBundle : bundleContext.getBundles()) {
                startupBundleSet.add(startupBundle.getBundleId());
            }
            this.installed.put(new FeatureImpl("startup"), startupBundleSet);
        }
    }

    public ConfigurationAdmin getConfigAdmin() {
        return this.configAdmin;
    }

    public void setConfigAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }

    public void setRespectStartLvlDuringFeatureStartup(boolean respectStartLvlDuringFeatureStartup) {
        this.respectStartLvlDuringFeatureStartup = respectStartLvlDuringFeatureStartup;
    }

    public long getResolverTimeout() {
        return this.resolverTimeout;
    }

    public void setResolverTimeout(long resolverTimeout) {
        this.resolverTimeout = resolverTimeout;
    }

    public String getOverrides() {
        return this.overrides;
    }

    public void setOverrides(String overrides) {
        this.overrides = overrides;
    }

    public void registerListener(FeaturesListener listener) {
        this.listeners.add(listener);
        for (Repository repository : this.listRepositories()) {
            listener.repositoryEvent(new RepositoryEvent(repository, RepositoryEvent.EventType.RepositoryAdded, true));
        }
        for (Feature feature : this.listInstalledFeatures()) {
            listener.featureEvent(new FeatureEvent(feature, FeatureEvent.EventType.FeatureInstalled, true));
        }
    }

    public void unregisterListener(FeaturesListener listener) {
        this.listeners.remove(listener);
    }

    public void setUrls(String uris) throws URISyntaxException {
        String[] s;
        for (String value : s = uris.split(",")) {
            if ((value = value.trim()).isEmpty()) continue;
            this.uris.add(new URI(value));
        }
    }

    public void setBoot(String boot) {
        this.boot = boot;
    }

    public void setBootFeaturesAsynchronous(boolean bootFeaturesAsynchronous) {
        this.bootFeaturesAsynchronous = bootFeaturesAsynchronous;
    }

    public void setBlackList(String blackList) {
        this.blackList = blackList;
    }

    @Override
    public void validateRepository(URI uri) throws Exception {
        FeatureValidationUtil.validate(uri);
    }

    @Override
    public void addRepository(URI uri) throws Exception {
        this.addRepository(uri, false);
    }

    @Override
    public void addRepository(URI uri, boolean install) throws Exception {
        if (!this.repositories.containsKey(uri)) {
            RepositoryImpl repository = this.internalAddRepository(uri);
            this.saveState();
            if (install) {
                for (Feature feature : repository.getFeatures()) {
                    this.installFeature(feature, EnumSet.noneOf(FeaturesService.Option.class));
                }
            }
        } else {
            this.refreshRepository(uri, install);
        }
    }

    protected RepositoryImpl internalAddRepository(URI uri) throws Exception {
        this.validateRepository(uri);
        RepositoryImpl repo = null;
        repo = new RepositoryImpl(uri, this.blackList);
        this.repositories.put(uri, repo);
        this.uris.add(uri);
        repo.load();
        if (repo.getName() == null) {
            LOGGER.warn("Feature repository doesn't have a name. The name will be mandatory in the next Karaf version.");
        }
        this.callListeners(new RepositoryEvent(repo, RepositoryEvent.EventType.RepositoryAdded, false));
        this.features = null;
        return repo;
    }

    protected void refreshRepository(URI uri) throws Exception {
        this.refreshRepository(uri, false);
    }

    protected void refreshRepository(URI uri, boolean install) throws Exception {
        try {
            this.removeRepository(uri, install);
            this.addRepository(uri, install);
        }
        catch (Exception e) {
            this.restoreRepository(uri);
            throw new Exception("Unable to refresh features repository " + uri, e);
        }
    }

    @Override
    public void removeRepository(URI uri) throws Exception {
        this.removeRepository(uri, false);
    }

    @Override
    public void removeRepository(URI uri, boolean uninstall) throws Exception {
        if (this.repositories.containsKey(uri)) {
            if (uninstall) {
                Repository repository = this.repositories.get(uri);
                for (Feature feature : repository.getFeatures()) {
                    this.uninstallFeature(feature.getName(), feature.getVersion());
                }
            }
            this.internalRemoveRepository(uri);
            this.saveState();
        }
    }

    public void internalRemoveRepository(URI uri) {
        Repository repo = this.repositories.remove(uri);
        this.repo.set(repo);
        this.callListeners(new RepositoryEvent(repo, RepositoryEvent.EventType.RepositoryRemoved, false));
        this.features = null;
    }

    @Override
    public void restoreRepository(URI uri) throws Exception {
        this.repositories.put(uri, (RepositoryImpl)this.repo.get());
        this.callListeners(new RepositoryEvent(this.repo.get(), RepositoryEvent.EventType.RepositoryAdded, false));
        this.features = null;
    }

    @Override
    public Repository[] listRepositories() {
        ArrayList<Repository> repos = new ArrayList<Repository>(this.repositories.values());
        return repos.toArray(new Repository[repos.size()]);
    }

    @Override
    public void installFeature(String name) throws Exception {
        this.installFeature(name, FeatureImpl.DEFAULT_VERSION);
    }

    @Override
    public void installFeature(String name, EnumSet<FeaturesService.Option> options) throws Exception {
        this.installFeature(name, FeatureImpl.DEFAULT_VERSION, options);
    }

    @Override
    public void installFeature(String name, String version) throws Exception {
        this.installFeature(name, version, EnumSet.noneOf(FeaturesService.Option.class));
    }

    @Override
    public void installFeature(String name, String version, EnumSet<FeaturesService.Option> options) throws Exception {
        Feature f = this.getFeature(name, version);
        if (f == null) {
            throw new Exception("No feature named '" + name + "' with version '" + version + "' available");
        }
        this.installFeature(f, options);
    }

    @Override
    public void installFeature(Feature f, EnumSet<FeaturesService.Option> options) throws Exception {
        this.installFeatures(Collections.singleton(f), options);
    }

    @Override
    public void installFeatures(final Set<Feature> features, final EnumSet<FeaturesService.Option> options) throws Exception {
        ExecutorService executor = Executors.newCachedThreadPool();
        try {
            executor.submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    FeaturesServiceImpl.this.doInstallFeatures(features, options);
                    return null;
                }
            }).get();
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw e;
        }
        finally {
            executor.shutdown();
        }
    }

    protected void doInstallFeatures(Set<Feature> features, EnumSet<FeaturesService.Option> options) throws Exception {
        InstallationState state = new InstallationState();
        InstallationState failure = new InstallationState();
        boolean verbose = options.contains((Object)FeaturesService.Option.Verbose);
        Set<Bundle> bundlesToRefresh = null;
        try {
            boolean bl;
            for (Feature feature : features) {
                InstallationState s = new InstallationState();
                try {
                    this.doInstallFeature(s, feature, verbose);
                    HashSet<Feature> installed = new HashSet<Feature>();
                    installed.addAll(this.installed.keySet());
                    installed.addAll(s.features.keySet());
                    installed.addAll(state.features.keySet());
                    installed.add(feature);
                    for (Feature feature2 : installed) {
                        for (Conditional conditional : feature2.getConditional()) {
                            if (!this.dependenciesSatisfied(conditional.getCondition(), installed)) continue;
                            this.doInstallFeature(state, conditional.asFeature(feature2.getName(), feature2.getVersion()), verbose);
                        }
                    }
                    state.bundleInfos.putAll(s.bundleInfos);
                    state.bundles.addAll(s.bundles);
                    state.features.putAll(s.features);
                    state.installed.addAll(s.installed);
                }
                catch (Exception e) {
                    failure.bundles.addAll(s.bundles);
                    failure.features.putAll(s.features);
                    failure.installed.addAll(s.installed);
                    if (options.contains((Object)FeaturesService.Option.ContinueBatchOnFailure)) {
                        LOGGER.warn("Error when installing feature {}: {}", (Object)feature.getName(), (Object)e);
                        continue;
                    }
                    throw e;
                }
            }
            boolean print = options.contains((Object)FeaturesService.Option.PrintBundlesToRefresh);
            boolean bl2 = bl = !options.contains((Object)FeaturesService.Option.NoAutoRefreshBundles);
            if (print || bl) {
                bundlesToRefresh = this.findBundlesToRefresh(state.installed);
                StringBuilder sb = new StringBuilder();
                for (Bundle b : bundlesToRefresh) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(b.getSymbolicName()).append(" (").append(b.getBundleId()).append(")");
                }
                LOGGER.debug("Bundles to refresh: {}", (Object)sb.toString());
                if (!bundlesToRefresh.isEmpty()) {
                    if (print) {
                        if (bl) {
                            System.out.println("Refreshing bundles " + sb.toString());
                        } else {
                            System.out.println("The following bundles may need to be refreshed: " + sb.toString());
                        }
                    }
                    if (bl) {
                        LOGGER.debug("Refreshing bundles: {}", (Object)sb.toString());
                        if (!options.contains((Object)FeaturesService.Option.Boot)) {
                            this.refreshPackages(bundlesToRefresh);
                        }
                    }
                }
            }
            ArrayList<Bundle> bundlesSortedByStartLvl = new ArrayList<Bundle>(state.bundles);
            if (this.respectStartLvlDuringFeatureStartup) {
                Collections.sort(bundlesSortedByStartLvl, new Comparator<Bundle>(){

                    @Override
                    public int compare(Bundle bundle, Bundle bundle1) {
                        return ((BundleStartLevel)bundle.adapt(BundleStartLevel.class)).getStartLevel() - ((BundleStartLevel)bundle1.adapt(BundleStartLevel.class)).getStartLevel();
                    }
                });
            }
            for (Bundle b : bundlesSortedByStartLvl) {
                Long bundleId;
                BundleInfo bundleInfo;
                Dictionary d = b.getHeaders();
                String fragmentHostHeader = (String)d.get("Fragment-Host");
                if (fragmentHostHeader != null && fragmentHostHeader.trim().length() != 0 || !state.installed.contains(b) && (b.getState() == 8 || b.getState() == 32 || !this.isBundlePersistentlyStarted(b)) || (bundleInfo = state.bundleInfos.get(bundleId = Long.valueOf(b.getBundleId()))) != null && !bundleInfo.isStart()) continue;
                try {
                    if (options.contains((Object)FeaturesService.Option.NoAutoStartBundles)) continue;
                    b.start();
                }
                catch (BundleException be) {
                    String msg = String.format("Could not start bundle %s in feature(s) %s: %s", b.getLocation(), this.getFeaturesContainingBundleList(b), be.getMessage());
                    throw new Exception(msg, be);
                }
            }
            if (!options.contains((Object)FeaturesService.Option.NoCleanIfFailure)) {
                failure.installed.removeAll(state.bundles);
                for (Bundle b : failure.installed) {
                    try {
                        b.uninstall();
                    }
                    catch (Exception exception) {}
                }
            }
            if (options.contains((Object)FeaturesService.Option.Boot) && bundlesToRefresh != null && !bundlesToRefresh.isEmpty()) {
                this.refreshPackagesAsync(bundlesToRefresh);
            }
        }
        catch (Exception e) {
            if (!options.contains((Object)FeaturesService.Option.NoCleanIfFailure)) {
                for (Bundle b : state.installed) {
                    try {
                        b.uninstall();
                    }
                    catch (Exception exception) {}
                }
                for (Bundle b : failure.installed) {
                    try {
                        b.uninstall();
                    }
                    catch (Exception exception) {}
                }
            } else {
                for (Bundle b : state.installed) {
                    try {
                        b.start();
                    }
                    catch (Exception exception) {}
                }
            }
            throw e;
        }
        for (Feature feature : features) {
            this.callListeners(new FeatureEvent(feature, FeatureEvent.EventType.FeatureInstalled, false));
        }
        for (Map.Entry entry : state.features.entrySet()) {
            this.installed.put((Feature)entry.getKey(), (Set<Long>)entry.getValue());
        }
        this.saveState();
    }

    protected void doInstallFeature(InstallationState state, Feature feature, boolean verbose) throws Exception {
        LOGGER.debug("Installing feature " + feature.getName() + " " + feature.getVersion());
        if (verbose) {
            System.out.println("Installing feature " + feature.getName() + " " + feature.getVersion());
        }
        for (Feature dependency : feature.getDependencies()) {
            Map<String, Feature> avail;
            VersionRange range = FeatureImpl.DEFAULT_VERSION.equals(dependency.getVersion()) ? VersionRange.ANY_VERSION : new VersionRange(dependency.getVersion(), true, true);
            Feature fi = null;
            for (Feature f : this.installed.keySet()) {
                Version v;
                if (!f.getName().equals(dependency.getName()) || !range.contains(v = VersionTable.getVersion(f.getVersion())) || fi != null && VersionTable.getVersion(fi.getVersion()).compareTo(v) >= 0) continue;
                fi = f;
            }
            if (fi == null && (avail = this.getFeatures().get(dependency.getName())) != null) {
                for (Feature f : avail.values()) {
                    Version v = VersionTable.getVersion(f.getVersion());
                    if (!range.contains(v) || fi != null && VersionTable.getVersion(fi.getVersion()).compareTo(v) >= 0) continue;
                    fi = f;
                }
            }
            if (fi == null) {
                throw new Exception("No feature named '" + dependency.getName() + "' with version '" + dependency.getVersion() + "' available");
            }
            if (state.features.containsKey(fi)) {
                LOGGER.debug("Feature {} with version {} is already being installed", (Object)feature.getName(), (Object)feature.getVersion());
                continue;
            }
            if (fi.getName().equals(feature.getName()) && fi.getVersion().equals(feature.getVersion())) continue;
            this.doInstallFeature(state, fi, verbose);
        }
        for (ConfigInfo config : feature.getConfigurations()) {
            String name = config.getName();
            Map<String, String> props = config.getProperties();
            String[] pid = this.parsePid(config.getName());
            Configuration cfg = this.findExistingConfiguration(this.configAdmin, pid[0], pid[1]);
            if (cfg == null) {
                Dictionary<String, String> cfgProps = this.convertToDict(config.getProperties());
                cfg = this.createConfiguration(this.configAdmin, pid[0], pid[1]);
                String key = this.createConfigurationKey(pid[0], pid[1]);
                cfgProps.put(CONFIG_KEY, key);
                cfg.update(cfgProps);
                continue;
            }
            if (!config.isAppend()) continue;
            Dictionary properties = cfg.getProperties();
            Enumeration propKeys = properties.keys();
            while (propKeys.hasMoreElements()) {
                String key = (String)propKeys.nextElement();
                if (!props.containsKey(key)) continue;
                props.remove(key);
            }
            if (props.size() <= 0) continue;
            Dictionary<String, String> cfgProps = this.convertToDict(props);
            cfg.update(cfgProps);
        }
        for (ConfigFileInfo configFile : feature.getConfigurationFiles()) {
            this.installConfigurationFile(configFile.getLocation(), configFile.getFinalname(), configFile.isOverride(), verbose);
        }
        TreeSet<Long> bundles = new TreeSet<Long>();
        LinkedList<InstallResult> installResultList = new LinkedList<InstallResult>();
        for (BundleInfo bInfo : Overrides.override(this.resolve(feature), this.overrides)) {
            InstallResult result = this.installBundleIfNeeded(state, bInfo, verbose);
            if (result.isPreviouslyInstalled()) continue;
            bundles.add(result.getBundle().getBundleId());
            state.bundleInfos.put(result.getBundle().getBundleId(), bInfo);
            installResultList.add(result);
        }
        for (InstallResult result : installResultList) {
            if (result.isPreviouslyInstalled()) continue;
            this.startBundleIfNeeded(result.getBundle(), result.getStartLevel());
        }
        for (BundleInfo bInfo : feature.getBundles()) {
            Bundle bundle = this.isBundleInstalled(bInfo);
            if (bundle == null || bundles.contains(bundle.getBundleId())) continue;
            bundles.add(bundle.getBundleId());
        }
        state.features.put(feature, bundles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Bundle isBundleInstalled(BundleInfo bundleInfo) throws IOException, BundleException {
        BufferedInputStream is;
        String bundleLocation = bundleInfo.getLocation();
        LOGGER.debug("Checking " + bundleLocation);
        try {
            is = new BufferedInputStream(new URL(bundleLocation).openStream());
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage());
            throw e;
        }
        try {
            String vStr;
            String sn;
            ((InputStream)is).mark(262144);
            JarInputStream jar = new JarInputStream(is);
            Manifest m = jar.getManifest();
            if (m == null) {
                ZipEntry entry;
                while ((entry = jar.getNextEntry()) != null) {
                    if (!"META-INF/MANIFEST.MF".equals(entry.getName())) continue;
                    m = new Manifest(jar);
                    break;
                }
                if (m == null) {
                    throw new BundleException("Manifest not present in the zip " + bundleLocation);
                }
            }
            if ((sn = m.getMainAttributes().getValue("Bundle-SymbolicName")) == null) {
                throw new BundleException("Jar is not a bundle, no Bundle-SymbolicName " + bundleLocation);
            }
            int attributeIndexSep = sn.indexOf(59);
            if (attributeIndexSep != -1) {
                sn = sn.substring(0, attributeIndexSep);
            }
            Version v = (vStr = m.getMainAttributes().getValue("Bundle-Version")) == null ? Version.emptyVersion : Version.parseVersion((String)vStr);
            for (Bundle b : this.bundleContext.getBundles()) {
                Version bv;
                if (b.getSymbolicName() == null || !b.getSymbolicName().equals(sn)) continue;
                vStr = (String)b.getHeaders().get("Bundle-Version");
                Version version = bv = vStr == null ? Version.emptyVersion : Version.parseVersion((String)vStr);
                if (!v.equals((Object)bv)) continue;
                LOGGER.debug("Found installed bundle: " + b);
                Bundle bundle = b;
                return bundle;
            }
            Bundle bundle = null;
            return bundle;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    private Dictionary<String, String> convertToDict(Map<String, String> props) {
        Hashtable<String, String> cfgProps = new Hashtable<String, String>();
        for (Map.Entry<String, String> property : props.entrySet()) {
            ((Dictionary)cfgProps).put(property.getKey(), property.getValue());
        }
        return cfgProps;
    }

    private String createConfigurationKey(String pid, String factoryPid) {
        return factoryPid == null ? pid : pid + "-" + factoryPid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<BundleInfo> resolve(Feature feature) throws Exception {
        String resolver = feature.getResolver();
        if (resolver == null || resolver.length() == 0) {
            return feature.getBundles();
        }
        boolean optional = false;
        if (resolver.startsWith("(") && resolver.endsWith(")")) {
            resolver = resolver.substring(1, resolver.length() - 1);
            optional = true;
        }
        String filter = "(&(objectClass=" + Resolver.class.getName() + ")(name=" + resolver + "))";
        ServiceTracker tracker = new ServiceTracker(this.bundleContext, FrameworkUtil.createFilter((String)filter), null);
        tracker.open();
        try {
            if (optional) {
                Resolver r = (Resolver)tracker.getService();
                if (r != null) {
                    List<BundleInfo> list = r.resolve(feature);
                    return list;
                }
                LOGGER.debug("Optional resolver '" + resolver + "' not found, using the default resolver");
                List<BundleInfo> list = feature.getBundles();
                return list;
            }
            Resolver r = (Resolver)tracker.waitForService(this.resolverTimeout);
            if (r == null) {
                throw new Exception("Unable to find required resolver '" + resolver + "'");
            }
            List<BundleInfo> list = r.resolve(feature);
            return list;
        }
        finally {
            tracker.close();
        }
    }

    protected Set<Bundle> findBundlesToRefresh(Set<Bundle> installed) {
        HashSet<Bundle> toRefresh = new HashSet<Bundle>();
        HashSet<Bundle> bundles = new HashSet<Bundle>(Arrays.asList(this.bundleContext.getBundles()));
        this.findBundlesWithOptionalPackagesToRefresh(bundles, toRefresh);
        this.findBundlesWithFragmentsToRefresh(bundles, toRefresh);
        return toRefresh;
    }

    protected void findBundlesWithFragmentsToRefresh(Collection<Bundle> allBundles, Set<Bundle> toRefresh) {
        if (toRefresh.isEmpty()) {
            return;
        }
        HashSet<Bundle> bundles = new HashSet<Bundle>(allBundles);
        bundles.removeAll(toRefresh);
        if (bundles.isEmpty()) {
            return;
        }
        for (Bundle bundle : new ArrayList<Bundle>(toRefresh)) {
            BundleRevision rev = (BundleRevision)bundle.adapt(BundleRevision.class);
            if (rev == null) continue;
            for (BundleRequirement req : rev.getDeclaredRequirements(null)) {
                if (!"osgi.wiring.host".equals(req.getNamespace())) continue;
                for (Bundle hostBundle : bundles) {
                    BundleRevision hostRev;
                    if (toRefresh.contains(hostBundle) || (hostRev = (BundleRevision)hostBundle.adapt(BundleRevision.class)) == null) continue;
                    for (BundleCapability cap : hostRev.getDeclaredCapabilities(null)) {
                        if (!req.matches(cap)) continue;
                        toRefresh.add(hostBundle);
                    }
                }
            }
        }
    }

    protected void findBundlesWithOptionalPackagesToRefresh(Collection<Bundle> allBundles, Set<Bundle> toRefresh) {
        if (toRefresh.isEmpty()) {
            return;
        }
        HashSet<Bundle> bundles = new HashSet<Bundle>(allBundles);
        bundles.removeAll(toRefresh);
        if (bundles.isEmpty()) {
            return;
        }
        for (Bundle bundle : bundles) {
            this.matchBundleWithOptionalImport(bundle, toRefresh);
        }
    }

    private void matchBundleWithOptionalImport(Bundle bundle, Set<Bundle> toRefresh) {
        BundleRevision revision = (BundleRevision)bundle.adapt(BundleRevision.class);
        for (BundleRequirement req : revision.getDeclaredRequirements("osgi.wiring.package")) {
            if (!"optional".equals(req.getDirectives().get("resolution"))) continue;
            BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
            BundleWire reqwire = null;
            if (wiring != null) {
                for (BundleWire wire : wiring.getRequiredWires("osgi.wiring.package")) {
                    if (!req.equals(wire.getRequirement())) continue;
                    BundleCapability cap = wire.getCapability();
                    BundleRevision provider = wire.getProvider();
                    LOGGER.debug("Optional requirement {} from {} wires to capability {} provided by {}", new Object[]{req, bundle, cap, provider});
                    reqwire = wire;
                    break;
                }
            }
            if (reqwire != null) continue;
            for (Bundle provider : toRefresh) {
                BundleRevision providerRev = (BundleRevision)provider.adapt(BundleRevision.class);
                if (providerRev == null) continue;
                for (BundleCapability cap : providerRev.getDeclaredCapabilities("osgi.wiring.package")) {
                    if (!req.matches(cap)) continue;
                    LOGGER.info("Found possible provider for unwired optional requirement {} from {}: {}", new Object[]{req, bundle, provider});
                    toRefresh.add(bundle);
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InstallResult installBundleIfNeeded(InstallationState state, BundleInfo bundleInfo, boolean verbose) throws IOException, BundleException {
        BufferedInputStream is;
        String bundleLocation = bundleInfo.getLocation();
        LOGGER.debug("Checking " + bundleLocation);
        try {
            is = new BufferedInputStream(new URL(bundleLocation).openStream());
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage());
            throw e;
        }
        try {
            String vStr;
            String sn;
            ((InputStream)is).mark(262144);
            JarInputStream jar = new JarInputStream(is);
            Manifest m = jar.getManifest();
            if (m == null) {
                ZipEntry entry;
                while ((entry = jar.getNextEntry()) != null) {
                    if (!"META-INF/MANIFEST.MF".equals(entry.getName())) continue;
                    m = new Manifest(jar);
                    break;
                }
                if (m == null) {
                    throw new BundleException("Manifest not present in the zip " + bundleLocation);
                }
            }
            if ((sn = m.getMainAttributes().getValue("Bundle-SymbolicName")) == null) {
                throw new BundleException("Jar is not a bundle, no Bundle-SymbolicName " + bundleLocation);
            }
            int attributeIndexSep = sn.indexOf(59);
            if (attributeIndexSep != -1) {
                sn = sn.substring(0, attributeIndexSep);
            }
            Version v = (vStr = m.getMainAttributes().getValue("Bundle-Version")) == null ? Version.emptyVersion : Version.parseVersion((String)vStr);
            for (Bundle b : this.bundleContext.getBundles()) {
                Version bv;
                if (b.getSymbolicName() == null || !b.getSymbolicName().equals(sn)) continue;
                vStr = (String)b.getHeaders().get("Bundle-Version");
                Version version = bv = vStr == null ? Version.emptyVersion : Version.parseVersion((String)vStr);
                if (!v.equals((Object)bv)) continue;
                LOGGER.debug("Found installed bundle: " + b);
                if (verbose) {
                    System.out.println("Found installed bundle: " + b);
                }
                state.bundles.add(b);
                InstallResult installResult = new InstallResult(true, b, 0);
                return installResult;
            }
            try {
                ((InputStream)is).reset();
            }
            catch (IOException e) {
                ((InputStream)is).close();
                is = new BufferedInputStream(new URL(bundleLocation).openStream());
            }
            LOGGER.debug("Installing bundle " + bundleLocation);
            if (verbose) {
                System.out.println("Installing bundle " + bundleLocation);
            }
            Bundle b = this.getBundleContext().installBundle(bundleLocation, (InputStream)is);
            state.bundles.add(b);
            state.installed.add(b);
            InstallResult installResult = new InstallResult(false, b, bundleInfo.getStartLevel());
            return installResult;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    private void startBundleIfNeeded(Bundle bundle, int startLevel) {
        if (startLevel > 0) {
            ((BundleStartLevel)bundle.adapt(BundleStartLevel.class)).setStartLevel(startLevel);
        }
    }

    private boolean isBundlePersistentlyStarted(Bundle bundle) {
        return ((BundleStartLevel)bundle.adapt(BundleStartLevel.class)).isPersistentlyStarted();
    }

    public void installConfigurationFile(String fileLocation, String finalname, boolean override, boolean verbose) throws IOException {
        File file;
        LOGGER.debug("Checking configuration file " + fileLocation);
        if (verbose) {
            System.out.println("Checking configuration file " + fileLocation);
        }
        String basePath = System.getProperty("karaf.base");
        if (finalname.indexOf("${") != -1) {
            int marker = finalname.indexOf("}");
            finalname = finalname.substring(marker + 1);
        }
        if ((file = new File(finalname = basePath + File.separator + finalname)).exists() && !override) {
            LOGGER.debug("configFile already exist, don't override it");
            return;
        }
        InputStream is = null;
        OutputStream fop = null;
        try {
            is = new BufferedInputStream(new URL(fileLocation).openStream());
            if (!file.exists()) {
                File parentFile = file.getParentFile();
                if (parentFile != null) {
                    parentFile.mkdirs();
                }
                file.createNewFile();
            }
            fop = new FileOutputStream(file);
            int bytesRead = 0;
            byte[] buffer = new byte[1024];
            while ((bytesRead = is.read(buffer)) != -1) {
                ((FileOutputStream)fop).write(buffer, 0, bytesRead);
            }
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage());
            throw e;
        }
        catch (MalformedURLException e) {
            LOGGER.error(e.getMessage());
            throw e;
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (fop != null) {
                fop.flush();
                ((FileOutputStream)fop).close();
            }
        }
    }

    @Override
    public void uninstallFeature(String name) throws Exception {
        this.uninstallFeature(name, EnumSet.noneOf(FeaturesService.Option.class));
    }

    @Override
    public void uninstallFeature(String name, EnumSet<FeaturesService.Option> options) throws Exception {
        ArrayList<String> versions = new ArrayList<String>();
        for (Feature f : this.installed.keySet()) {
            if (!name.equals(f.getName())) continue;
            versions.add(f.getVersion());
        }
        if (versions.size() == 0) {
            throw new Exception("Feature named '" + name + "' is not installed");
        }
        if (versions.size() > 1) {
            StringBuilder sb = new StringBuilder();
            sb.append("Feature named '").append(name).append("' has multiple versions installed (");
            for (int i = 0; i < versions.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append((String)versions.get(i));
            }
            sb.append("). Please specify the version to uninstall.");
            throw new Exception(sb.toString());
        }
        this.uninstallFeature(name, (String)versions.get(0), options);
    }

    @Override
    public void uninstallFeature(String name, String version) throws Exception {
        this.uninstallFeature(name, version, EnumSet.noneOf(FeaturesService.Option.class));
    }

    @Override
    public void uninstallFeature(String name, String version, EnumSet<FeaturesService.Option> options) throws Exception {
        boolean refresh;
        Feature feature = this.getFeature(name, version);
        if (feature == null || !this.installed.containsKey(feature)) {
            throw new Exception("Feature named '" + name + "' with version '" + version + "' is not installed");
        }
        boolean verbose = options != null && options.contains((Object)FeaturesService.Option.Verbose);
        boolean bl = refresh = options == null || !options.contains((Object)FeaturesService.Option.NoAutoRefreshBundles);
        if (verbose) {
            System.out.println("Uninstalling feature " + feature.getName() + " " + feature.getVersion());
        }
        Set<Long> bundles = this.installed.remove(feature);
        for (Conditional conditional : feature.getConditional()) {
            Set<Long> ids = this.installed.remove(conditional.asFeature(feature.getName(), feature.getVersion()));
            if (ids == null) continue;
            bundles.addAll(ids);
        }
        for (Feature feature2 : new ArrayList<Feature>(this.installed.keySet())) {
            Feature f = this.getFeature(feature2.getName(), feature2.getVersion());
            if (f == null) continue;
            for (Conditional conditional : f.getConditional()) {
                Set<Long> ids;
                if (this.dependenciesSatisfied(conditional.getCondition(), this.installed.keySet()) || (ids = this.installed.remove(conditional.asFeature(f.getName(), f.getVersion()))) == null) continue;
                bundles.addAll(ids);
            }
        }
        for (Set set : this.installed.values()) {
            bundles.removeAll(set);
        }
        Iterator<Object> i$ = bundles.iterator();
        while (i$.hasNext()) {
            long l = (Long)i$.next();
            Bundle b = this.getBundleContext().getBundle(l);
            if (b == null) continue;
            b.uninstall();
        }
        if (refresh) {
            if (verbose) {
                System.out.println("Refreshing packages");
            }
            this.refreshPackages(null);
        }
        this.callListeners(new FeatureEvent(feature, FeatureEvent.EventType.FeatureUninstalled, false));
        this.saveState();
    }

    @Override
    public Feature[] listFeatures() throws Exception {
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (Map<String, Feature> featureWithDifferentVersion : this.getFeatures().values()) {
            for (Feature f : featureWithDifferentVersion.values()) {
                features.add(f);
            }
        }
        return features.toArray(new Feature[features.size()]);
    }

    @Override
    public Feature[] listInstalledFeatures() {
        Set<Feature> result = this.installed.keySet();
        return result.toArray(new Feature[result.size()]);
    }

    @Override
    public boolean isInstalled(Feature f) {
        return this.installed.containsKey(f);
    }

    @Override
    public Feature getFeature(String name) throws Exception {
        return this.getFeature(name, FeatureImpl.DEFAULT_VERSION);
    }

    @Override
    public Feature getFeature(String name, String version) throws Exception {
        Feature feature;
        block6: {
            Map<String, Feature> versions;
            if (version != null) {
                version = version.trim();
            }
            if ((versions = this.getFeatures().get(name)) == null || versions.isEmpty()) {
                return null;
            }
            feature = versions.get(version);
            if (feature != null) break block6;
            if (FeatureImpl.DEFAULT_VERSION.equals(version)) {
                Version latest = new Version(FeaturesServiceImpl.cleanupVersion(version));
                for (String available : versions.keySet()) {
                    Version availableVersion = new Version(FeaturesServiceImpl.cleanupVersion(available));
                    if (availableVersion.compareTo(latest) <= 0) continue;
                    feature = versions.get(available);
                    latest = availableVersion;
                }
            } else {
                Version latest = new Version(FeaturesServiceImpl.cleanupVersion(FeatureImpl.DEFAULT_VERSION));
                VersionRange versionRange = new VersionRange(version, true, true);
                for (String available : versions.keySet()) {
                    Version availableVersion = new Version(FeaturesServiceImpl.cleanupVersion(available));
                    if (availableVersion.compareTo(latest) <= 0 || !versionRange.contains(availableVersion)) continue;
                    feature = versions.get(available);
                    latest = availableVersion;
                }
            }
        }
        return feature;
    }

    protected Map<String, Map<String, Feature>> getFeatures() throws Exception {
        if (this.features == null) {
            boolean newRepo;
            HashMap<String, Map<String, Feature>> map = new HashMap<String, Map<String, Feature>>();
            do {
                newRepo = false;
                for (Repository repo : this.listRepositories()) {
                    for (URI uri : repo.getRepositories()) {
                        if (this.repositories.containsKey(uri)) continue;
                        this.internalAddRepository(uri);
                        newRepo = true;
                    }
                }
            } while (newRepo);
            for (Repository repo : this.repositories.values()) {
                for (Feature f : repo.getFeatures()) {
                    if (map.get(f.getName()) == null) {
                        HashMap<String, Feature> versionMap = new HashMap<String, Feature>();
                        versionMap.put(f.getVersion(), f);
                        map.put(f.getName(), versionMap);
                        continue;
                    }
                    ((Map)map.get(f.getName())).put(f.getVersion(), f);
                }
            }
            this.features = map;
        }
        return this.features;
    }

    public void start() throws Exception {
        EventAdminListener listener = null;
        try {
            this.getClass().getClassLoader().loadClass("org.osgi.service.event.EventAdmin");
            listener = new EventAdminListener(this.bundleContext);
        }
        catch (Throwable t) {
            LOGGER.debug("EventAdmin package is not available, just don't use it");
        }
        this.eventAdminListener = listener;
        if (!this.loadState()) {
            if (this.uris != null) {
                for (URI uri : this.uris) {
                    try {
                        this.internalAddRepository(uri);
                    }
                    catch (Exception e) {
                        LOGGER.warn(String.format("Unable to add features repository %s at startup", uri), (Throwable)e);
                    }
                }
            }
            this.saveState();
        }
        if (this.boot != null && !this.bootFeaturesInstalled) {
            if (this.bootFeaturesAsynchronous) {
                new Thread(){

                    public void run() {
                        String[] list = FeaturesServiceImpl.this.boot.split(",");
                        LinkedHashSet<Feature> features = new LinkedHashSet<Feature>();
                        for (String f : list) {
                            if ((f = f.trim()).length() <= 0) continue;
                            String featureVersion = null;
                            String[] parts = f.split(";");
                            String featureName = parts[0];
                            for (String part : parts) {
                                if (!part.startsWith(FeatureImpl.VERSION_PREFIX)) continue;
                                featureVersion = part.substring(FeatureImpl.VERSION_PREFIX.length());
                            }
                            if (featureVersion == null) {
                                featureVersion = FeatureImpl.DEFAULT_VERSION;
                            }
                            try {
                                Feature feature = FeaturesServiceImpl.this.getFeature(featureName, featureVersion);
                                if (feature != null) {
                                    features.add(feature);
                                    continue;
                                }
                                LOGGER.error("Error installing boot feature " + f + ": feature not found");
                            }
                            catch (Exception e) {
                                LOGGER.error("Error installing boot feature " + f, (Throwable)e);
                            }
                        }
                        try {
                            FeaturesServiceImpl.this.installFeatures(features, EnumSet.of(FeaturesService.Option.NoCleanIfFailure, FeaturesService.Option.ContinueBatchOnFailure, FeaturesService.Option.Boot));
                        }
                        catch (Exception e) {
                            LOGGER.error("Error installing boot features", (Throwable)e);
                        }
                        FeaturesServiceImpl.this.bootFeaturesInstalled = true;
                        FeaturesServiceImpl.this.saveState();
                    }
                }.start();
            } else {
                String[] list = this.boot.split(",");
                LinkedHashSet<Feature> features = new LinkedHashSet<Feature>();
                for (String f : list) {
                    if ((f = f.trim()).length() <= 0) continue;
                    String featureVersion = null;
                    String[] parts = f.split(";");
                    String featureName = parts[0];
                    for (String part : parts) {
                        if (!part.startsWith(FeatureImpl.VERSION_PREFIX)) continue;
                        featureVersion = part.substring(FeatureImpl.VERSION_PREFIX.length());
                    }
                    if (featureVersion == null) {
                        featureVersion = FeatureImpl.DEFAULT_VERSION;
                    }
                    try {
                        Feature feature = this.getFeature(featureName, featureVersion);
                        if (feature != null) {
                            features.add(feature);
                            continue;
                        }
                        LOGGER.error("Error installing boot feature " + f + ": feature not found");
                    }
                    catch (Exception e) {
                        LOGGER.error("Error installing boot feature " + f, (Throwable)e);
                    }
                }
                try {
                    this.installFeatures(features, EnumSet.of(FeaturesService.Option.NoCleanIfFailure, FeaturesService.Option.ContinueBatchOnFailure, FeaturesService.Option.Boot));
                }
                catch (Exception e) {
                    LOGGER.error("Error installing boot features", (Throwable)e);
                }
                this.bootFeaturesInstalled = true;
                this.saveState();
            }
        }
    }

    public void stop() throws Exception {
        while (!this.repositories.isEmpty()) {
            this.internalRemoveRepository(this.repositories.keySet().iterator().next());
        }
    }

    protected void refreshPackages(Collection<Bundle> bundles) throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        FrameworkWiring fw = (FrameworkWiring)this.bundleContext.getBundle(0L).adapt(FrameworkWiring.class);
        fw.refreshBundles(bundles, new FrameworkListener[]{new FrameworkListener(){

            public void frameworkEvent(FrameworkEvent event) {
                if (event.getType() == 2) {
                    LOGGER.error("Framework error", event.getThrowable());
                }
                latch.countDown();
            }
        }});
        latch.await();
    }

    protected void refreshPackagesAsync(Collection<Bundle> bundles) throws InterruptedException {
        FrameworkWiring fw = (FrameworkWiring)this.bundleContext.getBundle(0L).adapt(FrameworkWiring.class);
        fw.refreshBundles(bundles, new FrameworkListener[0]);
    }

    protected String[] parsePid(String pid) {
        int n = pid.indexOf(45);
        if (n > 0) {
            String factoryPid = pid.substring(n + 1);
            pid = pid.substring(0, n);
            return new String[]{pid, factoryPid};
        }
        return new String[]{pid, null};
    }

    protected Configuration createConfiguration(ConfigurationAdmin configurationAdmin, String pid, String factoryPid) throws IOException, InvalidSyntaxException {
        if (factoryPid != null) {
            return configurationAdmin.createFactoryConfiguration(pid, null);
        }
        return configurationAdmin.getConfiguration(pid, null);
    }

    protected Configuration findExistingConfiguration(ConfigurationAdmin configurationAdmin, String pid, String factoryPid) throws IOException, InvalidSyntaxException {
        String filter;
        if (factoryPid == null) {
            filter = "(service.pid=" + pid + ")";
        } else {
            String key = this.createConfigurationKey(pid, factoryPid);
            filter = "(org.apache.karaf.features.configKey=" + key + ")";
        }
        Configuration[] configurations = configurationAdmin.listConfigurations(filter);
        if (configurations != null && configurations.length > 0) {
            return configurations[0];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveState() {
        try {
            File file = this.bundleContext.getDataFile("FeaturesServiceState.properties");
            Properties props = new Properties();
            this.saveSet(props, "repositories.", this.repositories.keySet());
            this.saveMap(props, "features.", this.installed);
            props.put("bootFeaturesInstalled", Boolean.toString(this.bootFeaturesInstalled));
            FileOutputStream os = new FileOutputStream(file);
            try {
                props.store(new FileOutputStream(file), "FeaturesService State");
            }
            finally {
                ((OutputStream)os).close();
            }
        }
        catch (Exception e) {
            LOGGER.error("Error persisting FeaturesService state", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean loadState() {
        try {
            File file = this.bundleContext.getDataFile("FeaturesServiceState.properties");
            if (!file.exists()) {
                return false;
            }
            Properties props = new Properties();
            FileInputStream is = new FileInputStream(file);
            try {
                props.load(is);
            }
            finally {
                ((InputStream)is).close();
            }
            Set<URI> repositories = this.loadSet(props, "repositories.");
            for (URI repo : repositories) {
                try {
                    this.internalAddRepository(repo);
                }
                catch (Exception e) {
                    LOGGER.warn(String.format("Unable to add features repository %s at startup", repo), (Throwable)e);
                }
            }
            this.installed = this.loadMap(props, "features.");
            for (Feature f : this.installed.keySet()) {
                this.callListeners(new FeatureEvent(f, FeatureEvent.EventType.FeatureInstalled, true));
            }
            this.bootFeaturesInstalled = Boolean.parseBoolean((String)props.get("bootFeaturesInstalled"));
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Error loading FeaturesService state", (Throwable)e);
            return false;
        }
    }

    protected void saveSet(Properties props, String prefix, Set<URI> set) {
        ArrayList<URI> l = new ArrayList<URI>(set);
        props.clear();
        props.put(prefix + "count", Integer.toString(l.size()));
        for (int i = 0; i < l.size(); ++i) {
            props.put(prefix + "item." + i, ((URI)l.get(i)).toString());
        }
    }

    protected Set<URI> loadSet(Properties props, String prefix) {
        HashSet<URI> l = new HashSet<URI>();
        String countStr = (String)props.get(prefix + "count");
        if (countStr != null) {
            int count = Integer.parseInt(countStr);
            for (int i = 0; i < count; ++i) {
                l.add(URI.create((String)props.get(prefix + "item." + i)));
            }
        }
        return l;
    }

    protected void saveMap(Properties props, String prefix, Map<Feature, Set<Long>> map) {
        for (Map.Entry<Feature, Set<Long>> entry : map.entrySet()) {
            Feature key = entry.getKey();
            String val = this.createValue(entry.getValue());
            props.put(prefix + key.toString(), val);
        }
    }

    protected Map<Feature, Set<Long>> loadMap(Properties props, String prefix) {
        HashMap<Feature, Set<Long>> map = new HashMap<Feature, Set<Long>>();
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith(prefix)) continue;
            String val = (String)props.get(key);
            Set<Long> set = this.readValue(val);
            map.put(FeatureImpl.valueOf(key.substring(prefix.length())), set);
        }
        return map;
    }

    protected String createValue(Set<Long> set) {
        StringBuilder sb = new StringBuilder();
        for (long i : set) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(i);
        }
        return sb.toString();
    }

    protected Set<Long> readValue(String val) {
        HashSet<Long> set = new HashSet<Long>();
        if (val != null && val.length() != 0) {
            for (String str : val.split(",")) {
                set.add(Long.parseLong(str));
            }
        }
        return set;
    }

    protected void callListeners(FeatureEvent event) {
        if (this.eventAdminListener != null) {
            this.eventAdminListener.featureEvent(event);
        }
        for (FeaturesListener listener : this.listeners) {
            listener.featureEvent(event);
        }
    }

    protected void callListeners(RepositoryEvent event) {
        if (this.eventAdminListener != null) {
            this.eventAdminListener.repositoryEvent(event);
        }
        for (FeaturesListener listener : this.listeners) {
            listener.repositoryEvent(event);
        }
    }

    public static String cleanupVersion(String version) {
        Matcher m = fuzzyVersion.matcher(version);
        if (m.matches()) {
            StringBuffer result = new StringBuffer();
            String d1 = m.group(1);
            String d2 = m.group(3);
            String d3 = m.group(5);
            String qualifier = m.group(7);
            if (d1 != null) {
                result.append(d1);
                if (d2 != null) {
                    result.append(".");
                    result.append(d2);
                    if (d3 != null) {
                        result.append(".");
                        result.append(d3);
                        if (qualifier != null) {
                            result.append(".");
                            FeaturesServiceImpl.cleanupModifier(result, qualifier);
                        }
                    } else if (qualifier != null) {
                        result.append(".0.");
                        FeaturesServiceImpl.cleanupModifier(result, qualifier);
                    }
                } else if (qualifier != null) {
                    result.append(".0.0.");
                    FeaturesServiceImpl.cleanupModifier(result, qualifier);
                }
                return result.toString();
            }
        }
        return version;
    }

    static void cleanupModifier(StringBuffer result, String modifier) {
        Matcher m = fuzzyModifier.matcher(modifier);
        if (m.matches()) {
            modifier = m.group(2);
        }
        for (int i = 0; i < modifier.length(); ++i) {
            char c = modifier.charAt(i);
            if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_') && c != '-') continue;
            result.append(c);
        }
    }

    public Set<Feature> getFeaturesContainingBundle(Bundle bundle) throws Exception {
        HashSet<Feature> features = new HashSet<Feature>();
        for (Map<String, Feature> featureMap : this.getFeatures().values()) {
            block1: for (Feature f : featureMap.values()) {
                for (BundleInfo bi : f.getBundles()) {
                    if (!bi.getLocation().equals(bundle.getLocation())) continue;
                    features.add(f);
                    continue block1;
                }
            }
        }
        return features;
    }

    private String getFeaturesContainingBundleList(Bundle bundle) throws Exception {
        Set<Feature> features = this.getFeaturesContainingBundle(bundle);
        StringBuilder buffer = new StringBuilder();
        Iterator<Feature> iter = features.iterator();
        while (iter.hasNext()) {
            Feature feature = iter.next();
            buffer.append(feature.getId());
            if (!iter.hasNext()) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }

    private boolean dependenciesSatisfied(List<Feature> dependencies, Set<Feature> installed) throws Exception {
        boolean satisfied = true;
        for (Feature dep : dependencies) {
            Feature f = this.getFeature(dep.getName(), dep.getVersion());
            if (f == null || installed.contains(f)) continue;
            satisfied = false;
        }
        return satisfied;
    }

    protected static class InstallResult {
        private final boolean previouslyInstalled;
        private final Bundle bundle;
        private final int startLevel;

        protected InstallResult(boolean previouslyInstalled, Bundle bundle, int startLevel) {
            this.previouslyInstalled = previouslyInstalled;
            this.bundle = bundle;
            this.startLevel = startLevel;
        }

        public boolean isPreviouslyInstalled() {
            return this.previouslyInstalled;
        }

        public Bundle getBundle() {
            return this.bundle;
        }

        public int getStartLevel() {
            return this.startLevel;
        }
    }

    protected static class InstallationState {
        final Set<Bundle> installed = new HashSet<Bundle>();
        final Set<Bundle> bundles = new TreeSet<Bundle>();
        final Map<Long, BundleInfo> bundleInfos = new HashMap<Long, BundleInfo>();
        final Map<Feature, Set<Long>> features = new HashMap<Feature, Set<Long>>();

        protected InstallationState() {
        }
    }
}

