/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.git;

import io.hawt.git.RuntimeIOException;
import io.hawt.util.Files;
import io.hawt.util.IOHelper;
import io.hawt.util.Strings;
import io.hawt.util.XmlHelper;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileInfo {
    private static final transient Logger LOG = LoggerFactory.getLogger(FileInfo.class);
    private final String path;
    private final String name;
    private final long lastModified;
    private final long length;
    private final boolean directory;
    private final String mimeType;
    private String[] xmlNamespaces;
    private String iconUrl;
    private String summary;
    private String displayName;
    private String version;
    private String groupId;
    private String artifactId;

    public static FileInfo createFileInfo(File rootDir, File file, String branch) {
        if (Strings.isBlank(branch)) {
            branch = "master";
        }
        String path = FileInfo.getRelativePath(rootDir, file).replace("\\", "/");
        String mimeType = Files.getMimeType(file);
        FileInfo answer = new FileInfo(path, file.getName(), file.lastModified(), file.length(), file.isDirectory(), mimeType);
        if (file.isFile()) {
            String name = file.getName();
            if (name.indexOf(35) > 0) {
                name = name.substring(0, name.indexOf(35));
            }
            if (name.endsWith(".xml")) {
                try {
                    Set<String> uris = XmlHelper.getNamespaces(file);
                    if (uris.size() > 0) {
                        String[] namespaces = uris.toArray(new String[uris.size()]);
                        answer.setXmlNamespaces(namespaces);
                    }
                }
                catch (Exception e) {
                    LOG.warn("Failed to parse the XML namespaces in " + file + " due: " + e.getMessage() + ". This exception is ignored.", (Throwable)e);
                }
            }
        } else {
            File fabric8PropertiesFile;
            File summary;
            File[] icons = file.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    if (name == null) {
                        return false;
                    }
                    String lower = name.toLowerCase();
                    return lower.startsWith("icon.") && (lower.endsWith(".svg") || lower.endsWith(".png") || lower.endsWith(".gif") || lower.endsWith(".jpg") || lower.endsWith(".jpeg"));
                }
            });
            if (icons != null && icons.length > 0) {
                File icon = icons[0];
                String relativePath = FileInfo.getRelativePath(rootDir, icon);
                if (!relativePath.startsWith("/")) {
                    relativePath = "/" + relativePath;
                }
                answer.iconUrl = branch + relativePath;
            }
            if ((summary = new File(file, "Summary.md")).exists() && summary.isFile()) {
                try {
                    answer.summary = IOHelper.readFully(summary);
                }
                catch (IOException e) {
                    LOG.warn("Failed to load summary file " + summary + ". " + e, (Throwable)e);
                }
            }
            if ((fabric8PropertiesFile = new File(file, "fabric8.properties")).exists() && fabric8PropertiesFile.isFile()) {
                try {
                    Properties fabric8Properties = new Properties();
                    fabric8Properties.load(new FileReader(fabric8PropertiesFile));
                    answer.displayName = fabric8Properties.getProperty("name");
                    answer.groupId = fabric8Properties.getProperty("groupId");
                    answer.artifactId = fabric8Properties.getProperty("artifactId");
                    answer.version = fabric8Properties.getProperty("version");
                }
                catch (IOException e) {
                    LOG.warn("Failed to load fabric8 properties file " + fabric8PropertiesFile + ". " + e, (Throwable)e);
                }
            }
        }
        return answer;
    }

    public static String getRelativePath(File rootDir, File file) {
        try {
            String rootPath = rootDir.getCanonicalPath();
            String fullPath = file.getCanonicalPath();
            if (fullPath.startsWith(rootPath)) {
                return fullPath.substring(rootPath.length());
            }
            return fullPath;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public FileInfo(String path, String name, long lastModified, long length, boolean directory, String mimeType) {
        this.path = path;
        this.name = name;
        this.lastModified = lastModified;
        this.length = length;
        this.directory = directory;
        this.mimeType = mimeType;
    }

    public String toString() {
        return "FileInfo(" + this.path + ")";
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public long getLength() {
        return this.length;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setXmlNamespaces(String[] xmlNamespaces) {
        this.xmlNamespaces = xmlNamespaces;
    }

    public String[] getXmlNamespaces() {
        return this.xmlNamespaces;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }
}

