/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.groups.internal;

import io.fabric8.groups.MultiGroup;
import io.fabric8.groups.NodeState;
import io.fabric8.groups.internal.ChildData;
import io.fabric8.groups.internal.ZooKeeperGroup;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.curator.framework.CuratorFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperMultiGroup<T extends NodeState>
extends ZooKeeperGroup<T>
implements MultiGroup<T> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public ZooKeeperMultiGroup(CuratorFramework client, String path, Class<T> clazz) {
        super(client, path, clazz);
    }

    public ZooKeeperMultiGroup(CuratorFramework client, String path, Class<T> clazz, ExecutorService executorService) {
        super(client, path, clazz, executorService);
    }

    public ZooKeeperMultiGroup(CuratorFramework client, String path, Class<T> clazz, ThreadFactory threadFactory) {
        super(client, path, clazz, threadFactory);
    }

    @Override
    public boolean isMaster(String name) {
        List children = this.getActiveChildren();
        Collections.sort(children, this.sequenceComparator);
        for (ChildData child : children) {
            NodeState node = (NodeState)child.getNode();
            if (!node.id.equals(name)) continue;
            return child.getPath().equals(this.getId());
        }
        return false;
    }
}

