/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jolokia.client;

import io.fabric8.api.gravia.IllegalStateAssertion;
import io.fabric8.jolokia.client.OpenTypeGenerator;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.TabularType;
import org.jolokia.converter.Converters;
import org.jolokia.converter.json.JsonConvertOptions;
import org.jolokia.converter.json.ObjectToJsonConverter;
import org.jolokia.converter.object.StringToOpenTypeConverter;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public final class JSONTypeGenerator {
    private static Converters converters = new Converters();

    private JSONTypeGenerator() {
    }

    public static Object toJSON(Object value) throws OpenDataException {
        Object result = value;
        try {
            ObjectToJsonConverter converter = converters.getToJsonConverter();
            result = converter.convertToJson(value, null, JsonConvertOptions.DEFAULT);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            OpenDataException odex = new OpenDataException("Cannot convert value: " + value.getClass().getName());
            odex.initCause(ex);
            throw odex;
        }
        return result;
    }

    public static Object toOpenData(OpenType<?> otype, ClassLoader classLoader, Object value) throws OpenDataException {
        Object result;
        StringToOpenTypeConverter converter;
        if (otype instanceof CompositeType && value instanceof JSONObject) {
            converter = converters.getToOpenTypeConverter();
            result = converter.convertToObject(otype, value);
        } else if (otype instanceof TabularType && value instanceof JSONObject) {
            converter = converters.getToOpenTypeConverter();
            result = converter.convertToObject(otype, value);
        } else if (otype instanceof ArrayType && value instanceof JSONArray) {
            converter = converters.getToOpenTypeConverter();
            result = converter.convertToObject(otype, value);
        } else {
            result = OpenTypeGenerator.toOpenData(otype, value);
        }
        boolean isAssignable = result == null || otype.isValue(result);
        IllegalStateAssertion.assertTrue((Boolean)isAssignable, (String)("Value " + result + " is not a value of: " + otype));
        return result;
    }
}

