/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jolokia.client;

import io.fabric8.api.gravia.IllegalStateAssertion;
import io.fabric8.jolokia.client.JSONTypeGenerator;
import io.fabric8.jolokia.client.OpenTypeGenerator;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenMBeanAttributeInfo;
import javax.management.openmbean.OpenMBeanOperationInfo;
import javax.management.openmbean.OpenMBeanParameterInfo;
import javax.management.openmbean.OpenType;
import org.jolokia.client.J4pClient;
import org.jolokia.client.request.J4pExecRequest;
import org.jolokia.client.request.J4pReadRequest;
import org.jolokia.client.request.J4pRequest;
import org.jolokia.client.request.J4pWriteRequest;
import org.json.simple.JSONAware;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JolokiaMXBeanProxy {
    private static final Logger LOGGER = LoggerFactory.getLogger(JolokiaMXBeanProxy.class);

    private JolokiaMXBeanProxy() {
    }

    public static <T> T getMXBeanProxy(String serviceURL, ObjectName objectName, Class<T> mxbeanInterface) {
        return JolokiaMXBeanProxy.getMXBeanProxy(serviceURL, objectName, mxbeanInterface, null, null, null);
    }

    public static <T> T getMXBeanProxy(String serviceURL, ObjectName objectName, Class<T> mxbeanInterface, String username, String password) {
        return JolokiaMXBeanProxy.getMXBeanProxy(serviceURL, objectName, mxbeanInterface, username, password, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getMXBeanProxy(String serviceURL, ObjectName objectName, Class<T> mxbeanInterface, String username, String password, MBeanInfo mbeanInfo) {
        if (mbeanInfo == null) {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            try {
                try {
                    StandardMBean impl = new StandardMBean(Mockito.mock(mxbeanInterface), mxbeanInterface, true);
                    server.registerMBean(impl, objectName);
                    mbeanInfo = server.getMBeanInfo(objectName);
                }
                finally {
                    if (server.isRegistered(objectName)) {
                        server.unregisterMBean(objectName);
                    }
                }
            }
            catch (Exception ex) {
                throw new IllegalStateException("Cannot obtain MBeanInfo", ex);
            }
        }
        ClassLoader classLoader = mxbeanInterface.getClassLoader();
        MXBeanInvocationHandler handler = new MXBeanInvocationHandler(serviceURL, objectName, username, password, classLoader, mbeanInfo);
        return (T)Proxy.newProxyInstance(classLoader, new Class[]{mxbeanInterface}, (InvocationHandler)handler);
    }

    private static class MXBeanInvocationHandler
    implements InvocationHandler {
        private final Map<String, MBeanAttributeInfo> attributes = new HashMap<String, MBeanAttributeInfo>();
        private final Set<MBeanOperationInfo> operations = new HashSet<MBeanOperationInfo>();
        private final ClassLoader classLoader;
        private final ObjectName objectName;
        private final J4pClient client;

        private MXBeanInvocationHandler(String serviceURL, ObjectName objectName, String username, String password, ClassLoader classLoader, MBeanInfo mbeanInfo) {
            this.client = J4pClient.url((String)serviceURL).user(username).password(password).connectionTimeout(3000).build();
            this.classLoader = classLoader;
            this.objectName = objectName;
            for (MBeanAttributeInfo mBeanAttributeInfo : mbeanInfo.getAttributes()) {
                this.attributes.put(mBeanAttributeInfo.getName(), mBeanAttributeInfo);
            }
            for (MBeanFeatureInfo mBeanFeatureInfo : mbeanInfo.getOperations()) {
                this.operations.add((MBeanOperationInfo)mBeanFeatureInfo);
            }
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                if (this.isGetter(method)) {
                    String attname = this.getAttributeName(method);
                    J4pReadRequest readReq = new J4pReadRequest(this.objectName, new String[]{attname});
                    Object result = this.client.execute((J4pRequest)readReq).getValue();
                    return this.unmarshalResult(method, result);
                }
                if (this.isSetter(method)) {
                    String attname = this.getAttributeName(method);
                    Object[] params = this.marshalParameters(method, args);
                    J4pWriteRequest writeReq = new J4pWriteRequest(this.objectName, attname, (Object)params, new String[0]);
                    writeReq.setPreferredHttpMethod("POST");
                    this.client.execute((J4pRequest)writeReq);
                    return null;
                }
                Object[] params = this.marshalParameters(method, args);
                String operation = this.getOperationInfo(method).getName();
                J4pExecRequest execReq = new J4pExecRequest(this.objectName, operation, params);
                execReq.setPreferredHttpMethod("POST");
                Object result = this.client.execute((J4pRequest)execReq).getValue();
                return this.unmarshalResult(method, result);
            }
            catch (Throwable th) {
                LOGGER.error("Proxy invocation error on: " + method.getDeclaringClass().getName() + "." + method.getName(), th);
                throw th;
            }
        }

        private Object[] marshalParameters(Method method, Object[] params) throws OpenDataException {
            Object[] result = new Object[params.length];
            if (this.isSetter(method)) {
                String attname = this.getAttributeName(method);
                MBeanAttributeInfo attInfo = this.attributes.get(attname);
                if (attInfo instanceof OpenMBeanAttributeInfo) {
                    Object jsonAware;
                    OpenType<?> openType = ((OpenMBeanAttributeInfo)((Object)attInfo)).getOpenType();
                    Object openData = OpenTypeGenerator.toOpenData(openType, params[0]);
                    result[0] = jsonAware = JSONTypeGenerator.toJSON(openData);
                } else {
                    Object jsonAware;
                    result[0] = jsonAware = JSONTypeGenerator.toJSON(params[0]);
                }
            } else {
                MBeanOperationInfo opinfo = this.getOperationInfo(method);
                MBeanParameterInfo[] signature = opinfo.getSignature();
                for (int i = 0; i < params.length; ++i) {
                    Object jsonAware;
                    MBeanParameterInfo paramInfo = signature[i];
                    if (paramInfo instanceof OpenMBeanParameterInfo) {
                        Object jsonAware2;
                        OpenType<?> openType = ((OpenMBeanParameterInfo)((Object)paramInfo)).getOpenType();
                        Object openData = OpenTypeGenerator.toOpenData(openType, params[i]);
                        result[i] = jsonAware2 = JSONTypeGenerator.toJSON(openData);
                        continue;
                    }
                    result[i] = jsonAware = JSONTypeGenerator.toJSON(params[i]);
                }
            }
            return result;
        }

        private MBeanOperationInfo getOperationInfo(Method method) {
            MBeanOperationInfo result = null;
            for (MBeanOperationInfo opinfo : this.operations) {
                MBeanParameterInfo[] signature = opinfo.getSignature();
                if (!opinfo.getName().equals(method.getName()) || signature.length != method.getParameterTypes().length) continue;
                result = opinfo;
                break;
            }
            IllegalStateAssertion.assertNotNull(result, (String)("Cannot find MBeanOperationInfo for: " + method));
            return result;
        }

        private Object unmarshalResult(Method method, Object value) throws OpenDataException {
            if (value == null) {
                return null;
            }
            OpenType<?> openType = null;
            if (this.isGetter(method)) {
                String attname = this.getAttributeName(method);
                MBeanAttributeInfo attInfo = this.attributes.get(attname);
                if (attInfo instanceof OpenMBeanAttributeInfo) {
                    openType = ((OpenMBeanAttributeInfo)((Object)attInfo)).getOpenType();
                }
            } else {
                MBeanOperationInfo opinfo = this.getOperationInfo(method);
                if (opinfo instanceof OpenMBeanOperationInfo) {
                    openType = ((OpenMBeanOperationInfo)((Object)opinfo)).getReturnOpenType();
                }
            }
            if (value instanceof JSONAware) {
                value = JSONTypeGenerator.toOpenData(openType, this.classLoader, (JSONAware)value);
            }
            if (openType != null) {
                value = OpenTypeGenerator.fromOpenData(openType, this.classLoader, value);
            }
            return OpenTypeGenerator.toTargetType(method.getReturnType(), value);
        }

        private boolean isGetter(Method method) {
            String methodName = method.getName();
            Class<?>[] paramTypes = method.getParameterTypes();
            Class<?> returnType = method.getReturnType();
            return Modifier.isPublic(method.getModifiers()) && returnType != Void.TYPE && (methodName.startsWith("get") || methodName.startsWith("is")) && paramTypes.length == 0;
        }

        private boolean isSetter(Method method) {
            String methodName = method.getName();
            Class<?>[] paramTypes = method.getParameterTypes();
            Class<?> returnType = method.getReturnType();
            return Modifier.isPublic(method.getModifiers()) && returnType == Void.TYPE && methodName.startsWith("set") && paramTypes.length == 1;
        }

        private String getAttributeName(Method method) {
            String methodName = method.getName();
            return methodName.startsWith("is") ? methodName.substring(2) : methodName.substring(3);
        }
    }
}

