/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jolokia.client;

import io.fabric8.api.gravia.IllegalStateAssertion;
import java.beans.ConstructorProperties;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

public final class OpenTypeGenerator {
    private OpenTypeGenerator() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object toOpenData(OpenType<?> otype, Object value) throws OpenDataException {
        Object result;
        if (value != null && !otype.isValue(value)) {
            if (otype instanceof CompositeType) {
                result = OpenTypeGenerator.toCompositeData((CompositeType)otype, value);
            } else if (otype instanceof TabularType) {
                result = OpenTypeGenerator.toTabularData((TabularType)otype, (Map)value);
            } else if (otype instanceof ArrayType) {
                result = OpenTypeGenerator.toArrayData((ArrayType)otype, value);
            } else {
                if (otype != SimpleType.BYTE || !(value instanceof Number)) throw new OpenDataException("Unsupported open type: " + otype);
                result = Byte.parseByte(value.toString());
            }
        } else {
            result = value;
        }
        boolean isAssignable = result == null || otype.isValue(result);
        IllegalStateAssertion.assertTrue((Boolean)isAssignable, (String)("Value " + result + " is not a value of: " + otype));
        return result;
    }

    private static TabularData toTabularData(TabularType ttype, Map<?, ?> value) throws OpenDataException {
        TabularDataSupport tdata = new TabularDataSupport(ttype);
        CompositeType rowType = ttype.getRowType();
        OpenType<?> keyType = rowType.getType("key");
        OpenType<?> valueType = rowType.getType("value");
        for (Map.Entry<?, ?> entry : value.entrySet()) {
            HashMap<String, Object> rowData = new HashMap<String, Object>();
            Object keyData = OpenTypeGenerator.toOpenData(keyType, entry.getKey());
            Object valData = OpenTypeGenerator.toOpenData(valueType, entry.getValue());
            rowData.put("key", keyData);
            rowData.put("value", valData);
            tdata.put(OpenTypeGenerator.toCompositeData(rowType, rowData));
        }
        return tdata;
    }

    static Object toArrayData(ArrayType<?> atype, Object value) throws OpenDataException {
        List<Object> items = value instanceof Collection ? new ArrayList((Collection)value) : Arrays.asList(value);
        Object array = OpenTypeGenerator.getOpenTypeArray(atype, ClassLoader.getSystemClassLoader(), items.size());
        OpenType<?> elementType = atype.getElementOpenType();
        for (int i = 0; i < items.size(); ++i) {
            Object val = OpenTypeGenerator.toOpenData(elementType, items.get(i));
            Array.set(array, i, val);
        }
        return array;
    }

    private static Object getterValue(Object bean, OpenType<?> itemType, String itemName) throws OpenDataException {
        try {
            Method method = null;
            Class<?> beanClass = bean.getClass();
            String prefix = itemType == SimpleType.BOOLEAN ? "is" : "get";
            String methodName = prefix + itemName.substring(0, 1).toUpperCase() + itemName.substring(1);
            for (Method aux : beanClass.getMethods()) {
                if (!methodName.equals(aux.getName()) || aux.getParameterTypes().length != 0) continue;
                method = aux;
                break;
            }
            IllegalStateAssertion.assertNotNull((Object)method, (String)("Cannot find getter: " + beanClass.getName() + "." + methodName));
            return method.invoke(bean, (Object[])null);
        }
        catch (Exception ex) {
            OpenDataException odex = new OpenDataException("Cannot invoke getter for: " + itemName);
            odex.initCause(ex);
            throw odex;
        }
    }

    public static Object fromOpenData(OpenType<?> otype, ClassLoader classLoader, Object value) throws OpenDataException {
        Object result;
        if (value == null) {
            return null;
        }
        if (otype instanceof CompositeType) {
            result = OpenTypeGenerator.fromCompositeData(classLoader, (CompositeData)value);
        } else if (otype instanceof TabularType) {
            result = OpenTypeGenerator.fromTabularData(classLoader, (TabularData)value);
        } else if (otype instanceof ArrayType) {
            result = OpenTypeGenerator.fromArrayData((ArrayType)otype, classLoader, value);
        } else if (otype instanceof SimpleType) {
            result = value;
        } else {
            throw new OpenDataException("Unsupported open type: " + otype);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private static Object fromCompositeData(ClassLoader classLoader, CompositeData cdata) throws OpenDataException {
        Map<Object, Object> result;
        if (cdata == null) {
            return null;
        }
        CompositeType ctype = cdata.getCompositeType();
        String typeName = ctype.getTypeName();
        if (typeName.startsWith("java.util.Map")) {
            Object openKey = cdata.get("key");
            Object openVal = cdata.get("value");
            OpenType<?> keyType = ctype.getType("key");
            OpenType<?> valType = ctype.getType("value");
            Object key = OpenTypeGenerator.fromOpenData(keyType, classLoader, openKey);
            Object value = OpenTypeGenerator.fromOpenData(valType, classLoader, openVal);
            result = Collections.singletonMap(key, value);
        } else {
            Class<?> targetType;
            try {
                targetType = classLoader.loadClass(typeName);
            }
            catch (ClassNotFoundException ex) {
                OpenDataException odex = new OpenDataException("Cannot load target type: " + typeName);
                odex.initCause(ex);
                throw odex;
            }
            Constructor<?> ctor = null;
            boolean isDefaultCtor = false;
            for (Constructor<?> aux : targetType.getConstructors()) {
                boolean bl = isDefaultCtor = aux.getParameterTypes().length == 0;
                if (isDefaultCtor) {
                    ctor = aux;
                    break;
                }
                if (aux.getAnnotation(ConstructorProperties.class) == null) continue;
                ctor = aux;
            }
            IllegalStateAssertion.assertNotNull(ctor, (String)("Cannot mxbean compliant constructor for: " + targetType.getName()));
            try {
                if (isDefaultCtor) {
                    result = ctor.newInstance(null);
                    for (String key : ctype.keySet()) {
                        OpenType<?> itemType = ctype.getType(key);
                        Object itemValue = cdata.get(key);
                        Object object = OpenTypeGenerator.fromOpenData(itemType, classLoader, itemValue);
                        OpenTypeGenerator.invokeSetter(result, key, object);
                    }
                } else {
                    void var12_30;
                    ArrayList<Object> params = new ArrayList<Object>();
                    ConstructorProperties props = ctor.getAnnotation(ConstructorProperties.class);
                    String[] arr$ = props.value();
                    int len$ = arr$.length;
                    boolean bl = false;
                    while (var12_30 < len$) {
                        String key = arr$[var12_30];
                        OpenType<?> itemType = ctype.getType(key);
                        Object itemValue = cdata.get(key);
                        Object javaValue = OpenTypeGenerator.fromOpenData(itemType, classLoader, itemValue);
                        params.add(javaValue);
                        ++var12_30;
                    }
                    Class<?>[] paramTypes = ctor.getParameterTypes();
                    for (Object e : params) {
                        int index = params.indexOf(e);
                        Class<?> paramType = paramTypes[index];
                        Object object = OpenTypeGenerator.toTargetType(paramType, e);
                        if (object == params.get(index)) continue;
                        params.set(index, object);
                    }
                    result = ctor.newInstance(params.toArray());
                }
            }
            catch (Exception ex) {
                OpenDataException odex = new OpenDataException("Cannot construct object from: " + cdata);
                odex.initCause(ex);
                throw odex;
            }
        }
        return result;
    }

    private static Map<?, ?> fromTabularData(ClassLoader classLoader, TabularData tdata) throws OpenDataException {
        LinkedHashMap result = new LinkedHashMap();
        if (tdata != null) {
            for (CompositeData cdata : tdata.values()) {
                Map rowValue = (Map)OpenTypeGenerator.fromCompositeData(classLoader, cdata);
                result.putAll(rowValue);
            }
        }
        return result;
    }

    private static Object fromArrayData(ArrayType<?> atype, ClassLoader classLoader, Object value) throws OpenDataException {
        Object array;
        OpenType<?> elementType = atype.getElementOpenType();
        if (value == null) {
            array = OpenTypeGenerator.getJavaTypeArray(atype, classLoader, 0);
        } else if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            array = OpenTypeGenerator.getJavaTypeArray(atype, classLoader, length);
            for (int i = 0; i < length; ++i) {
                Object val = Array.get(value, i);
                val = OpenTypeGenerator.fromOpenData(elementType, classLoader, val);
                Array.set(array, i, val);
            }
        } else if (value instanceof Collection) {
            ArrayList list = new ArrayList((Collection)value);
            array = OpenTypeGenerator.getJavaTypeArray(atype, classLoader, list.size());
            for (int i = 0; i < list.size(); ++i) {
                Object val = list.get(i);
                val = OpenTypeGenerator.fromOpenData(elementType, classLoader, val);
                Array.set(array, i, val);
            }
        } else {
            throw new IllegalArgumentException("Unsupported value type: " + value);
        }
        return array;
    }

    private static void invokeSetter(Object target, String itemName, Object value) throws OpenDataException {
        try {
            Method method = null;
            Class<?> beanClass = target.getClass();
            String methodName = "set" + itemName.substring(0, 1).toUpperCase() + itemName.substring(1);
            for (Method aux : beanClass.getMethods()) {
                if (!methodName.equals(aux.getName()) || aux.getParameterTypes().length != 1) continue;
                method = aux;
                break;
            }
            IllegalStateAssertion.assertNotNull(method, (String)("Cannot find setter: " + beanClass.getName() + "." + methodName));
            Class<?> paramType = method.getParameterTypes()[0];
            value = OpenTypeGenerator.toTargetType(paramType, value);
            method.invoke(target, value);
        }
        catch (Exception ex) {
            OpenDataException odex = new OpenDataException("Cannot invoke setter for: " + itemName);
            odex.initCause(ex);
            throw odex;
        }
    }

    static CompositeData toCompositeData(CompositeType ctype, Object value) throws OpenDataException {
        HashMap<String, Object> items = new HashMap<String, Object>();
        for (String key : ctype.keySet()) {
            OpenType<?> itemType = ctype.getType(key);
            Object rawValue = value instanceof Map ? ((Map)value).get(key) : OpenTypeGenerator.getterValue(value, itemType, key);
            Object openValue = OpenTypeGenerator.toOpenData(itemType, rawValue);
            items.put(key, openValue);
        }
        return new CompositeDataSupport(ctype, items);
    }

    static Object getOpenTypeArray(ArrayType<?> atype, ClassLoader classLoader, int dimension) throws OpenDataException {
        Class<Object> compType;
        OpenType<?> elementType = atype.getElementOpenType();
        try {
            compType = atype.isPrimitiveArray() ? Class.forName(atype.getTypeName()).getComponentType() : (elementType instanceof CompositeType ? CompositeData.class : (elementType instanceof TabularType ? TabularData.class : classLoader.loadClass(elementType.getTypeName())));
        }
        catch (ClassNotFoundException ex) {
            OpenDataException odex = new OpenDataException("Cannot load array type: " + atype);
            odex.initCause(ex);
            throw odex;
        }
        return Array.newInstance(compType, dimension);
    }

    static Object getJavaTypeArray(ArrayType<?> atype, ClassLoader classLoader, int dimension) throws OpenDataException {
        Class<?> compType;
        OpenType<?> elementType = atype.getElementOpenType();
        try {
            compType = atype.isPrimitiveArray() ? Class.forName(atype.getTypeName()).getComponentType() : classLoader.loadClass(elementType.getTypeName());
        }
        catch (ClassNotFoundException ex) {
            OpenDataException odex = new OpenDataException("Cannot load array type: " + atype);
            odex.initCause(ex);
            throw odex;
        }
        return Array.newInstance(compType, dimension);
    }

    static Object toTargetType(Class<?> targetType, Object value) {
        if (value == null || targetType.isPrimitive() || targetType.isAssignableFrom(value.getClass())) {
            return value;
        }
        AbstractCollection result = value;
        if (value.getClass().isArray()) {
            if (targetType == List.class) {
                result = new ArrayList<Object>(Arrays.asList((Object[])value));
            } else if (targetType == Set.class) {
                result = new HashSet<Object>(Arrays.asList((Object[])value));
            }
        }
        boolean isAssignable = targetType.isAssignableFrom(result.getClass());
        IllegalStateAssertion.assertTrue((Boolean)isAssignable, (String)("Value '" + value + "' not assignable to: " + targetType.getName()));
        return result;
    }
}

