/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.detector;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import org.jolokia.backend.executor.MBeanServerExecutor;
import org.jolokia.detector.AbstractServerDetector;
import org.jolokia.detector.ServerHandle;
import org.jolokia.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossDetector
extends AbstractServerDetector {
    @Override
    public ServerHandle detect(MBeanServerExecutor pMBeanServerExecutor) {
        String version;
        if (ClassUtil.checkForClass("org.jboss.mx.util.MBeanServerLocator") && (version = this.getVersionFromJsr77(pMBeanServerExecutor)) != null) {
            int idx = version.indexOf(32);
            if (idx >= 0) {
                version = version.substring(0, idx);
            }
            return new JBossServerHandle(version, null, null);
        }
        if (this.mBeanExists(pMBeanServerExecutor, "jboss.system:type=Server")) {
            String versionFull = this.getAttributeValue(pMBeanServerExecutor, "jboss.system:type=Server", "Version");
            String version2 = null;
            if (versionFull != null) {
                version2 = versionFull.replaceAll("\\(.*", "").trim();
            }
            return new JBossServerHandle(version2, null, null);
        }
        version = this.getSingleStringAttribute(pMBeanServerExecutor, "jboss.as:management-root=server", "releaseVersion");
        if (version != null) {
            return new JBossServerHandle(version, null, null);
        }
        if (this.mBeanExists(pMBeanServerExecutor, "jboss.modules:*")) {
            return new JBossServerHandle("7", null, null);
        }
        return null;
    }

    @Override
    public void addMBeanServers(Set<MBeanServerConnection> servers) {
        try {
            Class<?> locatorClass = Class.forName("org.jboss.mx.util.MBeanServerLocator");
            Method method = locatorClass.getMethod("locateJBoss", new Class[0]);
            servers.add((MBeanServer)method.invoke(null, new Object[0]));
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JBossServerHandle
    extends ServerHandle {
        JBossServerHandle(String version, URL agentUrl, Map<String, String> extraInfo) {
            super("RedHat", "jboss", version, agentUrl, extraInfo);
        }
    }
}

