/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.history;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jolokia.history.HistoryEntry;
import org.jolokia.history.HistoryKey;
import org.jolokia.history.HistoryLimit;
import org.jolokia.request.JmxExecRequest;
import org.jolokia.request.JmxReadRequest;
import org.jolokia.request.JmxRequest;
import org.jolokia.request.JmxWriteRequest;
import org.jolokia.util.RequestType;
import org.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryStore
implements Serializable {
    private static final long serialVersionUID = 42L;
    private int globalMaxEntries;
    private Map<HistoryKey, HistoryEntry> historyStore;
    private Map<HistoryKey, HistoryLimit> patterns;
    private static final String KEY_HISTORY = "history";
    private static final String KEY_VALUE = "value";
    private static final String KEY_TIMESTAMP = "timestamp";
    private Map<RequestType, HistoryUpdater> historyUpdaters = new HashMap<RequestType, HistoryUpdater>();

    public HistoryStore(int pTotalMaxEntries) {
        this.globalMaxEntries = pTotalMaxEntries;
        this.historyStore = new HashMap<HistoryKey, HistoryEntry>();
        this.patterns = new HashMap<HistoryKey, HistoryLimit>();
        this.initHistoryUpdaters();
    }

    public synchronized int getGlobalMaxEntries() {
        return this.globalMaxEntries;
    }

    public synchronized void setGlobalMaxEntries(int pGlobalMaxEntries) {
        this.globalMaxEntries = pGlobalMaxEntries;
        for (HistoryEntry entry : this.historyStore.values()) {
            entry.setMaxEntries(this.globalMaxEntries);
        }
    }

    public synchronized void configure(HistoryKey pKey, HistoryLimit pHistoryLimit) {
        if (pHistoryLimit == null) {
            this.removeEntries(pKey);
            return;
        }
        HistoryLimit limit = pHistoryLimit.respectGlobalMaxEntries(this.globalMaxEntries);
        if (pKey.isMBeanPattern()) {
            this.patterns.put(pKey, limit);
            for (HistoryKey key : this.historyStore.keySet()) {
                if (!pKey.matches(key)) continue;
                HistoryEntry entry = this.historyStore.get(key);
                entry.setLimit(limit);
            }
        } else {
            HistoryEntry entry = this.historyStore.get(pKey);
            if (entry != null) {
                entry.setLimit(limit);
            } else {
                entry = new HistoryEntry(limit);
                this.historyStore.put(pKey, entry);
            }
        }
    }

    public synchronized void reset() {
        this.historyStore = new HashMap<HistoryKey, HistoryEntry>();
        this.patterns = new HashMap<HistoryKey, HistoryLimit>();
    }

    public synchronized void updateAndAdd(JmxRequest pJmxReq, JSONObject pJson) {
        long timestamp = System.currentTimeMillis() / 1000L;
        pJson.put(KEY_TIMESTAMP, timestamp);
        RequestType type = pJmxReq.getType();
        HistoryUpdater updater = this.historyUpdaters.get((Object)type);
        if (updater != null) {
            updater.updateHistory(pJson, pJmxReq, timestamp);
        }
    }

    public synchronized int getSize() {
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            ObjectOutputStream oOut = new ObjectOutputStream(bOut);
            oOut.writeObject(this.historyStore);
            bOut.close();
            return bOut.size();
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot serialize internal store: " + e, e);
        }
    }

    private void initHistoryUpdaters() {
        this.historyUpdaters.put(RequestType.EXEC, new HistoryUpdater<JmxExecRequest>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateHistory(JSONObject pJson, JmxExecRequest request, long pTimestamp) {
                HistoryEntry entry = (HistoryEntry)HistoryStore.this.historyStore.get(new HistoryKey(request));
                if (entry != null) {
                    HistoryEntry historyEntry = entry;
                    synchronized (historyEntry) {
                        pJson.put(HistoryStore.KEY_HISTORY, entry.jsonifyValues());
                        entry.add(pJson.get(HistoryStore.KEY_VALUE), pTimestamp);
                    }
                }
            }
        });
        this.historyUpdaters.put(RequestType.WRITE, new HistoryUpdater<JmxWriteRequest>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateHistory(JSONObject pJson, JmxWriteRequest request, long pTimestamp) {
                HistoryEntry entry = (HistoryEntry)HistoryStore.this.historyStore.get(new HistoryKey(request));
                if (entry != null) {
                    HistoryEntry historyEntry = entry;
                    synchronized (historyEntry) {
                        pJson.put(HistoryStore.KEY_HISTORY, entry.jsonifyValues());
                        entry.add(request.getValue(), pTimestamp);
                    }
                }
            }
        });
        this.historyUpdaters.put(RequestType.READ, new HistoryUpdater<JmxReadRequest>(){

            @Override
            public void updateHistory(JSONObject pJson, JmxReadRequest request, long pTimestamp) {
                HistoryStore.this.updateReadHistory(request, pJson, pTimestamp);
            }
        });
    }

    private void removeEntries(HistoryKey pKey) {
        if (pKey.isMBeanPattern()) {
            this.patterns.remove(pKey);
            ArrayList<HistoryKey> toRemove = new ArrayList<HistoryKey>();
            for (HistoryKey key : this.historyStore.keySet()) {
                if (!pKey.matches(key)) continue;
                toRemove.add(key);
            }
            for (HistoryKey key : toRemove) {
                this.historyStore.remove(key);
            }
        } else {
            HistoryEntry entry = this.historyStore.get(pKey);
            if (entry != null) {
                this.historyStore.remove(pKey);
            }
        }
    }

    private void updateReadHistory(JmxReadRequest pJmxReq, JSONObject pJson, long pTimestamp) {
        ObjectName name = pJmxReq.getObjectName();
        if (name.isPattern()) {
            JSONObject history = new JSONObject();
            for (Map.Entry beanEntry : ((Map)pJson.get(KEY_VALUE)).entrySet()) {
                String beanName = (String)beanEntry.getKey();
                JSONObject beanHistory = this.addAttributesFromComplexValue(pJmxReq, (Map)beanEntry.getValue(), beanName, pTimestamp);
                if (beanHistory.size() <= 0) continue;
                history.put(beanName, beanHistory);
            }
            if (history.size() > 0) {
                pJson.put(KEY_HISTORY, history);
            }
        } else if (pJmxReq.isMultiAttributeMode() || !pJmxReq.hasAttribute()) {
            JSONObject history = this.addAttributesFromComplexValue(pJmxReq, (Map)pJson.get(KEY_VALUE), pJmxReq.getObjectNameAsString(), pTimestamp);
            if (history.size() > 0) {
                pJson.put(KEY_HISTORY, history);
            }
        } else {
            this.addAttributeFromSingleValue(pJson, KEY_HISTORY, new HistoryKey(pJmxReq), pJson.get(KEY_VALUE), pTimestamp);
        }
    }

    private JSONObject addAttributesFromComplexValue(JmxRequest pJmxReq, Map<String, Object> pAttributesMap, String pBeanName, long pTimestamp) {
        JSONObject ret = new JSONObject();
        for (Map.Entry<String, Object> attrEntry : pAttributesMap.entrySet()) {
            HistoryKey key;
            String attrName = attrEntry.getKey();
            Object value = attrEntry.getValue();
            try {
                String target = pJmxReq.getTargetConfig() != null ? pJmxReq.getTargetConfig().getUrl() : null;
                key = new HistoryKey(pBeanName, attrName, null, target);
            }
            catch (MalformedObjectNameException e) {
                throw new IllegalArgumentException("Cannot parse MBean name " + pBeanName, e);
            }
            this.addAttributeFromSingleValue(ret, attrName, key, value, pTimestamp);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAttributeFromSingleValue(JSONObject pHistMap, String pAttrName, HistoryKey pKey, Object pValue, long pTimestamp) {
        HistoryEntry entry = this.getEntry(pKey, pValue, pTimestamp);
        if (entry != null) {
            HistoryEntry historyEntry = entry;
            synchronized (historyEntry) {
                pHistMap.put(pAttrName, entry.jsonifyValues());
                entry.add(pValue, pTimestamp);
            }
        }
    }

    private HistoryEntry getEntry(HistoryKey pKey, Object pValue, long pTimestamp) {
        HistoryEntry entry = this.historyStore.get(pKey);
        if (entry != null) {
            return entry;
        }
        for (HistoryKey key : this.patterns.keySet()) {
            if (!key.matches(pKey)) continue;
            entry = new HistoryEntry(this.patterns.get(key));
            entry.add(pValue, pTimestamp);
            this.historyStore.put(pKey, entry);
            return entry;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface HistoryUpdater<R extends JmxRequest> {
        public void updateHistory(JSONObject var1, R var2, long var3);
    }
}

