/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jolokia;

import io.fabric8.utils.Base64Encoder;
import java.io.IOException;
import java.net.URL;
import java.security.Principal;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AccountException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.http.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JolokiaSecureHttpContext
implements HttpContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(JolokiaSecureHttpContext.class);
    private static final String HEADER_WWW_AUTHENTICATE = "WWW-Authenticate";
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String AUTHENTICATION_SCHEME_BASIC = "Basic";
    private final String realm;
    private final String[] roles;

    JolokiaSecureHttpContext(String realm, String[] role) {
        this.realm = realm;
        this.roles = role;
    }

    public URL getResource(String name) {
        return null;
    }

    public String getMimeType(String name) {
        return null;
    }

    public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) {
        return this.authenticate(request, response);
    }

    private Subject doAuthenticate(final String username, final String password) {
        try {
            Subject subject = new Subject();
            LoginContext loginContext = new LoginContext(this.realm, subject, new CallbackHandler(){

                @Override
                public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                    for (int i = 0; i < callbacks.length; ++i) {
                        if (callbacks[i] instanceof NameCallback) {
                            ((NameCallback)callbacks[i]).setName(username);
                            continue;
                        }
                        if (callbacks[i] instanceof PasswordCallback) {
                            ((PasswordCallback)callbacks[i]).setPassword(password.toCharArray());
                            continue;
                        }
                        throw new UnsupportedCallbackException(callbacks[i]);
                    }
                }
            });
            loginContext.login();
            boolean found = false;
            block3: for (String role : this.roles) {
                if (role == null || role.length() <= 0 || found) continue;
                String roleName = role;
                int idx = roleName.indexOf(58);
                if (idx > 0) {
                    roleName = roleName.substring(idx + 1);
                }
                for (Principal p : subject.getPrincipals()) {
                    if (!p.getName().equals(roleName)) continue;
                    found = true;
                    continue block3;
                }
            }
            if (!found) {
                throw new FailedLoginException("User does not have the required role " + this.roles);
            }
            return subject;
        }
        catch (AccountException e) {
            LOGGER.warn("Account failure", (Throwable)e);
            return null;
        }
        catch (LoginException e) {
            LOGGER.debug("Login failed", (Throwable)e);
            return null;
        }
    }

    public boolean authenticate(HttpServletRequest request, HttpServletResponse response) {
        int blank;
        String authHeader = request.getHeader(HEADER_AUTHORIZATION);
        if (authHeader != null && authHeader.length() > 0 && (blank = (authHeader = authHeader.trim()).indexOf(32)) > 0) {
            String authType = authHeader.substring(0, blank);
            String authInfo = authHeader.substring(blank).trim();
            if (authType.equalsIgnoreCase(AUTHENTICATION_SCHEME_BASIC)) {
                try {
                    String srcString = JolokiaSecureHttpContext.base64Decode(authInfo);
                    int i = srcString.indexOf(58);
                    String username = srcString.substring(0, i);
                    String password = srcString.substring(i + 1);
                    Subject subject = this.doAuthenticate(username, password);
                    if (subject != null) {
                        request.setAttribute("org.osgi.service.http.authentication.type", (Object)"BASIC");
                        request.setAttribute("org.osgi.service.http.authentication.remote.user", (Object)username);
                        request.setAttribute("org.jolokia.jaasSubject", (Object)subject);
                        return true;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        try {
            response.setHeader(HEADER_WWW_AUTHENTICATE, "Basic realm=\"" + this.realm + "\"");
            response.setStatus(401);
            response.setContentLength(0);
            response.flushBuffer();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return false;
    }

    private static String base64Decode(String srcString) {
        return Base64Encoder.decode(srcString);
    }

    public String getRealm() {
        return this.realm;
    }

    public String[] getRole() {
        return this.roles;
    }

    public String toString() {
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        return this.getClass().getSimpleName() + "{" + bundle.getSymbolicName() + " - " + bundle.getBundleId() + "}";
    }
}

