/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jolokia;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jolokia.config.ConfigKey;
import org.jolokia.config.Configuration;
import org.jolokia.restrictor.AllowAllRestrictor;
import org.jolokia.restrictor.DenyAllRestrictor;
import org.jolokia.restrictor.Restrictor;
import org.jolokia.restrictor.RestrictorFactory;
import org.jolokia.util.HttpMethod;
import org.jolokia.util.NetworkUtil;
import org.jolokia.util.RequestType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RBACRestrictor
implements Restrictor {
    private static final Logger LOG = LoggerFactory.getLogger(RBACRestrictor.class);
    protected Restrictor delegate;
    protected MBeanServer mBeanServer;
    protected ObjectName securityMBean;

    public RBACRestrictor(Configuration config) {
        this(NetworkUtil.replaceExpression(config.get(ConfigKey.POLICY_LOCATION)));
    }

    public RBACRestrictor(String policyLocation) {
        this.initDelegate(policyLocation);
        this.initSecurityMBean();
    }

    protected void initDelegate(String policyLocation) {
        try {
            this.delegate = RestrictorFactory.lookupPolicyRestrictor(policyLocation);
            if (this.delegate != null) {
                LOG.debug("Delegate - Using policy access restrictor {}", (Object)policyLocation);
            } else {
                LOG.debug("Delegate - No policy access restrictor found, access to any MBean is allowed");
                this.delegate = new AllowAllRestrictor();
            }
        }
        catch (IOException e) {
            LOG.error("Delegate - Error while accessing access policy restrictor at " + policyLocation + ". Denying all access to MBeans for security reasons. Exception: " + e, (Throwable)e);
            this.delegate = new DenyAllRestrictor();
        }
    }

    protected void initSecurityMBean() {
        this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
        Set<Object> mbeans = new HashSet();
        try {
            mbeans = this.mBeanServer.queryNames(new ObjectName("*:type=security,area=jmx,*"), null);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found JMXSecurity MBeans: {}", mbeans);
            }
        }
        catch (MalformedObjectNameException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        if (mbeans.isEmpty()) {
            LOG.info("Didn't discover any JMXSecurity MBeans, role based access control is disabled");
            this.securityMBean = null;
            return;
        }
        ObjectName chosen = null;
        if (mbeans.size() == 1) {
            chosen = (ObjectName)mbeans.iterator().next();
        } else if (mbeans.size() > 1) {
            for (ObjectName objectName : mbeans) {
                String name = objectName.toString();
                if (name.contains("HawtioDummy") || name.contains("rank=")) continue;
                chosen = objectName;
                break;
            }
        }
        LOG.info("Using MBean [{}] for role based access control", (Object)chosen);
        this.securityMBean = chosen;
    }

    @Override
    public boolean isOperationAllowed(ObjectName objectName, String operation) {
        boolean allowed = this.delegate.isOperationAllowed(objectName, operation);
        if (allowed) {
            try {
                allowed = this.canInvoke(objectName, operation);
            }
            catch (Exception e) {
                LOG.error("Error while invoking JMXSecurity MBean: " + e.getMessage(), (Throwable)e);
                allowed = false;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("isOperationAllowed(objectName = {}, operation = {}) = {}", new Object[]{objectName, operation, allowed});
        }
        return allowed;
    }

    private boolean canInvoke(ObjectName objectName, String operation) throws Exception {
        if (this.securityMBean == null) {
            return true;
        }
        ArrayList<String> argTypes = new ArrayList<String>();
        String opName = this.parseOperation(operation, argTypes);
        Object[] params = new Object[]{objectName.toString(), opName, argTypes.toArray(new String[0])};
        String[] signature = new String[]{String.class.getName(), String.class.getName(), String[].class.getName()};
        try {
            return (Boolean)this.mBeanServer.invoke(this.securityMBean, "canInvoke", params, signature);
        }
        catch (InstanceNotFoundException e) {
            LOG.info("Instance not found: {}", (Object)e.getMessage());
            return false;
        }
        catch (MBeanException e) {
            if (e.getCause() instanceof InstanceNotFoundException) {
                LOG.info("Instance not found: {}", (Object)e.getCause().getMessage());
                return false;
            }
            throw e;
        }
    }

    private String parseOperation(String operation, List<String> argTypes) {
        int index = (operation = operation.trim()).indexOf(40);
        if (index < 0) {
            return operation;
        }
        String args = operation.substring(index + 1, operation.length() - 1);
        for (String arg : args.split(",")) {
            if ("".equals(arg)) continue;
            argTypes.add(arg);
        }
        return operation.substring(0, index);
    }

    @Override
    public boolean isAttributeReadAllowed(ObjectName objectName, String attribute) {
        boolean allowed = this.delegate.isAttributeReadAllowed(objectName, attribute);
        if (allowed) {
            try {
                String accessor = this.resolveAccessor(objectName, attribute, false);
                allowed = this.canInvoke(objectName, accessor);
            }
            catch (Exception e) {
                LOG.error("Error while invoking JMXSecurity MBean: " + e.getMessage(), (Throwable)e);
                allowed = false;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("isAttributeReadAllowed(objectName = {}, attribute = {}) = {}", new Object[]{objectName, attribute, allowed});
        }
        return allowed;
    }

    @Override
    public boolean isAttributeWriteAllowed(ObjectName objectName, String attribute) {
        boolean allowed = this.delegate.isAttributeWriteAllowed(objectName, attribute);
        if (allowed) {
            try {
                String accessor = this.resolveAccessor(objectName, attribute, true);
                allowed = this.canInvoke(objectName, accessor);
            }
            catch (Exception e) {
                LOG.error("Error while invoking JMXSecurity MBean: " + e.getMessage(), (Throwable)e);
                allowed = false;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("isAttributeWriteAllowed(objectName = {}, attribute = {}) = {}", new Object[]{objectName, attribute, allowed});
        }
        return allowed;
    }

    private String resolveAccessor(ObjectName objectName, String attribute, boolean write) throws Exception {
        MBeanInfo mBeanInfo = this.mBeanServer.getMBeanInfo(objectName);
        MBeanAttributeInfo attributeInfo = null;
        for (MBeanAttributeInfo info : mBeanInfo.getAttributes()) {
            if (!info.getName().equals(attribute)) continue;
            attributeInfo = info;
            break;
        }
        if (attributeInfo == null) {
            throw new IllegalArgumentException("Attribute '" + attribute + "' not found for MBean '" + objectName + "'");
        }
        if (write) {
            return String.format("set%s(%s)", attribute, attributeInfo.getType());
        }
        return String.format("%s%s()", attributeInfo.isIs() ? "is" : "get", attribute);
    }

    @Override
    public boolean isHttpMethodAllowed(HttpMethod method) {
        boolean allowed = this.delegate.isHttpMethodAllowed(method);
        if (LOG.isTraceEnabled()) {
            LOG.trace("isHttpMethodAllowed(method = {}) = {}", (Object)method, (Object)allowed);
        }
        return allowed;
    }

    @Override
    public boolean isTypeAllowed(RequestType type) {
        boolean allowed = this.delegate.isTypeAllowed(type);
        if (LOG.isTraceEnabled()) {
            LOG.trace("isTypeAllowed(type = {}) = {}", (Object)type, (Object)allowed);
        }
        return allowed;
    }

    @Override
    public boolean isRemoteAccessAllowed(String ... hostOrAddress) {
        boolean allowed = this.delegate.isRemoteAccessAllowed(hostOrAddress);
        if (LOG.isTraceEnabled()) {
            LOG.trace("isRemoteAccessAllowed(hostOrAddress = {}) = {}", (Object)hostOrAddress, (Object)allowed);
        }
        return allowed;
    }

    @Override
    public boolean isOriginAllowed(String origin, boolean strictCheck) {
        boolean allowed = this.delegate.isOriginAllowed(origin, strictCheck);
        if (LOG.isTraceEnabled()) {
            LOG.trace("isOriginAllowed(origin = {}, strictCheck = {}) = {}", new Object[]{origin, strictCheck, allowed});
        }
        return allowed;
    }
}

