/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client.response;

import com.openshift.internal.client.response.CartridgeResourceProperty;
import com.openshift.internal.client.utils.CollectionUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CartridgeResourceProperties {
    public static final String CONNECTION_URL = "connection_url";
    public static final String JOB_URL = "job_url";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String DATABASE_NAME = "database_name";
    private Map<String, CartridgeResourceProperty> properties = new LinkedHashMap<String, CartridgeResourceProperty>();

    public String getPropertyValue(String name) {
        CartridgeResourceProperty property = this.properties.get(name);
        if (property == null) {
            return null;
        }
        return property.getValue();
    }

    public void add(String name, CartridgeResourceProperty property) {
        this.properties.put(name, property);
    }

    public CartridgeResourceProperty getProperty(String name) {
        return this.properties.get(name);
    }

    public List<CartridgeResourceProperty> getAll() {
        return CollectionUtils.toUnmodifiableCopy(this.properties.values());
    }

    public int size() {
        return this.properties.size();
    }

    public String toString() {
        return "ResourceProperties [ properties=" + this.properties + " ]";
    }
}

