/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.FabricRequirements;
import io.fabric8.api.FabricService;
import io.fabric8.api.ProfileRequirements;
import io.fabric8.commands.support.RequirementsListSupport;
import io.fabric8.utils.TablePrinter;
import java.io.PrintStream;
import java.util.List;
import org.apache.felix.gogo.commands.Command;

@Command(name="require-profile-list", scope="fabric", description="Lists the requirements for profiles in the fabric", detailedDescription="classpath:status.txt")
public class RequireProfileListAction
extends RequirementsListSupport {
    public RequireProfileListAction(FabricService fabricService) {
        super(fabricService);
    }

    @Override
    protected void printRequirements(PrintStream out, FabricRequirements requirements) {
        TablePrinter table = new TablePrinter();
        table.columns("profile", "# minimum", "# maximum", "depends on");
        List profileRequirements = requirements.getProfileRequirements();
        for (ProfileRequirements profile : profileRequirements) {
            table.row(profile.getProfile(), RequireProfileListAction.getStringOrBlank(profile.getMinimumInstances()), RequireProfileListAction.getStringOrBlank(profile.getMaximumInstances()), RequireProfileListAction.getStringOrBlank(profile.getDependentProfiles()));
        }
        table.print();
    }

    public static String getStringOrBlank(Object value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }
}

