/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift;

import com.openshift.client.IApplication;
import com.openshift.client.IDomain;
import com.openshift.client.IOpenShiftConnection;
import com.openshift.client.OpenShiftConnectionFactory;
import io.fabric8.api.Container;
import io.fabric8.api.CreateContainerMetadata;
import io.fabric8.common.util.Maps;
import io.fabric8.openshift.CreateOpenshiftContainerMetadata;
import io.fabric8.openshift.CreateOpenshiftContainerOptions;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class OpenShiftUtils {
    public static boolean isFabricManaged(Map<String, String> openshiftConfiguration) {
        return Maps.booleanValue(openshiftConfiguration, (String)"managed", (boolean)false);
    }

    public static void close(IOpenShiftConnection connection) {
        ExecutorService executorService;
        if (connection != null && (executorService = connection.getExecutorService()) != null) {
            executorService.shutdown();
        }
    }

    public static IOpenShiftConnection createConnection(CreateOpenshiftContainerOptions options) {
        if (options == null) {
            return null;
        }
        String serverUrl = options.getServerUrl();
        String login = options.getLogin();
        String password = options.getPassword();
        return OpenShiftUtils.createConnection(serverUrl, login, password);
    }

    public static IOpenShiftConnection createConnection(String serverUrl, String login, String password) {
        return new OpenShiftConnectionFactory().getConnection("fabric", login, password, serverUrl);
    }

    public static IOpenShiftConnection createConnection(Container container) {
        return OpenShiftUtils.createConnection(OpenShiftUtils.getCreateOptions(container));
    }

    public static CreateOpenshiftContainerOptions getCreateOptions(Container container) {
        CreateOpenshiftContainerMetadata metadata = OpenShiftUtils.getContainerMetadata(container);
        if (metadata == null) {
            return null;
        }
        return (CreateOpenshiftContainerOptions)metadata.getCreateOptions();
    }

    protected static CreateOpenshiftContainerMetadata getContainerMetadata(Container container) {
        CreateContainerMetadata value = container.getMetadata();
        if (value instanceof CreateOpenshiftContainerMetadata) {
            return (CreateOpenshiftContainerMetadata)value;
        }
        return null;
    }

    public static IApplication getApplication(Container container) {
        CreateOpenshiftContainerMetadata metadata = OpenShiftUtils.getContainerMetadata(container);
        if (metadata == null) {
            return null;
        }
        CreateOpenshiftContainerOptions options = (CreateOpenshiftContainerOptions)metadata.getCreateOptions();
        IOpenShiftConnection connection = OpenShiftUtils.createConnection(options);
        String containerName = container.getId();
        IDomain domain = connection.getUser().getDomain(metadata.getDomainId());
        return domain.getApplicationByName(containerName);
    }

    public static IApplication getApplication(Container container, IOpenShiftConnection connection) {
        return OpenShiftUtils.getApplication(container, OpenShiftUtils.getContainerMetadata(container), connection);
    }

    public static IApplication getApplication(Container container, CreateOpenshiftContainerMetadata metadata, IOpenShiftConnection connection) {
        String containerName = container.getId();
        IDomain domain = connection.getUser().getDomain(metadata.getDomainId());
        return domain.getApplicationByName(containerName);
    }
}

