/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.agent;

import io.fabric8.agent.download.DownloadManager;
import io.fabric8.agent.model.Feature;
import io.fabric8.agent.utils.AgentUtils;
import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.Profiles;
import io.fabric8.common.util.Files;
import io.fabric8.common.util.LoggingOutputStream;
import io.fabric8.common.util.Strings;
import io.fabric8.git.internal.GitHelpers;
import io.fabric8.maven.util.MavenRepositoryURL;
import io.fabric8.maven.util.Parser;
import io.fabric8.openshift.agent.OpenShiftPomDeployer;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RefSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class DeploymentUpdater {
    private static final transient Logger LOG = LoggerFactory.getLogger(DeploymentUpdater.class);
    public static final String OPENSHIFT_CONFIG_CATALINA_PROPERTIES = ".openshift/config/catalina.properties";
    private final DownloadManager downloadManager;
    private final FabricService fabricService;
    private final Container container;
    private final String webAppDir;
    private final String deployDir;
    private boolean copyFilesIntoGit = false;
    private String repositories;

    public DeploymentUpdater(DownloadManager downloadManager, FabricService fabricService, Container container, String webAppDir, String deployDir) {
        this.downloadManager = downloadManager;
        this.fabricService = fabricService;
        this.container = container;
        this.webAppDir = webAppDir;
        this.deployDir = deployDir;
    }

    public void updateDeployment(Git git, File baseDir, CredentialsProvider credentials) throws Exception {
        LinkedHashSet<String> bundles = new LinkedHashSet<String>();
        LinkedHashSet<Feature> features = new LinkedHashSet<Feature>();
        Profile overlayProfile = this.container.getOverlayProfile();
        Profile effectiveProfile = Profiles.getEffectiveProfile((FabricService)this.fabricService, (Profile)overlayProfile);
        bundles.addAll(effectiveProfile.getBundles());
        AgentUtils.addFeatures(features, (FabricService)this.fabricService, (DownloadManager)this.downloadManager, (Profile)effectiveProfile);
        if (this.copyFilesIntoGit) {
            this.copyDeploymentsIntoGit(git, baseDir, bundles, features);
        } else {
            this.addDeploymentsIntoPom(git, baseDir, effectiveProfile, bundles, features);
        }
        String message = "updating deployment";
        git.commit().setMessage(message).call();
        this.enableDeployDirectory(git, baseDir);
        String branch = GitHelpers.currentBranch((Git)git);
        LOG.info("Pushing deployment changes to branch " + branch + " credentials " + credentials + " for container " + this.container.getId());
        try {
            Iterable results = ((PushCommand)git.push().setCredentialsProvider(credentials)).setRefSpecs(new RefSpec[]{new RefSpec(branch)}).setOutputStream((OutputStream)new LoggingOutputStream(LOG)).call();
            LOG.info("Pushed deployment changes to branch " + branch + " for container " + this.container.getId());
        }
        catch (GitAPIException e) {
            LOG.error("Failed to push deployment changes to branch " + branch + " for container " + this.container.getId() + ". Reason: " + (Object)((Object)e), (Throwable)e);
        }
    }

    protected void copyDeploymentsIntoGit(Git git, File baseDir, Set<String> bundles, Set<Feature> features) throws Exception {
        List<String> webAppFilesToDelete = this.filesToDelete(baseDir, this.webAppDir);
        List<String> deployDirFilesToDelete = this.filesToDelete(baseDir, this.deployDir);
        LOG.debug("Deploying into container " + this.container.getId() + " features " + features + " and bundles " + bundles);
        Map files = AgentUtils.downloadBundles((DownloadManager)this.downloadManager, features, bundles, Collections.emptySet());
        Set entries = files.entrySet();
        for (Map.Entry entry : entries) {
            String destPath;
            String name = (String)entry.getKey();
            File file = (File)entry.getValue();
            String fileName = file.getName();
            if (name.startsWith("war:") || name.contains("/war/") || fileName.toLowerCase().endsWith(".war")) {
                destPath = this.webAppDir;
                webAppFilesToDelete.remove(fileName);
            } else {
                destPath = this.deployDir;
                deployDirFilesToDelete.remove(fileName);
            }
            if (destPath != null) {
                File destDir = new File(baseDir, destPath);
                destDir.mkdirs();
                File destFile = new File(destDir, fileName);
                LOG.info("Copying file " + fileName + " to :  " + destFile.getCanonicalPath() + " for container " + this.container.getId());
                Files.copy((File)file, (File)destFile);
                git.add().addFilepattern(destPath + "/" + fileName).call();
            }
            this.deleteFiles(git, baseDir, this.webAppDir, webAppFilesToDelete);
            this.deleteFiles(git, baseDir, this.deployDir, deployDirFilesToDelete);
        }
    }

    protected void addDeploymentsIntoPom(Git git, File baseDir, Profile profile, Set<String> bundles, Set<Feature> features) throws SAXException, ParserConfigurationException, XPathExpressionException, IOException, TransformerException, GitAPIException {
        Collection<Parser> artifacts = AgentUtils.getProfileArtifacts((FabricService)this.fabricService, (Profile)profile, bundles, features).values();
        if (artifacts.size() > 0) {
            OpenShiftPomDeployer pomDeployer = new OpenShiftPomDeployer(git, baseDir, this.deployDir, this.webAppDir);
            List<MavenRepositoryURL> repositories = this.parseMavenRepositoryURLs();
            pomDeployer.update(artifacts, repositories);
        }
    }

    protected List<MavenRepositoryURL> parseMavenRepositoryURLs() throws MalformedURLException {
        ArrayList<MavenRepositoryURL> repositories = new ArrayList<MavenRepositoryURL>();
        String text = this.getRepositories();
        if (Strings.isNotBlank((String)text)) {
            StringTokenizer iter = new StringTokenizer(text);
            while (iter.hasMoreTokens()) {
                String url = iter.nextToken();
                if (url.endsWith(",")) {
                    url = url.substring(0, url.length() - 1);
                }
                MavenRepositoryURL mavenUrl = new MavenRepositoryURL(url);
                repositories.add(mavenUrl);
            }
        }
        return repositories;
    }

    protected void enableDeployDirectory(Git git, File baseDir) throws GitAPIException {
        File catalinaProperties = new File(baseDir, OPENSHIFT_CONFIG_CATALINA_PROPERTIES);
        if (catalinaProperties.exists()) {
            Properties properties = new Properties();
            String propertyName = "shared.loader";
            String value = properties.getProperty(propertyName);
            if (Strings.isNotBlank((String)value) && (value.startsWith(this.deployDir + "/") || value.contains(":" + this.deployDir + "/"))) {
                LOG.info("Already has valid " + propertyName + " in " + catalinaProperties + " with value: " + value);
            } else {
                String newValue = this.deployDir + "/*.jar";
                if (Strings.isNotBlank((String)value)) {
                    newValue = newValue + ":" + value;
                }
                LOG.info("Updating " + propertyName + " to " + newValue + " in " + catalinaProperties + " to enable the use of the shared deploy directory: " + this.deployDir);
                try {
                    int propertyNameLength = propertyName.length();
                    List lines = Files.readLines((File)catalinaProperties);
                    int size = lines.size();
                    for (int i = 0; i < size; ++i) {
                        char ch;
                        String line = (String)lines.get(i);
                        if (!line.startsWith(propertyName) || line.length() <= propertyNameLength || !Character.isWhitespace(ch = line.charAt(propertyNameLength)) && ch != '=') continue;
                        String newLine = propertyName + "=" + newValue;
                        lines.set(i, newLine);
                    }
                    Files.writeLines((File)catalinaProperties, (List)lines);
                    git.add().addFilepattern(OPENSHIFT_CONFIG_CATALINA_PROPERTIES).call();
                    String message = "enabled the deploy directory '" + this.deployDir + "' to be on the shared class loader";
                    git.commit().setMessage(message).call();
                    LOG.info("Committed changes to: " + catalinaProperties);
                }
                catch (IOException e) {
                    LOG.warn("Failed to update " + catalinaProperties + " for container " + this.container.getId() + ". " + e, (Throwable)e);
                }
            }
        }
    }

    protected List<String> filesToDelete(File baseDir, String path) {
        String[] list;
        File dir;
        ArrayList<String> answer = new ArrayList<String>();
        if (path != null && (dir = new File(baseDir, path)).exists() && dir.isDirectory() && (list = dir.list()) != null) {
            answer.addAll(Arrays.asList(list));
        }
        return answer;
    }

    protected void deleteFiles(Git git, File baseDir, String path, List<String> fileNames) throws GitAPIException {
        if (path != null) {
            for (String fileName : fileNames) {
                File file = new File(baseDir, path + "/" + fileName);
                if (!file.exists()) continue;
                LOG.debug("Removing " + file + " for container " + this.container.getId());
                git.rm().addFilepattern(path + "/" + fileName).call();
                file.delete();
            }
        }
    }

    public String getWebAppDir() {
        return this.webAppDir;
    }

    public String getDeployDir() {
        return this.deployDir;
    }

    public boolean isCopyFilesIntoGit() {
        return this.copyFilesIntoGit;
    }

    public void setCopyFilesIntoGit(boolean copyFilesIntoGit) {
        this.copyFilesIntoGit = copyFilesIntoGit;
    }

    public String getRepositories() {
        return this.repositories;
    }

    public void setRepositories(String repositories) {
        this.repositories = repositories;
    }
}

