/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.rest;

import io.fabric8.common.util.Files;
import io.fabric8.rest.ProfileResource;
import io.fabric8.rest.ResourceSupport;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.curator.framework.CuratorFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Produces(value={"application/json"})
public class RegistryResource
extends ResourceSupport {
    public static final String FABRIC_ZK_PREFIX = "/fabric/registry/";
    public static final String ROOT_ZK_PREFIX = "/";
    private static final Logger LOG = LoggerFactory.getLogger(RegistryResource.class);
    private final String resourcePathPrefix;
    private final String zkPrefix;

    public RegistryResource(ResourceSupport parentResource, String resourcePathPrefix, String zkPrefix) {
        super(parentResource, resourcePathPrefix);
        this.resourcePathPrefix = resourcePathPrefix;
        this.zkPrefix = zkPrefix;
    }

    @GET
    public Map<String, String> links() {
        String baseUri;
        int idx;
        LinkedHashMap<String, String> links = new LinkedHashMap<String, String>();
        links.put("data", this.getLink("data"));
        links.put("children", this.getLink("children"));
        if (this.zkPrefix.length() > 0 && !ROOT_ZK_PREFIX.equals(this.zkPrefix) && (idx = (baseUri = this.getBaseUri()).lastIndexOf(47)) > 0) {
            String parentLink = baseUri.substring(0, idx);
            links.put("parent", parentLink);
        }
        return links;
    }

    @GET
    @Path(value="children")
    public Map<String, String> list() throws Exception {
        String zkPath = this.toZooKeeperPath("");
        List fileNames = ZooKeeperUtils.getChildrenSafe((CuratorFramework)this.getCurator(), (String)zkPath);
        return this.mapToLinks(fileNames, "child/");
    }

    @Path(value="child/{path}")
    public RegistryResource child(@PathParam(value="path") String path) {
        return new RegistryResource(this, "child/" + path + ROOT_ZK_PREFIX, this.toZooKeeperPath(path) + ROOT_ZK_PREFIX);
    }

    @GET
    @Path(value="data")
    public Response get() throws Exception {
        CuratorFramework curator = this.getCurator();
        if (curator != null) {
            String zkPath = this.toZooKeeperPath("");
            byte[] bytes = ZooKeeperUtils.getData((CuratorFramework)curator, (String)zkPath);
            if (bytes == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("No such ZooKeeper entry for path: " + zkPath)).build();
            }
            String mediaType = RegistryResource.guessMediaTypeWithJsonDefault(zkPath, bytes);
            return Response.ok((Object)bytes, (String)mediaType).build();
        }
        return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)"No ZooKeeper connection").build();
    }

    protected static String guessMediaTypeWithJsonDefault(String path, byte[] bytes) {
        String trimmedText;
        String fileExtension;
        String mediaType = ProfileResource.guessMediaType(path);
        if (mediaType.equals("text/plain") && (fileExtension = Files.getFileExtension((String)path)) == null && ((trimmedText = new String(bytes).trim()).startsWith("[") && trimmedText.endsWith("]") || trimmedText.startsWith("{") && trimmedText.endsWith("}"))) {
            mediaType = "application/json";
        }
        return mediaType;
    }

    protected String toZooKeeperPath(String path) {
        if (path != null) {
            while (path.startsWith(ROOT_ZK_PREFIX)) {
                path = path.substring(1);
            }
        }
        if (path == null || path.length() == 0 || path.equals(ROOT_ZK_PREFIX)) {
            if (this.zkPrefix.endsWith(ROOT_ZK_PREFIX) && this.zkPrefix.length() > 1) {
                return this.zkPrefix.substring(0, this.zkPrefix.length() - 1);
            }
            return this.zkPrefix;
        }
        return this.zkPrefix + path;
    }
}

