/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.rest;

import io.fabric8.api.Container;
import io.fabric8.api.Containers;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.Profiles;
import io.fabric8.api.Version;
import io.fabric8.api.jmx.ContainerDTO;
import io.fabric8.core.jmx.Links;
import java.net.URI;
import java.util.List;

public class FabricDTO {
    private String zookeeperUrl;
    private String currentContainerName;
    private String defaultVersion;
    private String environment;
    private String mavenRepoURI;
    private String mavenRepoUploadURI;
    private String defaultJvmOptions;
    private String containersLink;
    private String versionsLink;
    private String statusLink;
    private String requirementsLink;
    private String registryLink;
    private String zooKeeperLink;

    public FabricDTO(FabricService fabricService, URI baseUri) {
    }

    public FabricDTO(FabricService fabricService) {
        this.zookeeperUrl = fabricService.getZookeeperUrl();
        this.currentContainerName = fabricService.getCurrentContainerName();
        this.defaultVersion = fabricService.getDefaultVersionId();
        this.environment = fabricService.getEnvironment();
        this.mavenRepoURI = FabricDTO.asString(fabricService.getMavenRepoURI());
        this.mavenRepoUploadURI = FabricDTO.asString(fabricService.getMavenRepoUploadURI());
        this.defaultJvmOptions = fabricService.getDefaultJvmOptions();
    }

    public FabricDTO(FabricService fabricService, String containersLink, String versionsLink, String statusLink, String requirementsLink, String registryLink, String zooKeeperLink) {
        this(fabricService);
        this.containersLink = containersLink;
        this.versionsLink = versionsLink;
        this.statusLink = statusLink;
        this.requirementsLink = requirementsLink;
        this.registryLink = registryLink;
        this.zooKeeperLink = zooKeeperLink;
    }

    public static ContainerDTO createContainerDTO(Container container, String baseApiLink) {
        ContainerDTO answer = new ContainerDTO();
        String containerId = container.getId();
        answer.setId(containerId);
        answer.setType(container.getType());
        answer.setChildren(Containers.containerIds((Container[])container.getChildren()));
        List profileIds = Profiles.profileIds((Profile[])container.getProfiles());
        String profileLinkPrefix = baseApiLink + "/version/" + Profiles.versionId((Version)container.getVersion()) + "/profile/";
        answer.setProfiles(Links.mapIdsToLinks((Iterable)profileIds, (String)profileLinkPrefix));
        answer.setVersion(Profiles.versionId((Version)container.getVersion()));
        answer.setParent(Containers.containerId((Container)container.getParent()));
        answer.setIp(container.getIp());
        answer.setLocalIp(container.getLocalIp());
        answer.setManualIp(container.getManualIp());
        answer.setPublicIp(container.getPublicIp());
        answer.setLocalHostName(container.getLocalHostname());
        answer.setPublicHostName(container.getPublicHostname());
        answer.setResolver(container.getResolver());
        answer.setMaximumPort(container.getMaximumPort());
        answer.setMinimumPort(container.getMinimumPort());
        answer.setGeoLocation(container.getGeoLocation());
        answer.setLocation(container.getLocation());
        answer.setProcessId(container.getProcessId());
        answer.setDebugPort(container.getDebugPort());
        answer.setHttpUrl(container.getHttpUrl());
        answer.setJmxUrl(container.getJmxUrl());
        answer.setJolokiaUrl(container.getJolokiaUrl());
        answer.setSshUrl(container.getSshUrl());
        answer.setProvisionException(container.getProvisionException());
        answer.setProvisionResult(container.getProvisionResult());
        answer.setProvisionStatus(container.getProvisionStatus());
        answer.setProvisionList(container.getProvisionList());
        answer.setJmxDomains(container.getJmxDomains());
        answer.setAlive(container.isAlive());
        answer.setAliveAndOK(container.isAliveAndOK());
        answer.setEnsembleServer(container.isEnsembleServer());
        answer.setManaged(container.isManaged());
        answer.setProvisioningComplete(container.isProvisioningComplete());
        answer.setProvisioningPending(container.isProvisioningPending());
        answer.setRoot(container.isRoot());
        answer.setStartLink(baseApiLink + "/container/" + containerId + "/start");
        return answer;
    }

    public String toString() {
        return "FabricDTO{zookeeperUrl='" + this.zookeeperUrl + '\'' + ", currentContainerName='" + this.currentContainerName + '\'' + ", defaultVersion='" + this.defaultVersion + '\'' + ", mavenRepoURI='" + this.mavenRepoURI + '\'' + ", mavenRepoUploadURI='" + this.mavenRepoUploadURI + '\'' + '}';
    }

    public String getZookeeperUrl() {
        return this.zookeeperUrl;
    }

    public void setZookeeperUrl(String zookeeperUrl) {
        this.zookeeperUrl = zookeeperUrl;
    }

    public String getCurrentContainerName() {
        return this.currentContainerName;
    }

    public void setCurrentContainerName(String currentContainerName) {
        this.currentContainerName = currentContainerName;
    }

    public String getDefaultVersion() {
        return this.defaultVersion;
    }

    public void setDefaultVersion(String defaultVersion) {
        this.defaultVersion = defaultVersion;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public String getMavenRepoURI() {
        return this.mavenRepoURI;
    }

    public void setMavenRepoURI(String mavenRepoURI) {
        this.mavenRepoURI = mavenRepoURI;
    }

    public String getMavenRepoUploadURI() {
        return this.mavenRepoUploadURI;
    }

    public void setMavenRepoUploadURI(String mavenRepoUploadURI) {
        this.mavenRepoUploadURI = mavenRepoUploadURI;
    }

    public String getDefaultJvmOptions() {
        return this.defaultJvmOptions;
    }

    public void setDefaultJvmOptions(String defaultJvmOptions) {
        this.defaultJvmOptions = defaultJvmOptions;
    }

    public String getContainersLink() {
        return this.containersLink;
    }

    public void setContainersLink(String containersLink) {
        this.containersLink = containersLink;
    }

    public String getVersionsLink() {
        return this.versionsLink;
    }

    public void setVersionsLink(String versionsLink) {
        this.versionsLink = versionsLink;
    }

    public String getStatusLink() {
        return this.statusLink;
    }

    public void setStatusLink(String statusLink) {
        this.statusLink = statusLink;
    }

    public String getRequirementsLink() {
        return this.requirementsLink;
    }

    public void setRequirementsLink(String requirementsLink) {
        this.requirementsLink = requirementsLink;
    }

    public String getRegistryLink() {
        return this.registryLink;
    }

    public void setRegistryLink(String registryLink) {
        this.registryLink = registryLink;
    }

    public String getZooKeeperLink() {
        return this.zooKeeperLink;
    }

    public void setZooKeeperLink(String zooKeeperLink) {
        this.zooKeeperLink = zooKeeperLink;
    }

    protected static String asString(URI uri) {
        return uri != null ? uri.toString() : null;
    }
}

