/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.utils;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class SerialExecutorService
extends AbstractExecutorService {
    static long THREAD_POOL_KEEP_ALIVE = Integer.getInteger("io.fabric8.utils.THREAD_POOL_KEEP_ALIVE", 5000).intValue();
    static final ThreadGroup group = new ThreadGroup("Fabric Tasks");
    static final Executor threadPool = new Executor(){
        SynchronousQueue<Runnable> queue = new SynchronousQueue();

        @Override
        public void execute(Runnable task) {
            if (task == null) {
                throw new NullPointerException();
            }
            if (!this.queue.offer(task)) {
                new Thread(group, "Fabric Task"){

                    @Override
                    public void run() {
                        while (true) {
                            Runnable task;
                            try {
                                task = queue.poll(THREAD_POOL_KEEP_ALIVE, TimeUnit.MILLISECONDS);
                            }
                            catch (InterruptedException e) {
                                return;
                            }
                            if (task == null) {
                                return;
                            }
                            task.run();
                        }
                    }
                }.start();
                try {
                    this.queue.put(task);
                }
                catch (InterruptedException e) {
                    throw new RejectedExecutionException(e);
                }
            }
        }
    };
    protected Executor target;
    protected volatile String label;
    protected AtomicBoolean shutdown = new AtomicBoolean(false);
    protected AtomicBoolean terminated = new AtomicBoolean(false);
    protected CountDownLatch terminatedLatch = new CountDownLatch(1);
    protected final AtomicBoolean triggered = new AtomicBoolean();
    protected final ConcurrentLinkedQueue<Runnable> externalQueue = new ConcurrentLinkedQueue();
    protected final LinkedList<Runnable> localQueue = new LinkedList();
    protected final ThreadLocal<Boolean> draining = new ThreadLocal();
    protected final Runnable drainTask = new Runnable(){

        @Override
        public void run() {
            SerialExecutorService.this.drain();
        }
    };

    public SerialExecutorService() {
        this("<no-label>");
    }

    public SerialExecutorService(String label) {
        this(threadPool, label);
    }

    public SerialExecutorService(Executor target) {
        this(target, "<no-label>");
    }

    public SerialExecutorService(Executor target, String label) {
        this.target = target;
        this.label = label;
    }

    @Override
    public void execute(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("runnable cannot be null");
        }
        if (this.shutdown.get()) {
            throw new RejectedExecutionException("shutdown");
        }
        if (this.isDraining()) {
            this.localQueue.add(runnable);
        } else {
            this.externalQueue.add(runnable);
            this.triggerDrain();
        }
    }

    public void executeAndDrain(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("runnable cannot be null");
        }
        if (this.shutdown.get()) {
            throw new RejectedExecutionException("shutdown");
        }
        if (this.isDraining()) {
            runnable.run();
        } else {
            this.externalQueue.add(runnable);
            this.drain();
        }
    }

    protected void triggerDrain() {
        if (this.triggered.compareAndSet(false, true)) {
            this.target.execute(this.drainTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void drain() {
        this.draining.set(Boolean.TRUE);
        try {
            boolean drained = false;
            while (!drained) {
                Runnable runnable = this.localQueue.poll();
                if (runnable == null) {
                    runnable = this.externalQueue.poll();
                }
                if (runnable == null) {
                    drained = true;
                    continue;
                }
                try {
                    runnable.run();
                }
                catch (Throwable e) {
                    Thread thread = Thread.currentThread();
                    thread.getUncaughtExceptionHandler().uncaughtException(thread, e);
                }
            }
        }
        finally {
            this.draining.remove();
            this.triggered.set(false);
            if (!this.externalQueue.isEmpty()) {
                this.triggerDrain();
            }
        }
    }

    @Override
    public void shutdown() {
        if (this.shutdown.compareAndSet(false, true)) {
            this.externalQueue.add(new Runnable(){

                @Override
                public void run() {
                    SerialExecutorService.this.terminated.set(true);
                    SerialExecutorService.this.terminatedLatch.countDown();
                }
            });
            this.triggerDrain();
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown();
        return Collections.EMPTY_LIST;
    }

    public boolean isDraining() {
        return this.draining.get() == Boolean.TRUE;
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown.get();
    }

    @Override
    public boolean isTerminated() {
        return this.terminated.get();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.terminatedLatch.await(timeout, unit);
    }

    public String toString() {
        return this.label;
    }

    public Executor getTarget() {
        return this.target;
    }

    public void setTarget(Executor target) {
        this.target = target;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }
}

