/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.http.impl;

import org.vertx.java.core.Handler;
import org.vertx.java.core.MultiMap;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.ServerWebSocket;
import org.vertx.java.core.http.WebSocketFrame;
import org.vertx.java.core.http.impl.WebSocketImplBase;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.net.impl.ConnectionBase;

public class DefaultServerWebSocket
extends WebSocketImplBase<ServerWebSocket>
implements ServerWebSocket {
    private final String uri;
    private final String path;
    private final String query;
    private final Runnable connectRunnable;
    private boolean connected;
    private boolean rejected;
    private final MultiMap headers;

    public DefaultServerWebSocket(VertxInternal vertx, String uri, String path, String query, MultiMap headers, ConnectionBase conn, Runnable connectRunnable) {
        super(vertx, conn);
        this.uri = uri;
        this.path = path;
        this.query = query;
        this.headers = headers;
        this.connectRunnable = connectRunnable;
    }

    @Override
    public String uri() {
        return this.uri;
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public String query() {
        return this.query;
    }

    @Override
    public MultiMap headers() {
        return this.headers;
    }

    @Override
    public ServerWebSocket reject() {
        this.checkClosed();
        if (this.connectRunnable == null) {
            throw new IllegalStateException("Cannot reject websocket on the client side");
        }
        if (this.connected) {
            throw new IllegalStateException("Cannot reject websocket, it has already been written to");
        }
        this.rejected = true;
        return this;
    }

    @Override
    public void close() {
        this.checkClosed();
        if (this.connectRunnable != null) {
            if (this.rejected) {
                throw new IllegalStateException("Cannot close websocket, it has been rejected");
            }
            if (!this.connected && !this.closed) {
                this.connect();
            }
        }
        super.close();
    }

    @Override
    public ServerWebSocket dataHandler(Handler<Buffer> handler) {
        this.checkClosed();
        this.dataHandler = handler;
        return this;
    }

    @Override
    public ServerWebSocket endHandler(Handler<Void> handler) {
        this.checkClosed();
        this.endHandler = handler;
        return this;
    }

    @Override
    public ServerWebSocket exceptionHandler(Handler<Throwable> handler) {
        this.checkClosed();
        this.exceptionHandler = handler;
        return this;
    }

    @Override
    public ServerWebSocket closeHandler(Handler<Void> handler) {
        this.checkClosed();
        this.closeHandler = handler;
        return this;
    }

    @Override
    public ServerWebSocket frameHandler(Handler<WebSocketFrame> handler) {
        this.checkClosed();
        this.frameHandler = handler;
        return this;
    }

    @Override
    public ServerWebSocket pause() {
        this.checkClosed();
        this.conn.doPause();
        return this;
    }

    @Override
    public ServerWebSocket resume() {
        this.checkClosed();
        this.conn.doResume();
        return this;
    }

    @Override
    public ServerWebSocket setWriteQueueMaxSize(int maxSize) {
        this.checkClosed();
        this.conn.doSetWriteQueueMaxSize(maxSize);
        return this;
    }

    @Override
    public boolean writeQueueFull() {
        this.checkClosed();
        return this.conn.doWriteQueueFull();
    }

    @Override
    public ServerWebSocket write(Buffer data) {
        this.writeBinaryFrame(data);
        return this;
    }

    @Override
    public ServerWebSocket drainHandler(Handler<Void> handler) {
        this.checkClosed();
        this.drainHandler = handler;
        return this;
    }

    @Override
    public ServerWebSocket writeBinaryFrame(Buffer data) {
        super.writeBinaryFrameInternal(data);
        return this;
    }

    @Override
    public ServerWebSocket writeTextFrame(String str) {
        super.writeTextFrameInternal(str);
        return this;
    }

    @Override
    protected void writeFrame(WebSocketFrame frame) {
        if (this.connectRunnable != null) {
            if (this.rejected) {
                throw new IllegalStateException("Cannot write to websocket, it has been rejected");
            }
            if (!this.connected && !this.closed) {
                this.connect();
            }
        }
        super.writeFrame(frame);
    }

    private void connect() {
        this.connectRunnable.run();
        this.connected = true;
    }

    void connectNow() {
        if (!this.connected && !this.rejected) {
            this.connect();
        }
    }

    boolean isRejected() {
        return this.rejected;
    }
}

