/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.platform.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.vertx.java.core.impl.ConcurrentHashSet;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.platform.impl.ModuleReference;

public class ModuleClassLoader
extends URLClassLoader {
    private static final Logger log = LoggerFactory.getLogger(ModuleClassLoader.class);
    public final String modID;
    private final Set<ModuleReference> references = new ConcurrentHashSet<ModuleReference>();
    private final ClassLoader platformClassLoader;
    private final boolean loadFromModuleFirst;
    private Set<ModuleClassLoader> modGraph;

    public ModuleClassLoader(String modID, ClassLoader platformClassLoader, URL[] classpath, boolean loadFromModuleFirst) {
        super(classpath);
        this.modID = modID;
        this.platformClassLoader = platformClassLoader;
        this.loadFromModuleFirst = loadFromModuleFirst;
    }

    public synchronized boolean addReference(ModuleReference reference) {
        if (!this.references.contains(reference)) {
            this.references.add(reference);
            this.modGraph = null;
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        for (ModuleReference ref : this.references) {
            ref.decRef();
        }
        this.references.clear();
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c != null) {
            return c;
        }
        if (this.loadFromModuleFirst) {
            try {
                c = this.loadFromModule(name);
            }
            catch (ClassNotFoundException e) {
                c = this.platformClassLoader.loadClass(name);
            }
        } else {
            try {
                c = this.platformClassLoader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                c = this.loadFromModule(name);
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    private Class<?> loadFromModule(String name) throws ClassNotFoundException {
        ModuleClassLoader cl;
        Class<?> c = null;
        Set<ModuleClassLoader> toWalk = this.getModulesToWalk();
        Iterator<ModuleClassLoader> i$ = toWalk.iterator();
        while (i$.hasNext() && (c = (cl = i$.next()).doLoadClass(name)) == null) {
        }
        if (c == null) {
            throw new ClassNotFoundException(name);
        }
        return c;
    }

    protected Class<?> doLoadClass(String name) {
        Class<?> c;
        block4: {
            c = this.findLoadedClass(name);
            if (c == null) {
                try {
                    c = this.findClass(name);
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
                catch (LinkageError le) {
                    c = this.findLoadedClass(name);
                    if (c != null) break block4;
                    throw le;
                }
            }
        }
        return c;
    }

    private Set<ModuleClassLoader> getModulesToWalk() {
        ClassLoader mcl = Thread.currentThread().getContextClassLoader();
        if (mcl instanceof ModuleClassLoader) {
            ModuleClassLoader mmcl = (ModuleClassLoader)mcl;
            return mmcl.getModuleGraph();
        }
        return this.getModuleGraph();
    }

    private Set<ModuleClassLoader> getModuleGraph() {
        if (this.modGraph == null) {
            this.modGraph = new LinkedHashSet<ModuleClassLoader>();
            this.modGraph.add(this);
            this.computeModules(this.modGraph);
        }
        return this.modGraph;
    }

    private void computeModules(Set<ModuleClassLoader> mods) {
        for (ModuleReference mod : this.references) {
            if (mods.contains(mod.mcl)) continue;
            mods.add(mod.mcl);
            mod.mcl.computeModules(mods);
        }
    }

    @Override
    public synchronized URL getResource(String name) {
        URL url = this.platformClassLoader.getResource(name);
        if (url == null) {
            Set<ModuleClassLoader> toWalk = this.getModulesToWalk();
            for (ModuleClassLoader cl : toWalk) {
                url = cl.findResource(name);
                if (url == null) continue;
                return url;
            }
        }
        return url;
    }

    @Override
    public synchronized Enumeration<URL> getResources(String name) throws IOException {
        final ArrayList<URL> totURLs = new ArrayList<URL>();
        this.addURLs(totURLs, this.platformClassLoader.getResources(name));
        Set<ModuleClassLoader> toWalk = this.getModulesToWalk();
        for (ModuleClassLoader cl : toWalk) {
            Enumeration<URL> urls = cl.findResources(name);
            this.addURLs(totURLs, urls);
        }
        return new Enumeration<URL>(){
            Iterator<URL> iter;
            {
                this.iter = totURLs.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.iter.hasNext();
            }

            @Override
            public URL nextElement() {
                return this.iter.next();
            }
        };
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        URL url = this.getResource(name);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void addURLs(List<URL> urls, Enumeration<URL> toAdd) {
        if (toAdd != null) {
            while (toAdd.hasMoreElements()) {
                urls.add(toAdd.nextElement());
            }
        }
    }

    private static final class LinkedHashSet<T>
    implements Set<T> {
        private final Object obj = new Object();
        private final Map<T, Object> map = new LinkedHashMap<T, Object>();

        private LinkedHashSet() {
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.map.containsKey(o);
        }

        @Override
        public Iterator<T> iterator() {
            return this.map.keySet().iterator();
        }

        @Override
        public Object[] toArray() {
            return this.map.keySet().toArray();
        }

        @Override
        public <T1> T1[] toArray(T1[] a) {
            return this.map.keySet().toArray(a);
        }

        @Override
        public boolean add(T t) {
            this.map.put(t, this.obj);
            return true;
        }

        @Override
        public boolean remove(Object o) {
            return this.map.remove(o) != null;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.map.keySet().containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            return false;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return false;
        }

        @Override
        public void clear() {
            this.map.clear();
        }
    }
}

