/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.http.impl.cgbystrom;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;

public class FlashPolicyHandler
extends ChannelInboundHandlerAdapter {
    private static final String XML = "<cross-domain-policy><allow-access-from domain=\"*\" to-ports=\"*\" /></cross-domain-policy>";
    private ParseState state = ParseState.MAGIC1;

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ByteBuf buffer = (ByteBuf)msg;
        int index = buffer.readerIndex();
        switch (this.state) {
            case MAGIC1: {
                if (!buffer.isReadable()) {
                    return;
                }
                short magic1 = buffer.getUnsignedByte(index++);
                this.state = ParseState.MAGIC2;
                if (magic1 != 60) {
                    ctx.fireChannelRead((Object)buffer);
                    ctx.pipeline().remove((ChannelHandler)this);
                    return;
                }
            }
            case MAGIC2: {
                if (!buffer.isReadable()) {
                    return;
                }
                short magic2 = buffer.getUnsignedByte(index);
                if (magic2 != 112) {
                    ctx.fireChannelRead((Object)buffer);
                    ctx.pipeline().remove((ChannelHandler)this);
                    break;
                }
                ctx.writeAndFlush((Object)Unpooled.copiedBuffer((CharSequence)XML, (Charset)CharsetUtil.UTF_8)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }
    }

    static enum ParseState {
        MAGIC1,
        MAGIC2;

    }
}

