/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.zookeeper.jgroups;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.utils.ZKPaths;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.protocols.FILE_PING;
import org.jgroups.protocols.PingData;
import org.jgroups.util.Util;

public abstract class AbstractZooKeeperPing
extends FILE_PING {
    private static final String ROOT_PATH = "/fabric/registry/jgroups/";
    private volatile String discoveryPath;
    private volatile String localNodePath;
    protected CuratorFramework curator;

    protected abstract CuratorFramework createCurator() throws KeeperException;

    protected CreateMode getCreateMode() throws KeeperException {
        return CreateMode.EPHEMERAL;
    }

    public void init() throws Exception {
        this.curator = this.createCurator();
        super.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            this.removeNode(this.localNodePath);
        }
        finally {
            super.stop();
        }
    }

    public Object down(Event evt) {
        switch (evt.getType()) {
            case 2: 
            case 80: 
            case 92: 
            case 93: {
                this.discoveryPath = ROOT_PATH + evt.getArg();
                this.localNodePath = this.discoveryPath + "/" + AbstractZooKeeperPing.addressAsString((Address)this.local_addr);
                this._createRootDir();
            }
        }
        return super.down(evt);
    }

    protected void createRootDir() {
    }

    protected void _createRootDir() {
        try {
            if (this.curator.checkExists().forPath(this.localNodePath) == null) {
                ((ACLBackgroundPathAndBytesable)this.curator.create().creatingParentsIfNeeded().withMode(this.getCreateMode())).forPath(this.localNodePath);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to create dir %s in ZooKeeper.", this.localNodePath), e);
        }
    }

    protected synchronized List<PingData> readAll(String clusterName) {
        ArrayList<PingData> retval = new ArrayList<PingData>();
        try {
            for (String node : (List)this.curator.getChildren().forPath(this.discoveryPath)) {
                String nodePath = ZKPaths.makePath((String)this.discoveryPath, (String)node);
                PingData nodeData = this.readPingData(nodePath);
                if (nodeData == null) continue;
                retval.add(nodeData);
            }
        }
        catch (Exception e) {
            this.log.debug(String.format("Failed to read ping data from ZooKeeper for cluster: %s", clusterName), (Throwable)e);
        }
        return retval;
    }

    protected synchronized void writeToFile(PingData data, String clustername) {
        this.writePingData(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected synchronized PingData readPingData(String path) {
        PingData pingData;
        PingData retval = null;
        DataInputStream in = null;
        try {
            byte[] bytes = (byte[])this.curator.getData().forPath(path);
            in = new DataInputStream(new ByteArrayInputStream(bytes));
            PingData tmp = new PingData();
            tmp.readFrom((DataInput)in);
            pingData = tmp;
        }
        catch (Exception e) {
            try {
                this.log.debug(String.format("Failed to read ZooKeeper znode: %s", path), (Throwable)e);
            }
            catch (Throwable throwable) {
                Util.close(in);
                throw throwable;
            }
            Util.close((InputStream)in);
            return retval;
        }
        Util.close((InputStream)in);
        return pingData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void writePingData(PingData data) {
        DataOutputStream dos;
        ByteArrayOutputStream baos;
        block5: {
            baos = new ByteArrayOutputStream();
            dos = null;
            try {
                dos = new DataOutputStream(baos);
                data.writeTo((DataOutput)dos);
                if (this.curator.checkExists().forPath(this.localNodePath) == null) {
                    ((ACLBackgroundPathAndBytesable)this.curator.create().creatingParentsIfNeeded().withMode(this.getCreateMode())).forPath(this.localNodePath, baos.toByteArray());
                    break block5;
                }
                this.curator.setData().forPath(this.localNodePath, baos.toByteArray());
            }
            catch (Exception ex) {
                try {
                    this.log.error("Error saving ping data", (Throwable)ex);
                }
                catch (Throwable throwable) {
                    Util.close(dos);
                    Util.close((OutputStream)baos);
                    throw throwable;
                }
                Util.close((OutputStream)dos);
                Util.close((OutputStream)baos);
            }
        }
        Util.close((OutputStream)dos);
        Util.close((OutputStream)baos);
    }

    protected void removeNode(String path) {
        try {
            this.curator.delete().forPath(path);
        }
        catch (KeeperException.NoNodeException e) {
            if (this.log.isTraceEnabled()) {
                this.log.trace(String.format("Node '%s' already removed: %s", new Object[]{path, e}));
            }
        }
        catch (Exception e) {
            this.log.error(String.format("Failed removing %s", path), (Throwable)e);
        }
    }

    protected void remove(String clustername, Address addr) {
        this.removeNode(this.discoveryPath + "/" + AbstractZooKeeperPing.addressAsString((Address)addr));
    }
}

