/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.zookeeper.jgroups;

import io.fabric8.zookeeper.jgroups.AbstractZooKeeperPing;
import org.apache.curator.RetryPolicy;
import org.apache.curator.ensemble.EnsembleProvider;
import org.apache.curator.ensemble.fixed.FixedEnsembleProvider;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.retry.RetryNTimes;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.Property;
import org.jgroups.conf.ClassConfigurator;

@MBean(description="ZooKeeper based discovery protocol. Acts as a ZooKeeper client and accesses ZooKeeper servers to fetch discovery information")
public class ConfigurableZooKeeperPing
extends AbstractZooKeeperPing {
    @Property
    protected String connection;
    @Property
    protected String password;
    @Property
    protected int connectionTimeout = 15000;
    @Property
    protected int sessionTimeout = 60000;
    @Property
    protected int maxRetry = 3;
    @Property
    protected int retryInterval = 500;
    @Property
    protected int mode = CreateMode.EPHEMERAL.toFlag();
    private ACLProvider aclProvider;

    @Override
    protected CreateMode getCreateMode() throws KeeperException {
        return CreateMode.fromFlag((int)this.mode);
    }

    @Override
    public void init() throws Exception {
        if (this.connection == null || this.connection.trim().isEmpty()) {
            throw new IllegalArgumentException("Missing connection property!");
        }
        super.init();
        this.curator.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            this.curator.close();
        }
        finally {
            super.destroy();
        }
    }

    protected String getScheme() {
        return "digest";
    }

    protected byte[] getAuth() {
        return this.password.getBytes();
    }

    @Override
    protected CuratorFramework createCurator() throws KeeperException {
        this.log.info(String.format("Creating curator [%s], mode: %s", this.connection, this.getCreateMode()));
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().ensembleProvider((EnsembleProvider)new FixedEnsembleProvider(this.connection)).connectionTimeoutMs(this.connectionTimeout).sessionTimeoutMs(this.sessionTimeout).retryPolicy((RetryPolicy)new RetryNTimes(this.maxRetry, this.retryInterval));
        if (this.password != null && this.password.length() > 0) {
            builder = builder.authorization(this.getScheme(), this.getAuth()).aclProvider(this.aclProvider);
        }
        return builder.build();
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setSessionTimeout(int sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public void setMaxRetry(int maxRetry) {
        this.maxRetry = maxRetry;
    }

    public void setRetryInterval(int retryInterval) {
        this.retryInterval = retryInterval;
    }

    public void setAclProvider(ACLProvider aclProvider) {
        this.aclProvider = aclProvider;
    }

    static {
        ClassConfigurator.addProtocol((short)1002, ConfigurableZooKeeperPing.class);
    }
}

