/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.war.internal;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.extender.war.internal.model.WebAppMimeMapping;
import org.ops4j.pax.web.extender.war.internal.util.Path;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WebAppHttpContext
implements HttpContext {
    final Logger log = LoggerFactory.getLogger(this.getClass());
    final Bundle bundle;
    final String rootPath;
    private final HttpContext httpContext;
    private final Map<String, String> mimeMappings;

    WebAppHttpContext(HttpContext httpContext, String rootPath, Bundle bundle, WebAppMimeMapping[] webAppMimeMappings) {
        NullArgumentException.validateNotNull(httpContext, "http context");
        NullArgumentException.validateNotNull(bundle, "Bundle");
        if (this.log.isDebugEnabled()) {
            this.log.debug("Creating WebAppHttpContext for {}", (Object)httpContext);
        }
        this.httpContext = httpContext;
        this.rootPath = rootPath;
        this.bundle = bundle;
        this.mimeMappings = new HashMap<String, String>();
        for (WebAppMimeMapping mimeMapping : webAppMimeMappings) {
            this.mimeMappings.put(mimeMapping.getExtension(), mimeMapping.getMimeType());
        }
    }

    public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return this.httpContext.handleSecurity(request, response);
    }

    public URL getResource(String name) {
        String normalizedName = Path.normalizeResourcePath(this.rootPath + (name.startsWith("/") ? "" : "/") + name);
        URL url = null;
        this.log.debug("Searching bundle " + this.bundle + " for resource [{}], normalized to [{}]", (Object)name, (Object)normalizedName);
        if (url == null && normalizedName != null && normalizedName.trim().length() > 0) {
            Enumeration e;
            String path = "";
            this.log.debug("getResource Failed, fallback uses findEntries");
            String file = normalizedName;
            int idx = file.lastIndexOf(47);
            if (idx > 0) {
                path = normalizedName.substring(0, idx);
                file = normalizedName.substring(idx + 1);
            }
            if ((e = this.bundle.findEntries(path, file, false)) != null && e.hasMoreElements()) {
                url = (URL)e.nextElement();
            }
        }
        if (url != null) {
            this.log.debug("Resource found as url [{}]", url);
        } else {
            this.log.debug("Resource not found");
        }
        return url;
    }

    public String getMimeType(String name) {
        String mimeType = null;
        if (name != null && name.length() > 0 && name.contains(".")) {
            String[] segments = name.split("\\.");
            mimeType = this.mimeMappings.get(segments[segments.length - 1]);
        }
        if (mimeType == null) {
            mimeType = this.httpContext.getMimeType(name);
        }
        return mimeType;
    }

    public String toString() {
        return "WebAppHttpContext{" + this.bundle.getSymbolicName() + " - " + this.bundle.getBundleId() + '}';
    }
}

