/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.io;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IO {
    public static void copy(InputStream in, OutputStream out) throws IOException {
        DataOutputStream dos = new DataOutputStream(out);
        IO.copy(in, dos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream in, DataOutput out) throws IOException {
        byte[] buffer = new byte[10000];
        try {
            int size = in.read(buffer);
            while (size > 0) {
                out.write(buffer, 0, size);
                size = in.read(buffer);
            }
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream in, ByteBuffer bb) throws IOException {
        byte[] buffer = new byte[10000];
        try {
            int size = in.read(buffer);
            while (size > 0) {
                bb.put(buffer, 0, size);
                size = in.read(buffer);
            }
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File a, File b) throws IOException {
        FileOutputStream out = new FileOutputStream(b);
        try {
            IO.copy((InputStream)new FileInputStream(a), (OutputStream)out);
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream a, File b) throws IOException {
        FileOutputStream out = new FileOutputStream(b);
        try {
            IO.copy(a, (OutputStream)out);
        }
        finally {
            out.close();
        }
    }

    public static void copy(File a, OutputStream b) throws IOException {
        IO.copy((InputStream)new FileInputStream(a), b);
    }

    public static String collect(File a, String encoding) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IO.copy(a, (OutputStream)out);
        return new String(out.toByteArray(), encoding);
    }

    public static String collect(URL a, String encoding) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IO.copy(a.openStream(), (OutputStream)out);
        return new String(out.toByteArray(), encoding);
    }

    public static String collect(File a) throws IOException {
        return IO.collect(a, "UTF-8");
    }

    public static String collect(InputStream a, String encoding) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IO.copy(a, (OutputStream)out);
        return new String(out.toByteArray(), encoding);
    }

    public static String collect(InputStream a) throws IOException {
        return IO.collect(a, "UTF-8");
    }

    public static String collect(Reader a) throws IOException {
        StringWriter sw = new StringWriter();
        char[] buffer = new char[10000];
        int size = a.read(buffer);
        while (size > 0) {
            sw.write(buffer, 0, size);
            size = a.read(buffer);
        }
        return sw.toString();
    }

    public static File getFile(File dir, String path) {
        int n = path.indexOf(47);
        if (n == 0) {
            return IO.getFile(File.listRoots()[0], path.substring(1));
        }
        if (n < 0) {
            return new File(dir, path);
        }
        String part = path.substring(0, n);
        String remainder = path.substring(n + 1);
        dir = new File(dir, part);
        return IO.getFile(dir, remainder);
    }

    public static void delete(File f) {
        if ((f = f.getAbsoluteFile()).getParentFile() == null) {
            throw new IllegalArgumentException("Cannot recursively delete root for safety reasons");
        }
        if (f.isDirectory()) {
            File[] subs;
            for (File sub : subs = f.listFiles()) {
                IO.delete(sub);
            }
        }
        IO.delete(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drain(InputStream in) throws IOException {
        byte[] buffer = new byte[10000];
        try {
            int size = in.read(buffer);
            while (size > 0) {
                size = in.read(buffer);
            }
        }
        finally {
            in.close();
        }
    }

    public void copy(Collection<?> c, OutputStream out) {
        PrintStream ps = new PrintStream(out);
        for (Object o : c) {
            ps.println(o);
        }
        ps.flush();
    }

    public static Throwable close(Closeable in) {
        try {
            in.close();
            return null;
        }
        catch (Throwable e) {
            return e;
        }
    }
}

