/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.osgi;

import aQute.bnd.make.Make;
import aQute.bnd.maven.PomResource;
import aQute.bnd.service.SignerPlugin;
import aQute.lib.osgi.Analyzer;
import aQute.lib.osgi.Clazz;
import aQute.lib.osgi.EmbeddedResource;
import aQute.lib.osgi.FileResource;
import aQute.lib.osgi.Instruction;
import aQute.lib.osgi.InstructionFilter;
import aQute.lib.osgi.Jar;
import aQute.lib.osgi.JarResource;
import aQute.lib.osgi.PreprocessResource;
import aQute.lib.osgi.Processor;
import aQute.lib.osgi.Resource;
import aQute.lib.osgi.Verifier;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.zip.ZipException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Builder
extends Analyzer {
    Pattern xdoNotCopy = null;
    private static final int SPLIT_MERGE_LAST = 1;
    private static final int SPLIT_MERGE_FIRST = 2;
    private static final int SPLIT_ERROR = 3;
    private static final int SPLIT_FIRST = 4;
    private static final int SPLIT_DEFAULT = 0;
    List<File> sourcePath = new ArrayList<File>();
    Make make = new Make(this);
    boolean firstUse = true;

    public Builder(Processor parent) {
        super(parent);
    }

    public Builder() {
    }

    public Jar build() throws Exception {
        this.init();
        if (Builder.isTrue(this.getProperty("-nobundles"))) {
            return null;
        }
        if (this.getProperty("-conduit") != null) {
            this.error("Specified -conduit but calls build() instead of builds() (might be a programmer error", new Object[0]);
        }
        this.dot = new Jar("dot");
        this.addClose(this.dot);
        try {
            long modified = Long.parseLong(this.getProperty("base.modified"));
            this.dot.updateModified(modified, "Base modified");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.doExpand(this.dot);
        this.doIncludeResources(this.dot);
        this.doConditional(this.dot);
        this.dot = this.doWab(this.dot);
        Manifest manifest = this.calcManifest();
        String mf = this.getProperty("-manifest");
        if (mf != null) {
            File mff = this.getFile(mf);
            if (mff.isFile()) {
                try {
                    FileInputStream in = new FileInputStream(mff);
                    manifest = new Manifest(in);
                    ((InputStream)in).close();
                }
                catch (Exception e) {
                    this.error("-manifest while reading manifest file", e, new Object[0]);
                }
            } else {
                this.error("-manifest, no such file " + mf, new Object[0]);
            }
        }
        if (this.getProperty("-nomanifest") == null) {
            this.dot.setManifest(manifest);
        } else {
            this.dot.setDoNotTouchManifest();
        }
        this.addSources(this.dot);
        if (this.getProperty("-pom") != null) {
            this.dot.putResource("pom.xml", new PomResource(this.dot.getManifest()));
        }
        if (!this.isNoBundle()) {
            this.doVerify(this.dot);
        }
        if (this.dot.getResources().isEmpty()) {
            this.error("The JAR is empty: " + this.dot.getName(), new Object[0]);
        }
        this.dot.updateModified(this.lastModified(), "Last Modified Processor");
        this.dot.setName(this.getBsn());
        this.sign(this.dot);
        this.doSaveManifest(this.dot);
        return this.dot;
    }

    public void init() throws Exception {
        this.begin();
        this.doRequireBnd();
    }

    private Jar doWab(Jar dot) throws Exception {
        String wab = this.getProperty("-wab");
        String wablib = this.getProperty("-wablib");
        if (wab == null && wablib == null) {
            return dot;
        }
        this.setProperty("Bundle-ClassPath", Builder.append("WEB-INF/classes", this.getProperty("Bundle-ClassPath")));
        Jar next = new Jar(dot.getName());
        this.addClose(next);
        for (Map.Entry<String, Resource> entry : dot.getResources().entrySet()) {
            String path = entry.getKey();
            if (path.indexOf(47) > 0 && !Character.isUpperCase(path.charAt(0))) {
                this.trace("wab: moving: %s", path);
                next.putResource("WEB-INF/classes/" + path, entry.getValue());
                continue;
            }
            this.trace("wab: not moving: %s", path);
            next.putResource(path, entry.getValue());
        }
        Map<String, Map<String, String>> clauses = this.parseHeader(this.getProperty("-wablib"));
        for (String key : clauses.keySet()) {
            File f = this.getFile(key);
            this.addWabLib(next, f);
        }
        this.doIncludeResource(next, wab);
        return next;
    }

    private void addWabLib(Jar dot, File f) throws Exception {
        if (f.exists()) {
            Jar jar = new Jar(f);
            jar.setDoNotTouchManifest();
            this.addClose(jar);
            String path = "WEB-INF/lib/" + f.getName();
            dot.putResource(path, new JarResource(jar));
            this.setProperty("Bundle-ClassPath", Builder.append(this.getProperty("Bundle-ClassPath"), path));
            Manifest m = jar.getManifest();
            String cp = m.getMainAttributes().getValue("Class-Path");
            if (cp != null) {
                Collection<String> parts = Builder.split(cp, ",");
                for (String part : parts) {
                    File sub = Builder.getFile(f.getParentFile(), part);
                    if (!sub.exists() || !sub.getParentFile().equals(f.getParentFile())) {
                        this.warning("Invalid Class-Path entry %s in %s, must exist and must reside in same directory", sub, f);
                        continue;
                    }
                    this.addWabLib(dot, sub);
                }
            }
        } else {
            this.error("WAB lib does not exist %s", f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSaveManifest(Jar dot) throws Exception {
        String output = this.getProperty("-savemanifest");
        if (output == null) {
            return;
        }
        File f = this.getFile(output);
        if (f.isDirectory()) {
            f = new File(f, "MANIFEST.MF");
        }
        f.delete();
        f.getParentFile().mkdirs();
        FileOutputStream out = new FileOutputStream(f);
        try {
            Jar.writeManifest(dot.getManifest(), out);
        }
        finally {
            ((OutputStream)out).close();
        }
        this.changedFile(f);
    }

    protected void changedFile(File f) {
    }

    void sign(Jar jar) throws Exception {
        String signing = this.getProperty("-sign");
        if (signing == null) {
            return;
        }
        this.trace("Signing %s, with %s", this.getBsn(), signing);
        List<SignerPlugin> signers = this.getPlugins(SignerPlugin.class);
        Map<String, Map<String, String>> infos = this.parseHeader(signing);
        for (Map.Entry<String, Map<String, String>> entry : infos.entrySet()) {
            for (SignerPlugin signer : signers) {
                signer.sign(this, entry.getKey());
            }
        }
    }

    public boolean hasSources() {
        return Builder.isTrue(this.getProperty("-sources"));
    }

    @Override
    protected String getImportPackages() {
        String ip = super.getImportPackages();
        if (ip != null) {
            return ip;
        }
        return "*";
    }

    private void doConditional(Jar dot) throws Exception {
        Map<String, Map<String, String>> conditionals = this.getHeader("Conditional-Package");
        if (conditionals.isEmpty()) {
            return;
        }
        while (true) {
            this.analyze();
            Map<String, Map<String, String>> imports = this.getImports();
            Map<String, Map<String, String>> filtered = Builder.merge("Conditional-Package", conditionals, imports, new HashSet<String>(), null);
            for (Map.Entry<String, Map<String, String>> entry : this.getImports().entrySet()) {
                String type = entry.getValue().get("-import:");
                if (type == null || !type.equals("private:")) continue;
                filtered.put(entry.getKey(), entry.getValue());
            }
            filtered.keySet().removeAll(dot.getPackages());
            if (filtered.size() == 0) break;
            int size = dot.getResources().size();
            this.doExpand(dot, "Conditional-Package Private imports", Instruction.replaceWithInstruction(filtered), false);
            if (size == dot.getResources().size()) break;
            this.analyzed = false;
        }
    }

    @Override
    public void analyze() throws Exception {
        super.analyze();
        this.cleanupVersion(this.imports, null);
        this.cleanupVersion(this.exports, this.getVersion());
        String version = this.getProperty("Bundle-Version");
        if (version != null) {
            this.setProperty("Bundle-Version", Builder.cleanupVersion(version));
        }
    }

    public void cleanupVersion(Map<String, Map<String, String>> mapOfMap, String defaultVersion) {
        for (Map.Entry<String, Map<String, String>> entry : mapOfMap.entrySet()) {
            Map<String, String> attributes = entry.getValue();
            String v = attributes.get("version");
            if (v == null && defaultVersion != null) {
                if (!Builder.isTrue(this.getProperty("-nodefaultversion"))) {
                    v = defaultVersion;
                    if (this.isPedantic()) {
                        this.warning("Used bundle version %s for exported package %s", v, entry.getKey());
                    }
                } else if (this.isPedantic()) {
                    this.warning("No export version for exported package %s", entry.getKey());
                }
            }
            if (v == null) continue;
            attributes.put("version", Builder.cleanupVersion(v));
        }
    }

    private void addSources(Jar dot) {
        if (!this.hasSources()) {
            return;
        }
        HashSet<String> packages = new HashSet<String>();
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.getProperties().store(out, "Generated by BND, at " + new Date());
            dot.putResource("OSGI-OPT/bnd.bnd", new EmbeddedResource(out.toByteArray(), 0L));
            out.close();
        }
        catch (Exception e) {
            this.error("Can not embed bnd file in JAR: " + e, new Object[0]);
        }
        for (String path : this.classspace.keySet()) {
            String pack = this.getPackage(path = path.substring(0, path.length() - ".class".length()) + ".java").replace('.', '/');
            if (pack.length() > 1) {
                pack = pack + "/";
            }
            boolean found = false;
            String[] fixed = new String[]{"packageinfo", "package.html", "module-info.java", "package-info.java"};
            for (File root : this.getSourcePath()) {
                File f = Builder.getFile(root, path);
                if (!f.exists()) continue;
                found = true;
                if (!packages.contains(pack)) {
                    packages.add(pack);
                    File bdir = Builder.getFile(root, pack);
                    for (int j = 0; j < fixed.length; ++j) {
                        File ff = Builder.getFile(bdir, fixed[j]);
                        if (!ff.isFile()) continue;
                        dot.putResource("OSGI-OPT/src/" + pack + fixed[j], new FileResource(ff));
                    }
                }
                dot.putResource("OSGI-OPT/src/" + path, new FileResource(f));
            }
            if (!found) {
                for (Jar jar : this.classpath) {
                    Resource resource = jar.getResource(path);
                    if (resource != null) {
                        dot.putResource("OSGI-OPT/src", resource);
                        continue;
                    }
                    resource = jar.getResource("OSGI-OPT/src/" + path);
                    if (resource == null) continue;
                    dot.putResource("OSGI-OPT/src", resource);
                }
            }
            if (!this.getSourcePath().isEmpty()) continue;
            this.warning("Including sources but -sourcepath does not contain any source directories ", new Object[0]);
        }
    }

    public Collection<File> getSourcePath() {
        if (this.firstUse) {
            this.firstUse = false;
            String sp = this.getProperty("-sourcepath");
            if (sp != null) {
                Map<String, Map<String, String>> map = this.parseHeader(sp);
                for (String file : map.keySet()) {
                    if (Builder.isDuplicate(file)) continue;
                    File f = this.getFile(file);
                    if (!f.isDirectory()) {
                        this.error("Adding a sourcepath that is not a directory: " + f, new Object[0]);
                        continue;
                    }
                    this.sourcePath.add(f);
                }
            }
        }
        return this.sourcePath;
    }

    private void doVerify(Jar dot) throws Exception {
        Verifier verifier = new Verifier(dot, this.getProperties());
        verifier.setPedantic(this.isPedantic());
        verifier.setClassSpace(this.classspace, this.contained, this.referred, this.uses);
        verifier.verify();
        this.getInfo(verifier);
    }

    private void doExpand(Jar jar) throws IOException {
        if (this.getClasspath().size() == 0 && (this.getProperty("Export-Package") != null || this.getProperty("Export-Package") != null || this.getProperty("Private-Package") != null)) {
            this.warning("Classpath is empty. Private-Package and Export-Package can only expand from the classpath when there is one", new Object[0]);
        }
        Map<Instruction, Map<String, String>> privateMap = Instruction.replaceWithInstruction(this.getHeader("Private-Package"));
        Map<Instruction, Map<String, String>> exportMap = Instruction.replaceWithInstruction(this.getHeader("Export-Package"));
        if (Builder.isTrue(this.getProperty("-undertest"))) {
            privateMap.putAll(Instruction.replaceWithInstruction(this.parseHeader(this.getProperty("-testpackages", "test;presence:=optional"))));
        }
        if (!privateMap.isEmpty()) {
            this.doExpand(jar, "Private-Package, or -testpackages", privateMap, true);
        }
        if (!exportMap.isEmpty()) {
            Jar exports = new Jar("exports");
            this.doExpand(exports, "Export-Package", exportMap, true);
            jar.addAll(exports);
            exports.close();
        }
        if (!this.isNoBundle() && privateMap.isEmpty() && exportMap.isEmpty() && !this.isResourceOnly() && this.getProperty("-exportcontents") == null) {
            this.warning("None of Export-Package, Provide-Package, Private-Package, -testpackages, or -exportcontents is set, therefore no packages will be included", new Object[0]);
        }
    }

    private void doExpand(Jar jar, String name, Map<Instruction, Map<String, String>> instructions, boolean mandatory) {
        Set<Instruction> superfluous = this.removeMarkedDuplicates(instructions.keySet());
        for (Jar now : this.getClasspath()) {
            this.doExpand(jar, instructions, now, superfluous);
        }
        if (mandatory && superfluous.size() > 0) {
            StringBuilder sb = new StringBuilder();
            String del = "Instructions in " + name + " that are never used: ";
            for (Instruction p : superfluous) {
                sb.append(del);
                sb.append(p.toString());
                del = "\n                ";
            }
            sb.append("\nClasspath: ");
            sb.append(Processor.join(this.getClasspath()));
            sb.append("\n");
            this.warning(sb.toString(), new Object[0]);
            if (this.isPedantic()) {
                this.diagnostics = true;
            }
        }
    }

    private void doExpand(Jar jar, Map<Instruction, Map<String, String>> included, Jar classpathEntry, Set<Instruction> superfluous) {
        block6: for (Map.Entry<String, Map<String, Resource>> directory : classpathEntry.getDirectories().entrySet()) {
            String pack;
            Instruction instr;
            String path = directory.getKey();
            if (this.doNotCopy(this.getName(path)) || directory.getValue() == null || (instr = this.matches(included, pack = path.replace('/', '.'), superfluous, classpathEntry.getName())) == null || instr.isNegated()) continue;
            Map<String, Resource> contents = directory.getValue();
            boolean overwriteResource = true;
            if (jar.hasDirectory(path)) {
                Map<String, String> directives = included.get(instr);
                switch (this.getSplitStrategy(directives.get("-split-package:"))) {
                    case 1: {
                        overwriteResource = true;
                        break;
                    }
                    case 2: {
                        overwriteResource = false;
                        break;
                    }
                    case 3: {
                        this.error(this.diagnostic(pack, this.getClasspath(), classpathEntry.source), new Object[0]);
                        continue block6;
                    }
                    case 4: {
                        continue block6;
                    }
                    default: {
                        this.warning(this.diagnostic(pack, this.getClasspath(), classpathEntry.source), new Object[0]);
                        overwriteResource = false;
                    }
                }
            }
            jar.addDirectory(contents, overwriteResource);
            String key = path + "/bnd.info";
            Resource r = jar.getResource(key);
            if (r != null) {
                jar.putResource(key, new PreprocessResource(this, r));
            }
            if (!this.hasSources()) continue;
            String srcPath = "OSGI-OPT/src/" + path;
            Map<String, Resource> srcContents = classpathEntry.getDirectories().get(srcPath);
            if (srcContents == null) continue;
            jar.addDirectory(srcContents, overwriteResource);
        }
    }

    private String diagnostic(String pack, List<Jar> classpath, File source) {
        pack = pack.replace('.', '/');
        ArrayList<Jar> culprits = new ArrayList<Jar>();
        for (Jar culprit : classpath) {
            if (!culprit.getDirectories().containsKey(pack)) continue;
            culprits.add(culprit);
        }
        return "Split package " + pack + "\nUse directive -split-package:=(merge-first|merge-last|error|first) on Export/Private Package instruction to get rid of this warning\n" + "Package found in   " + culprits + "\n" + "Reference from     " + source + "\n" + "Classpath          " + classpath;
    }

    private int getSplitStrategy(String type) {
        if (type == null) {
            return 0;
        }
        if (type.equals("merge-last")) {
            return 1;
        }
        if (type.equals("merge-first")) {
            return 2;
        }
        if (type.equals("error")) {
            return 3;
        }
        if (type.equals("first")) {
            return 4;
        }
        this.error("Invalid strategy for split-package: " + type, new Object[0]);
        return 0;
    }

    private Instruction matches(Map<Instruction, Map<String, String>> instructions, String pack, Set<Instruction> superfluousPatterns, String source) {
        for (Map.Entry<Instruction, Map<String, String>> entry : instructions.entrySet()) {
            Instruction f;
            Instruction pattern = entry.getKey();
            String from = entry.getValue().get("from:");
            if (from != null && (!(f = Instruction.getPattern(from)).matches(source) || f.isNegated())) {
                return null;
            }
            if (!pattern.matches(pack)) continue;
            if (superfluousPatterns != null) {
                superfluousPatterns.remove(pattern);
            }
            return pattern;
        }
        return null;
    }

    private Map<String, Map<String, String>> getHeader(String string) {
        if (string == null) {
            return Collections.emptyMap();
        }
        return this.parseHeader(this.getProperty(string));
    }

    private void doIncludeResources(Jar jar) throws Exception {
        String includes = this.getProperty("Bundle-Includes");
        if (includes == null) {
            includes = this.getProperty("-includeresource");
            if (includes == null || includes.length() == 0) {
                includes = this.getProperty("Include-Resource");
            }
        } else {
            this.warning("Please use -includeresource instead of Bundle-Includes", new Object[0]);
        }
        this.doIncludeResource(jar, includes);
    }

    private void doIncludeResource(Jar jar, String includes) throws Exception {
        Map<String, Map<String, String>> clauses = this.parseHeader(includes);
        this.doIncludeResource(jar, clauses);
    }

    private void doIncludeResource(Jar jar, Map<String, Map<String, String>> clauses) throws ZipException, IOException, Exception {
        for (Map.Entry<String, Map<String, String>> entry : clauses.entrySet()) {
            this.doIncludeResource(jar, entry.getKey(), entry.getValue());
        }
    }

    private void doIncludeResource(Jar jar, String name, Map<String, String> extra) throws ZipException, IOException, Exception {
        boolean preprocess = false;
        if (name.startsWith("{") && name.endsWith("}")) {
            preprocess = true;
            name = name.substring(1, name.length() - 1).trim();
        }
        String[] parts = name.split("\\s*=\\s*");
        String source = parts[0];
        String destination = parts[0];
        if (parts.length == 2) {
            source = parts[1];
        }
        if (source.startsWith("@")) {
            this.extractFromJar(jar, source.substring(1), parts.length == 1 ? "" : destination);
        } else if (extra.containsKey("literal")) {
            String literal = extra.get("literal");
            EmbeddedResource r = new EmbeddedResource(literal.getBytes("UTF-8"), 0L);
            String x = extra.get("extra");
            if (x != null) {
                r.setExtra(x);
            }
            jar.putResource(name, r);
        } else {
            File sourceFile = this.getFile(source);
            String destinationPath = parts.length == 1 ? (sourceFile.isDirectory() ? "" : sourceFile.getName()) : parts[0];
            if (sourceFile.isDirectory()) {
                destinationPath = this.doResourceDirectory(jar, extra, preprocess, sourceFile, destinationPath);
                return;
            }
            if (!sourceFile.exists()) {
                this.noSuchFile(jar, name, extra, source, destinationPath);
            } else {
                this.copy(jar, destinationPath, sourceFile, preprocess, extra);
            }
        }
    }

    private String doResourceDirectory(Jar jar, Map<String, String> extra, boolean preprocess, File sourceFile, String destinationPath) throws Exception {
        String filter = extra.get("filter:");
        boolean flatten = Builder.isTrue(extra.get("flatten:"));
        boolean recursive = true;
        String directive = extra.get("recursive:");
        if (directive != null) {
            recursive = Builder.isTrue(directive);
        }
        InstructionFilter iFilter = null;
        iFilter = filter != null ? new InstructionFilter(Instruction.getPattern(filter), recursive, this.getDoNotCopy()) : new InstructionFilter(null, recursive, this.getDoNotCopy());
        Map<String, File> files = Builder.newMap();
        this.resolveFiles(sourceFile, iFilter, recursive, destinationPath, files, flatten);
        for (Map.Entry<String, File> entry : files.entrySet()) {
            this.copy(jar, entry.getKey(), entry.getValue(), preprocess, extra);
        }
        return destinationPath;
    }

    private void resolveFiles(File dir, FileFilter filter, boolean recursive, String path, Map<String, File> files, boolean flatten) {
        File[] fs;
        if (this.doNotCopy(dir.getName())) {
            return;
        }
        for (File file : fs = dir.listFiles(filter)) {
            if (file.isDirectory()) {
                if (!recursive) continue;
                String nextPath = flatten ? path : Builder.appendPath(path, file.getName());
                this.resolveFiles(file, filter, recursive, nextPath, files, flatten);
                continue;
            }
            String p = Builder.appendPath(path, file.getName());
            if (files.containsKey(p)) {
                this.warning("Include-Resource overwrites entry %s from file %s", p, file);
            }
            files.put(p, file);
        }
    }

    private void noSuchFile(Jar jar, String clause, Map<String, String> extra, String source, String destinationPath) throws Exception {
        Jar src = this.getJarFromName(source, "Include-Resource " + source);
        if (src != null) {
            JarResource jarResource = new JarResource(src);
            jar.putResource(destinationPath, jarResource);
        } else {
            Resource lastChance = this.make.process(source);
            if (lastChance != null) {
                String x = extra.get("extra");
                if (x != null) {
                    lastChance.setExtra(x);
                }
                jar.putResource(destinationPath, lastChance);
            } else {
                this.error("Input file does not exist: " + source, new Object[0]);
            }
        }
    }

    private void extractFromJar(Jar jar, String source, String destination) throws ZipException, IOException {
        Jar sub;
        int n = source.lastIndexOf("!/");
        Instruction instr = null;
        if (n > 0) {
            instr = Instruction.getPattern(source.substring(n + 2));
            source = source.substring(0, n);
        }
        if ((sub = this.getJarFromName(source, "extract from jar")) == null) {
            this.error("Can not find JAR file " + source, new Object[0]);
        } else {
            jar.addAll(sub, instr, destination);
        }
    }

    private void copy(Jar jar, String path, File from, boolean preprocess, Map<String, String> extra) throws Exception {
        if (this.doNotCopy(from.getName())) {
            return;
        }
        if (from.isDirectory()) {
            File[] files = from.listFiles();
            for (int i = 0; i < files.length; ++i) {
                this.copy(jar, Builder.appendPath(path, files[i].getName()), files[i], preprocess, extra);
            }
        } else if (from.exists()) {
            String x;
            Resource resource = new FileResource(from);
            if (preprocess) {
                resource = new PreprocessResource(this, resource);
            }
            if ((x = extra.get("extra")) != null) {
                resource.setExtra(x);
            }
            if (path.endsWith("/")) {
                path = path + from.getName();
            }
            jar.putResource(path, resource);
            if (Builder.isTrue(extra.get("lib:"))) {
                this.setProperty("Bundle-ClassPath", Builder.append(this.getProperty("Bundle-ClassPath"), path));
            }
        } else {
            this.error("Input file does not exist: " + from, new Object[0]);
        }
    }

    private String getName(String where) {
        int n = where.lastIndexOf(47);
        if (n < 0) {
            return where;
        }
        return where.substring(n + 1);
    }

    public void setSourcepath(File[] files) {
        for (int i = 0; i < files.length; ++i) {
            this.addSourcepath(files[i]);
        }
    }

    public void addSourcepath(File cp) {
        if (!cp.exists()) {
            this.warning("File on sourcepath that does not exist: " + cp, new Object[0]);
        }
        this.sourcePath.add(cp);
    }

    @Override
    public void close() {
        super.close();
    }

    public Jar[] builds() throws Exception {
        this.begin();
        String conduit = this.getProperty("-conduit");
        if (conduit != null) {
            Map<String, Map<String, String>> map = this.parseHeader(conduit);
            Jar[] result = new Jar[map.size()];
            int n = 0;
            for (String file : map.keySet()) {
                Jar c = new Jar(this.getFile(file));
                this.addClose(c);
                String name = map.get(file).get("name");
                if (name != null) {
                    c.setName(name);
                }
                result[n++] = c;
            }
            return result;
        }
        ArrayList<Jar> result = new ArrayList<Jar>();
        List<Builder> builders = this.getSubBuilders();
        for (Builder builder : builders) {
            try {
                Jar jar = builder.build();
                jar.setName(builder.getBsn());
                result.add(jar);
            }
            catch (Exception e) {
                this.error("Sub Building " + builder.getBsn(), e, new Object[0]);
            }
            if (builder == this) continue;
            this.getInfo(builder, builder.getBsn() + ": ");
        }
        return result.toArray(new Jar[result.size()]);
    }

    public List<Builder> getSubBuilders() throws Exception {
        String sub = this.getProperty("-sub");
        if (sub == null || sub.trim().length() == 0 || "<<EMPTY>>".equals(sub)) {
            return Arrays.asList(this);
        }
        ArrayList<Builder> builders = new ArrayList<Builder>();
        if (Builder.isTrue(this.getProperty("-nobundles"))) {
            return builders;
        }
        Map<String, Map<String, String>> subsMap = this.parseHeader(sub);
        Iterator<String> i = subsMap.keySet().iterator();
        while (i.hasNext()) {
            File file = this.getFile(i.next());
            if (!file.isFile()) continue;
            builders.add(this.getSubBuilder(file));
            i.remove();
        }
        Set<Instruction> subs = Instruction.replaceWithInstruction(subsMap).keySet();
        ArrayList<File> members = new ArrayList<File>(Arrays.asList(this.getBase().listFiles()));
        block1: while (members.size() > 0) {
            File file = (File)members.remove(0);
            for (Processor p = this; p != null; p = p.getParent()) {
                if (file.equals(p.getPropertiesFile())) continue block1;
            }
            for (Instruction instruction : subs) {
                if (!instruction.matches(file.getName())) continue;
                if (instruction.isNegated()) continue block1;
                builders.add(this.getSubBuilder(file));
                continue block1;
            }
        }
        return builders;
    }

    public Builder getSubBuilder(File file) throws Exception {
        Builder builder = this.getSubBuilder();
        if (builder != null) {
            builder.setProperties(file);
            this.addClose(builder);
        }
        return builder;
    }

    public Builder getSubBuilder() throws Exception {
        Builder builder = new Builder(this);
        builder.setBase(this.getBase());
        for (Jar file : this.getClasspath()) {
            builder.addClasspath(file);
        }
        return builder;
    }

    public String _maven_version(String[] args) {
        if (args.length > 2) {
            this.error("${maven_version} macro receives too many arguments " + Arrays.toString(args), new Object[0]);
        } else if (args.length < 2) {
            this.error("${maven_version} macro has no arguments, use ${maven_version;1.2.3-SNAPSHOT}", new Object[0]);
        } else {
            return Builder.cleanupVersion(args[1]);
        }
        return null;
    }

    public String _permissions(String[] args) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (String arg : args) {
            if ("packages".equals(arg) || "all".equals(arg)) {
                for (String imp : this.getImports().keySet()) {
                    if (imp.startsWith("java.")) continue;
                    sb.append("(org.osgi.framework.PackagePermission \"");
                    sb.append(imp);
                    sb.append("\" \"import\")\r\n");
                }
                for (String exp : this.getExports().keySet()) {
                    sb.append("(org.osgi.framework.PackagePermission \"");
                    sb.append(exp);
                    sb.append("\" \"export\")\r\n");
                }
                continue;
            }
            if ("admin".equals(arg) || "all".equals(arg)) {
                sb.append("(org.osgi.framework.AdminPermission)");
                continue;
            }
            if ("permissions".equals(arg)) continue;
            this.error("Invalid option in ${permissions}: %s", arg);
        }
        return sb.toString();
    }

    public void removeBundleSpecificHeaders() {
        HashSet<String> set = new HashSet<String>(Arrays.asList(BUNDLE_SPECIFIC_HEADERS));
        this.setForceLocal(set);
    }

    public boolean isInScope(Collection<File> resources) throws Exception {
        Map<String, Map<String, String>> clauses = this.parseHeader(this.getProperty("Export-Package"));
        clauses.putAll(this.parseHeader(this.getProperty("Private-Package")));
        if (Builder.isTrue(this.getProperty("-undertest"))) {
            clauses.putAll(this.parseHeader(this.getProperty("-testpackages", "test;presence:=optional")));
        }
        Map<Instruction, Map<String, String>> instructions = Instruction.replaceWithInstruction(clauses);
        for (File r : resources) {
            String pack;
            Instruction i;
            String cpEntry = this.getClasspathEntrySuffix(r);
            if (cpEntry == null || (i = this.matches(instructions, pack = Clazz.getPackage(cpEntry), null, r.getName())) == null) continue;
            return !i.isNegated();
        }
        return false;
    }

    public String getClasspathEntrySuffix(File resource) throws Exception {
        for (Jar jar : this.getClasspath()) {
            File source = jar.getSource();
            if (source == null) continue;
            source = source.getCanonicalFile();
            String sourcePath = source.getAbsolutePath();
            String resourcePath = resource.getAbsolutePath();
            if (!resourcePath.startsWith(sourcePath)) continue;
            String filePath = resourcePath.substring(sourcePath.length() + 1);
            return filePath.replace(File.separatorChar, '/');
        }
        return null;
    }

    public boolean doNotCopy(String v) {
        return this.getDoNotCopy().matcher(v).matches();
    }

    public Pattern getDoNotCopy() {
        if (this.xdoNotCopy == null) {
            String string = null;
            try {
                string = this.getProperty("-donotcopy", "CVS|\\.svn|\\.git");
                this.xdoNotCopy = Pattern.compile(string);
            }
            catch (Exception e) {
                this.error("Invalid value for %s, value is %s", "-donotcopy", string);
                this.xdoNotCopy = Pattern.compile("CVS|\\.svn|\\.git");
            }
        }
        return this.xdoNotCopy;
    }
}

