/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent;

import io.fabric8.agent.DeploymentAgent;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.TimeUnit;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final String OBR_RESOLVE_OPTIONAL_IMPORTS = "obr.resolve.optional.imports";
    private static final String RESOLVE_OPTIONAL_IMPORTS = "resolve.optional.imports";
    private static final String URL_HANDLERS_TIMEOUT = "url.handlers.timeout";
    private static final Logger LOGGER = LoggerFactory.getLogger(Activator.class);
    private DeploymentAgent agent;
    private ServiceRegistration registration;

    public void start(BundleContext context) throws Exception {
        this.agent = new DeploymentAgent(context);
        Dictionary<String, Object> config = this.getConfig(context);
        this.agent.setResolveOptionalImports(this.getResolveOptionalImports(config));
        this.agent.setUrlHandlersTimeout(this.getUrlHandlersTimeout(config));
        this.agent.start();
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("service.pid", "io.fabric8.agent");
        this.registration = context.registerService(ManagedService.class.getName(), (Object)this.agent, props);
    }

    public void stop(BundleContext context) throws Exception {
        this.registration.unregister();
        this.agent.stop();
    }

    private boolean getResolveOptionalImports(Dictionary<String, Object> config) {
        if (config != null) {
            String str = (String)config.get(OBR_RESOLVE_OPTIONAL_IMPORTS);
            if (str == null) {
                str = (String)config.get(RESOLVE_OPTIONAL_IMPORTS);
            }
            if (str != null) {
                return Boolean.parseBoolean(str);
            }
        }
        return false;
    }

    private long getUrlHandlersTimeout(Dictionary<String, Object> config) {
        if (config != null) {
            Object timeout = config.get(URL_HANDLERS_TIMEOUT);
            if (timeout instanceof Number) {
                return ((Number)timeout).longValue();
            }
            if (timeout instanceof String) {
                return Long.parseLong((String)timeout);
            }
        }
        return TimeUnit.MILLISECONDS.convert(5L, TimeUnit.MINUTES);
    }

    private Dictionary<String, Object> getConfig(BundleContext bundleContext) {
        try {
            ConfigurationAdmin configAdmin;
            ServiceReference configAdminServiceReference = bundleContext.getServiceReference(ConfigurationAdmin.class.getName());
            if (configAdminServiceReference != null && (configAdmin = (ConfigurationAdmin)bundleContext.getService(configAdminServiceReference)) != null) {
                Configuration[] configuration = configAdmin.listConfigurations("(service.pid=io.fabric8.agent)");
                return configuration != null && configuration.length > 0 ? configuration[0].getProperties() : null;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Unable to retrieve agent configuration", (Throwable)e);
        }
        return null;
    }
}

