/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.jetty.internal;

import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ssl.SslSocketConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.service.jetty.internal.JettyFactory;
import org.ops4j.pax.web.service.jetty.internal.JettyServer;
import org.ops4j.pax.web.service.jetty.internal.JettyServerImpl;
import org.ops4j.pax.web.service.jetty.internal.NIOSocketConnectorWrapper;
import org.ops4j.pax.web.service.jetty.internal.SocketConnectorWrapper;
import org.ops4j.pax.web.service.spi.model.ServerModel;

class JettyFactoryImpl
implements JettyFactory {
    private final ServerModel serverModel;

    JettyFactoryImpl(ServerModel serverModel) {
        NullArgumentException.validateNotNull(serverModel, "Service model");
        this.serverModel = serverModel;
    }

    @Override
    public JettyServer createServer() {
        return new JettyServerImpl(this.serverModel);
    }

    @Override
    public Connector createConnector(String name, int port, String host, boolean useNIO) {
        if (useNIO) {
            NIOSocketConnectorWrapper nioConnector = new NIOSocketConnectorWrapper();
            nioConnector.setName(name);
            nioConnector.setHost(host);
            nioConnector.setPort(port);
            nioConnector.setUseDirectBuffers(true);
            return nioConnector;
        }
        SocketConnectorWrapper connector = new SocketConnectorWrapper();
        connector.setName(name);
        connector.setPort(port);
        connector.setHost(host);
        return connector;
    }

    @Override
    public Connector createSecureConnector(String name, int port, String sslKeystore, String sslPassword, String sslKeyPassword, String host, String sslKeystoreType, boolean isClientAuthNeeded, boolean isClientAuthWanted) {
        SslContextFactory sslContextFactory = new SslContextFactory(sslKeystore);
        sslContextFactory.setKeyStorePassword(sslKeyPassword);
        sslContextFactory.setKeyManagerPassword(sslPassword);
        sslContextFactory.setNeedClientAuth(isClientAuthNeeded);
        sslContextFactory.setWantClientAuth(isClientAuthWanted);
        if (sslKeystoreType != null) {
            sslContextFactory.setKeyStoreType(sslKeystoreType);
        }
        SslSocketConnector connector = new SslSocketConnector(sslContextFactory);
        connector.setName(name);
        connector.setPort(port);
        connector.setHost(host);
        connector.setConfidentialPort(port);
        return connector;
    }
}

