/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.MutableShardRouting;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.trove.map.hash.TObjectIntHashMap;

public class RoutingNodes
implements Iterable<RoutingNode> {
    private final MetaData metaData;
    private final ClusterBlocks blocks;
    private final RoutingTable routingTable;
    private final Map<String, RoutingNode> nodesToShards = Maps.newHashMap();
    private final List<MutableShardRouting> unassigned = Lists.newArrayList();
    private final List<MutableShardRouting> ignoredUnassigned = Lists.newArrayList();
    private final Map<String, TObjectIntHashMap<String>> nodesPerAttributeNames = new HashMap<String, TObjectIntHashMap<String>>();

    public RoutingNodes(ClusterState clusterState) {
        this.metaData = clusterState.metaData();
        this.blocks = clusterState.blocks();
        this.routingTable = clusterState.routingTable();
        HashMap nodesToShards = Maps.newHashMap();
        for (DiscoveryNode discoveryNode : clusterState.nodes().dataNodes().values()) {
            nodesToShards.put(discoveryNode.id(), new ArrayList());
        }
        for (IndexRoutingTable indexRoutingTable : this.routingTable.indicesRouting().values()) {
            for (IndexShardRoutingTable indexShard : indexRoutingTable) {
                for (ShardRouting shard : indexShard) {
                    if (shard.assignedToNode()) {
                        List<MutableShardRouting> entries = (ArrayList<MutableShardRouting>)nodesToShards.get(shard.currentNodeId());
                        if (entries == null) {
                            entries = Lists.newArrayList();
                            nodesToShards.put(shard.currentNodeId(), entries);
                        }
                        entries.add(new MutableShardRouting(shard));
                        if (!shard.relocating()) continue;
                        entries = (List)nodesToShards.get(shard.relocatingNodeId());
                        if (entries == null) {
                            entries = Lists.newArrayList();
                            nodesToShards.put(shard.relocatingNodeId(), entries);
                        }
                        entries.add(new MutableShardRouting(shard.index(), shard.id(), shard.relocatingNodeId(), shard.currentNodeId(), shard.primary(), ShardRoutingState.INITIALIZING, shard.version()));
                        continue;
                    }
                    this.unassigned.add(new MutableShardRouting(shard));
                }
            }
        }
        for (Map.Entry entry : nodesToShards.entrySet()) {
            String nodeId = (String)entry.getKey();
            this.nodesToShards.put(nodeId, new RoutingNode(nodeId, clusterState.nodes().get(nodeId), (List)entry.getValue()));
        }
    }

    @Override
    public Iterator<RoutingNode> iterator() {
        return this.nodesToShards.values().iterator();
    }

    public RoutingTable routingTable() {
        return this.routingTable;
    }

    public RoutingTable getRoutingTable() {
        return this.routingTable();
    }

    public MetaData metaData() {
        return this.metaData;
    }

    public MetaData getMetaData() {
        return this.metaData();
    }

    public ClusterBlocks blocks() {
        return this.blocks;
    }

    public ClusterBlocks getBlocks() {
        return this.blocks;
    }

    public int requiredAverageNumberOfShardsPerNode() {
        int totalNumberOfShards = 0;
        for (IndexMetaData indexMetaData : this.metaData.indices().values()) {
            if (indexMetaData.state() != IndexMetaData.State.OPEN) continue;
            totalNumberOfShards += indexMetaData.totalNumberOfShards();
        }
        return totalNumberOfShards / this.nodesToShards.size();
    }

    public boolean hasUnassigned() {
        return !this.unassigned.isEmpty();
    }

    public List<MutableShardRouting> ignoredUnassigned() {
        return this.ignoredUnassigned;
    }

    public List<MutableShardRouting> unassigned() {
        return this.unassigned;
    }

    public List<MutableShardRouting> getUnassigned() {
        return this.unassigned();
    }

    public Map<String, RoutingNode> nodesToShards() {
        return this.nodesToShards;
    }

    public Map<String, RoutingNode> getNodesToShards() {
        return this.nodesToShards();
    }

    public RoutingNode node(String nodeId) {
        return this.nodesToShards.get(nodeId);
    }

    public TObjectIntHashMap<String> nodesPerAttributesCounts(String attributeName) {
        TObjectIntHashMap<String> nodesPerAttributesCounts = this.nodesPerAttributeNames.get(attributeName);
        if (nodesPerAttributesCounts != null) {
            return nodesPerAttributesCounts;
        }
        nodesPerAttributesCounts = new TObjectIntHashMap();
        for (RoutingNode routingNode : this) {
            String attrValue = routingNode.node().attributes().get(attributeName);
            nodesPerAttributesCounts.adjustOrPutValue(attrValue, 1, 1);
        }
        this.nodesPerAttributeNames.put(attributeName, nodesPerAttributesCounts);
        return nodesPerAttributesCounts;
    }

    public MutableShardRouting findPrimaryForReplica(ShardRouting shard) {
        assert (!shard.primary());
        for (RoutingNode routingNode : this.nodesToShards.values()) {
            List<MutableShardRouting> shards = routingNode.shards();
            for (int i = 0; i < shards.size(); ++i) {
                MutableShardRouting shardRouting = shards.get(i);
                if (!shardRouting.shardId().equals(shard.shardId()) || !shardRouting.primary()) continue;
                return shardRouting;
            }
        }
        return null;
    }

    public List<MutableShardRouting> shardsRoutingFor(ShardRouting shardRouting) {
        return this.shardsRoutingFor(shardRouting.index(), shardRouting.id());
    }

    public List<MutableShardRouting> shardsRoutingFor(String index, int shardId) {
        ArrayList<MutableShardRouting> shards = Lists.newArrayList();
        for (RoutingNode routingNode : this) {
            List<MutableShardRouting> nShards = routingNode.shards();
            for (int i = 0; i < nShards.size(); ++i) {
                MutableShardRouting shardRouting = nShards.get(i);
                if (!shardRouting.index().equals(index) || shardRouting.id() != shardId) continue;
                shards.add(shardRouting);
            }
        }
        for (int i = 0; i < this.unassigned.size(); ++i) {
            MutableShardRouting shardRouting = this.unassigned.get(i);
            if (!shardRouting.index().equals(index) || shardRouting.id() != shardId) continue;
            shards.add(shardRouting);
        }
        return shards;
    }

    public int numberOfShardsOfType(ShardRoutingState state) {
        int count = 0;
        for (RoutingNode routingNode : this) {
            count += routingNode.numberOfShardsWithState(state);
        }
        return count;
    }

    public List<MutableShardRouting> shardsWithState(ShardRoutingState ... state) {
        ArrayList<MutableShardRouting> shards = Lists.newArrayList();
        for (RoutingNode routingNode : this) {
            shards.addAll(routingNode.shardsWithState(state));
        }
        return shards;
    }

    public List<MutableShardRouting> shardsWithState(String index, ShardRoutingState ... state) {
        ArrayList<MutableShardRouting> shards = Lists.newArrayList();
        for (RoutingNode routingNode : this) {
            shards.addAll(routingNode.shardsWithState(index, state));
        }
        return shards;
    }

    public String prettyPrint() {
        StringBuilder sb = new StringBuilder("routing_nodes:\n");
        for (RoutingNode routingNode : this) {
            sb.append(routingNode.prettyPrint());
        }
        sb.append("---- unassigned\n");
        for (MutableShardRouting shardEntry : this.unassigned) {
            sb.append("--------").append(shardEntry.shortSummary()).append('\n');
        }
        return sb.toString();
    }
}

