/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.UTF8StreamWriter;
import org.elasticsearch.common.io.stream.CachedStreamOutput;
import org.elasticsearch.common.joda.time.ReadableInstant;
import org.elasticsearch.common.text.Text;

public abstract class StreamOutput
extends OutputStream {
    private Version version = Version.CURRENT;
    private static byte ZERO = 0;
    private static byte ONE = 1;

    public Version getVersion() {
        return this.version;
    }

    public StreamOutput setVersion(Version version) {
        this.version = version;
        return this;
    }

    public boolean seekPositionSupported() {
        return false;
    }

    public long position() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void seek(long position) throws IOException {
        throw new UnsupportedOperationException();
    }

    public abstract void writeByte(byte var1) throws IOException;

    public void writeBytes(byte[] b) throws IOException {
        this.writeBytes(b, 0, b.length);
    }

    public void writeBytes(byte[] b, int length) throws IOException {
        this.writeBytes(b, 0, length);
    }

    public abstract void writeBytes(byte[] var1, int var2, int var3) throws IOException;

    public void writeBytesReference(@Nullable BytesReference bytes) throws IOException {
        if (bytes == null) {
            this.writeVInt(0);
            return;
        }
        this.writeVInt(bytes.length());
        bytes.writeTo(this);
    }

    public final void writeShort(short v) throws IOException {
        this.writeByte((byte)(v >> 8));
        this.writeByte((byte)v);
    }

    public void writeInt(int i) throws IOException {
        this.writeByte((byte)(i >> 24));
        this.writeByte((byte)(i >> 16));
        this.writeByte((byte)(i >> 8));
        this.writeByte((byte)i);
    }

    public void writeVInt(int i) throws IOException {
        while ((i & 0xFFFFFF80) != 0) {
            this.writeByte((byte)(i & 0x7F | 0x80));
            i >>>= 7;
        }
        this.writeByte((byte)i);
    }

    public void writeLong(long i) throws IOException {
        this.writeInt((int)(i >> 32));
        this.writeInt((int)i);
    }

    public void writeVLong(long i) throws IOException {
        while ((i & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.writeByte((byte)(i & 0x7FL | 0x80L));
            i >>>= 7;
        }
        this.writeByte((byte)i);
    }

    @Deprecated
    public void writeOptionalUTF(@Nullable String str) throws IOException {
        if (str == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeUTF(str);
        }
    }

    public void writeOptionalString(@Nullable String str) throws IOException {
        if (str == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeString(str);
        }
    }

    public void writeText(Text text) throws IOException {
        if (!text.hasBytes() && this.seekPositionSupported()) {
            long pos1 = this.position();
            this.seek(pos1 + 4L);
            UTF8StreamWriter utf8StreamWriter = CachedStreamOutput.utf8StreamWriter();
            utf8StreamWriter.setOutput(this);
            utf8StreamWriter.write(text.string());
            utf8StreamWriter.close();
            long pos2 = this.position();
            this.seek(pos1);
            this.writeInt((int)(pos2 - pos1 - 4L));
            this.seek(pos2);
        } else {
            BytesReference bytes = text.bytes();
            this.writeInt(bytes.length());
            bytes.writeTo(this);
        }
    }

    public void writeString(String str) throws IOException {
        int charCount = str.length();
        this.writeVInt(charCount);
        for (int i = 0; i < charCount; ++i) {
            char c = str.charAt(i);
            if (c <= '\u007f') {
                this.writeByte((byte)c);
                continue;
            }
            if (c > '\u07ff') {
                this.writeByte((byte)(0xE0 | c >> 12 & 0xF));
                this.writeByte((byte)(0x80 | c >> 6 & 0x3F));
                this.writeByte((byte)(0x80 | c >> 0 & 0x3F));
                continue;
            }
            this.writeByte((byte)(0xC0 | c >> 6 & 0x1F));
            this.writeByte((byte)(0x80 | c >> 0 & 0x3F));
        }
    }

    @Deprecated
    public void writeUTF(String str) throws IOException {
        this.writeString(str);
    }

    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public void writeBoolean(boolean b) throws IOException {
        this.writeByte(b ? ONE : ZERO);
    }

    @Override
    public abstract void flush() throws IOException;

    @Override
    public abstract void close() throws IOException;

    public abstract void reset() throws IOException;

    @Override
    public void write(int b) throws IOException {
        this.writeByte((byte)b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.writeBytes(b, off, len);
    }

    public void writeStringArray(String[] array) throws IOException {
        this.writeVInt(array.length);
        for (String s : array) {
            this.writeString(s);
        }
    }

    public void writeStringArrayNullable(@Nullable String[] array) throws IOException {
        if (array == null) {
            this.writeVInt(0);
        } else {
            this.writeVInt(array.length);
            for (String s : array) {
                this.writeString(s);
            }
        }
    }

    public void writeMap(@Nullable Map<String, Object> map) throws IOException {
        this.writeGenericValue(map);
    }

    public void writeGenericValue(@Nullable Object value) throws IOException {
        if (value == null) {
            this.writeByte((byte)-1);
            return;
        }
        Class<?> type = value.getClass();
        if (type == String.class) {
            this.writeByte((byte)0);
            this.writeString((String)value);
        } else if (type == Integer.class) {
            this.writeByte((byte)1);
            this.writeInt((Integer)value);
        } else if (type == Long.class) {
            this.writeByte((byte)2);
            this.writeLong((Long)value);
        } else if (type == Float.class) {
            this.writeByte((byte)3);
            this.writeFloat(((Float)value).floatValue());
        } else if (type == Double.class) {
            this.writeByte((byte)4);
            this.writeDouble((Double)value);
        } else if (type == Boolean.class) {
            this.writeByte((byte)5);
            this.writeBoolean((Boolean)value);
        } else if (type == byte[].class) {
            this.writeByte((byte)6);
            this.writeVInt(((byte[])value).length);
            this.writeBytes((byte[])value);
        } else if (value instanceof List) {
            this.writeByte((byte)7);
            List list = (List)value;
            this.writeVInt(list.size());
            for (Object o : list) {
                this.writeGenericValue(o);
            }
        } else if (value instanceof Object[]) {
            this.writeByte((byte)8);
            Object[] list = (Object[])value;
            this.writeVInt(list.length);
            for (Object o : list) {
                this.writeGenericValue(o);
            }
        } else if (value instanceof Map) {
            if (value instanceof LinkedHashMap) {
                this.writeByte((byte)9);
            } else {
                this.writeByte((byte)10);
            }
            Map map = (Map)value;
            this.writeVInt(map.size());
            for (Map.Entry entry : map.entrySet()) {
                this.writeString((String)entry.getKey());
                this.writeGenericValue(entry.getValue());
            }
        } else if (type == Byte.class) {
            this.writeByte((byte)11);
            this.writeByte((Byte)value);
        } else if (type == Date.class) {
            this.writeByte((byte)12);
            this.writeLong(((Date)value).getTime());
        } else if (value instanceof ReadableInstant) {
            this.writeByte((byte)13);
            this.writeLong(((ReadableInstant)value).getMillis());
        } else if (value instanceof BytesReference) {
            this.writeByte((byte)14);
            this.writeBytesReference((BytesReference)value);
        } else if (value instanceof Text) {
            this.writeByte((byte)15);
            this.writeText((Text)value);
        } else if (type == Short.class) {
            this.writeByte((byte)16);
            this.writeShort((Short)value);
        } else {
            throw new IOException("Can't write type [" + type + "]");
        }
    }
}

